/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.converted;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.teamlapen.vampirism.api.entity.BiteableEntry;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModTags;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BiteableEntryManager {
    private static final Logger LOGGER = LogManager.getLogger();
    @Nonnull
    private final Map<ResourceLocation, BiteableEntry> biteableEntries = Maps.newHashMap();
    @Nonnull
    private final Map<ResourceLocation, BiteableEntry> calculated = Maps.newHashMap();
    @Nonnull
    private final Set<ResourceLocation> blacklist = Sets.newHashSet();
    private boolean initialized = false;

    public void addCalculated(Map<ResourceLocation, Integer> map) {
        for (Map.Entry<ResourceLocation, Integer> e : map.entrySet()) {
            this.addCalculated(e.getKey(), e.getValue());
        }
    }

    @Nullable
    public BiteableEntry calculate(@Nonnull CreatureEntity creature) {
        if (!((Boolean)VampirismConfig.SERVER.autoCalculateEntityBlood.get()).booleanValue()) {
            return null;
        }
        EntityType type = creature.func_200600_R();
        ResourceLocation id = type.getRegistryName();
        if (id == null) {
            return null;
        }
        if (this.blacklist.contains(id)) {
            return null;
        }
        if (this.isEntityBlacklisted(creature)) {
            this.blacklist.add(id);
            return null;
        }
        AxisAlignedBB bb = creature.func_174813_aQ();
        double v = bb.field_72336_d - bb.field_72340_a;
        v *= bb.field_72337_e - bb.field_72338_b;
        v *= bb.field_72334_f - bb.field_72339_c;
        if (creature.func_70631_g_()) {
            v *= 8.0;
        }
        int blood = 0;
        if (v >= 0.3) {
            blood = (int)(v * 10.0);
            blood = Math.min(15, blood);
        }
        if (creature.func_110138_aP() > 50.0f) {
            blood = 0;
        }
        LOGGER.debug("Calculated size {} and blood value {} for entity {}", (Object)Float.valueOf((float)Math.round(v * 100.0) / 100.0f), (Object)blood, (Object)id);
        if (blood == 0) {
            this.blacklist.add(id);
            return null;
        }
        return this.addCalculated(id, blood);
    }

    private boolean isEntityBlacklisted(CreatureEntity creature) {
        if (!(creature instanceof AnimalEntity)) {
            return true;
        }
        if (creature instanceof IVampire) {
            return true;
        }
        EntityType type = creature.func_200600_R();
        if (type.func_220339_d() == EntityClassification.MONSTER || type.func_220339_d() == EntityClassification.WATER_CREATURE) {
            return true;
        }
        if (ModTags.Entities.VAMPIRE.func_199685_a_((Object)type)) {
            return true;
        }
        return this.isConfigBlackListed(type.getRegistryName());
    }

    private boolean isConfigBlackListed(ResourceLocation id) {
        List list = (List)VampirismConfig.SERVER.blacklistedBloodEntity.get();
        return list.contains(id.toString());
    }

    public Map<ResourceLocation, Integer> getValuesToSave() {
        HashMap map = Maps.newHashMap();
        for (Map.Entry<ResourceLocation, BiteableEntry> entry : this.calculated.entrySet()) {
            if (this.biteableEntries.containsKey(entry.getKey())) continue;
            map.put(entry.getKey(), entry.getValue().blood);
        }
        return map;
    }

    public boolean init() {
        return this.initialized;
    }

    private BiteableEntry addCalculated(ResourceLocation id, int blood) {
        BiteableEntry existing = this.calculated.containsKey(id) ? this.calculated.get(id).modifyBloodValue(blood) : new BiteableEntry(blood);
        this.calculated.put(id, existing);
        return existing;
    }

    @Nullable
    public BiteableEntry get(CreatureEntity creature) {
        if (!this.initialized) {
            return null;
        }
        EntityType type = creature.func_200600_R();
        ResourceLocation id = EntityType.func_200718_a((EntityType)type);
        if (this.isConfigBlackListed(id)) {
            return null;
        }
        if (this.biteableEntries.containsKey(id)) {
            return this.biteableEntries.get(id);
        }
        return this.calculated.getOrDefault(id, null);
    }

    void setNewBiteables(Map<ResourceLocation, BiteableEntry> biteableEntries, Set<ResourceLocation> blacklist) {
        this.biteableEntries.clear();
        this.blacklist.clear();
        this.biteableEntries.putAll(biteableEntries);
        this.blacklist.addAll(blacklist);
        this.initialized = true;
    }
}

