/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.converted;

import de.teamlapen.vampirism.api.entity.convertible.IConvertedCreature;
import de.teamlapen.vampirism.api.entity.convertible.IConvertingHandler;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.entity.converted.ConvertedCreatureEntity;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;

public class DefaultConvertingHandler<T extends CreatureEntity>
implements IConvertingHandler<T> {
    private static final IConvertingHandler.IDefaultHelper defaultHelper = new IConvertingHandler.IDefaultHelper(){

        public double getConvertedDMG(CreatureEntity entity) {
            IAttributeInstance dmg = entity.func_110148_a(SharedMonsterAttributes.field_111264_e);
            if (dmg != null) {
                return dmg.func_111125_b() * 1.3;
            }
            return BalanceMobProps.mobProps.CONVERTED_MOB_DEFAULT_DMG;
        }

        public double getConvertedKnockbackResistance(CreatureEntity entity) {
            return entity.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111125_b();
        }

        public double getConvertedMaxHealth(CreatureEntity entity) {
            return entity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() * 1.5;
        }

        public double getConvertedSpeed(CreatureEntity entity) {
            return Math.min(entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b() * 1.2, 2.9);
        }
    };
    protected final IConvertingHandler.IDefaultHelper helper;

    public DefaultConvertingHandler(@Nullable IConvertingHandler.IDefaultHelper helper) {
        this.helper = helper == null ? defaultHelper : helper;
    }

    @Override
    public IConvertedCreature<T> createFrom(T entity) {
        ConvertedCreatureEntity convertedCreature = (ConvertedCreatureEntity)ModEntities.converted_creature.func_200721_a(entity.func_130014_f_());
        this.copyImportantStuff(convertedCreature, entity);
        convertedCreature.func_195064_c(new EffectInstance(Effects.field_76437_t, 200, 2));
        return convertedCreature;
    }

    public IConvertingHandler.IDefaultHelper<T> getHelper() {
        return this.helper;
    }

    protected void copyImportantStuff(ConvertedCreatureEntity converted, T entity) {
        converted.func_82149_j((Entity)entity);
        converted.setEntityCreature(entity);
        converted.updateEntityAttributes();
        converted.func_70606_j(converted.func_110138_aP() / 3.0f * 2.0f);
    }
}

