/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.factions;

import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.api.entity.factions.IVillageFactionData;
import java.awt.Color;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class Faction<T extends IFactionEntity>
implements IFaction<T> {
    private static int nextId = 0;
    protected final ResourceLocation id;
    private final Class<T> entityInterface;
    private final Color color;
    private final boolean hostileTowardsNeutral;
    @Nullable
    private String translationKey;
    @Nullable
    private String translationKeyPlural;
    private int integerId;
    private TextFormatting chatColor;
    @Nonnull
    private final IVillageFactionData villageFactionData;

    Faction(ResourceLocation id, Class<T> entityInterface, Color color, boolean hostileTowardsNeutral, @Nonnull IVillageFactionData villageFactionData) {
        this.id = id;
        this.entityInterface = entityInterface;
        this.color = color;
        this.hostileTowardsNeutral = hostileTowardsNeutral;
        this.villageFactionData = villageFactionData;
        this.integerId = nextId++;
    }

    public boolean equals(Object obj) {
        return obj instanceof Faction && this.id == ((Faction)obj).id;
    }

    @Override
    public TextFormatting getChatColor() {
        return this.chatColor == null ? TextFormatting.WHITE : this.chatColor;
    }

    @Override
    public Faction<T> setChatColor(TextFormatting chatColor) {
        this.chatColor = chatColor;
        return this;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public Class<T> getFactionEntityInterface() {
        return this.entityInterface;
    }

    @Override
    public ResourceLocation getID() {
        return this.id;
    }

    @Override
    public ITextComponent getName() {
        return this.translationKey == null ? new StringTextComponent(this.id.toString()) : new TranslationTextComponent(this.translationKey, new Object[0]);
    }

    @Override
    public ITextComponent getNamePlural() {
        return this.translationKeyPlural == null ? new StringTextComponent(this.id.toString()) : new TranslationTextComponent(this.translationKeyPlural, new Object[0]);
    }

    public int hashCode() {
        return this.integerId;
    }

    @Override
    public boolean isEntityOfFaction(CreatureEntity creature) {
        return this.entityInterface.isInstance(creature);
    }

    @Override
    public boolean isHostileTowardsNeutral() {
        return this.hostileTowardsNeutral;
    }

    @Override
    public Faction<T> setTranslationKeys(String unlocalizedName, String unlocalizedNamePlural) {
        this.translationKey = unlocalizedName;
        this.translationKeyPlural = unlocalizedNamePlural;
        return this;
    }

    @Override
    @Nonnull
    public IVillageFactionData getVillageData() {
        return this.villageFactionData;
    }

    public String toString() {
        return "Faction{id='" + this.integerId + '\'' + ", hash=" + this.integerId + '}';
    }
}

