/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.factions;

import com.google.common.base.Predicate;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.entity.factions.Faction;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;

public class PredicateFaction
implements Predicate<LivingEntity> {
    private final IFaction thisFaction;
    private final boolean player;
    private final boolean nonPlayer;
    private final boolean neutralPlayer;
    private final boolean ignoreDisguise;
    @Nullable
    private final IFaction otherFaction;

    protected PredicateFaction(@Nonnull IFaction thisFaction, boolean player, boolean nonPlayer, boolean neutralPlayer, boolean ignoreDisguise, @Nullable IFaction otherFaction) {
        this.thisFaction = thisFaction;
        this.player = player;
        this.nonPlayer = nonPlayer;
        this.neutralPlayer = neutralPlayer;
        this.otherFaction = otherFaction;
        this.ignoreDisguise = ignoreDisguise;
    }

    protected PredicateFaction(Faction thisFaction, boolean player, boolean nonPlayer, boolean neutralPlayer, boolean ignoreDisguise) {
        this(thisFaction, player, nonPlayer, neutralPlayer, ignoreDisguise, null);
    }

    public boolean apply(@Nullable LivingEntity input) {
        if (input == null) {
            return false;
        }
        if (this.nonPlayer && input instanceof IFactionEntity) {
            IFaction other = ((IFactionEntity)input).getFaction();
            return !this.thisFaction.equals(other) && (this.otherFaction == null || this.otherFaction.equals(other));
        }
        if (this.player && input instanceof PlayerEntity && input.func_70089_S()) {
            IFaction f;
            IFactionPlayer fp = FactionPlayerHandler.get((PlayerEntity)input).getCurrentFactionPlayer().orElse(null);
            IFaction iFaction = fp == null ? null : (f = this.ignoreDisguise ? fp.getFaction() : fp.getDisguisedAs());
            if (f == null) {
                return this.neutralPlayer;
            }
            return !this.thisFaction.equals(f) && (this.otherFaction == null || this.otherFaction.equals(f));
        }
        return false;
    }

    public String toString() {
        return "PredicateFaction{thisFaction=" + this.thisFaction + ", player=" + this.player + ", nonPlayer=" + this.nonPlayer + ", neutralPlayer=" + this.neutralPlayer + ", otherFaction=" + this.otherFaction + '}';
    }
}

