/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.minion;

import com.google.common.collect.Lists;
import de.teamlapen.lib.HelperLib;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.api.entity.hunter.IHunter;
import de.teamlapen.vampirism.api.entity.minion.IMinionTask;
import de.teamlapen.vampirism.client.gui.HunterMinionAppearanceScreen;
import de.teamlapen.vampirism.client.gui.HunterMinionStatsScreen;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.VampirismEntity;
import de.teamlapen.vampirism.entity.goals.AttackRangedCrossbowGoal;
import de.teamlapen.vampirism.entity.minion.MinionEntity;
import de.teamlapen.vampirism.entity.minion.management.MinionData;
import de.teamlapen.vampirism.entity.minion.management.MinionTasks;
import de.teamlapen.vampirism.items.MinionUpgradeItem;
import de.teamlapen.vampirism.items.VampirismItemCrossbow;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class HunterMinionEntity
extends MinionEntity<HunterMinionData>
implements IHunter,
AttackRangedCrossbowGoal.IAttackWithCrossbow {
    private static final DataParameter<Boolean> RAISED_ARM = EntityDataManager.func_187226_a(HunterMinionEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private boolean crossbowTask = false;
    private AttackRangedCrossbowGoal<HunterMinionEntity> crossbowGoal;
    private MeleeAttackGoal meleeGoal;

    public static void init() {
    }

    public HunterMinionEntity(EntityType<? extends VampirismEntity> type, World world) {
        super(type, world, VampirismAPI.factionRegistry().getPredicate(VReference.HUNTER_FACTION, true, true, false, false, null).or(e -> !(e instanceof IFactionEntity) && e instanceof IMob));
    }

    @Override
    @Nonnull
    public ItemStack getArrowStackForAttack(LivingEntity target) {
        return new ItemStack((IItemProvider)ModItems.crossbow_arrow_normal);
    }

    @Override
    public List<IMinionTask<?, ?>> getAvailableTasks() {
        return Lists.newArrayList((Object[])new IMinionTask[]{MinionTasks.follow_lord, MinionTasks.defend_area, MinionTasks.stay, MinionTasks.collect_hunter_items, MinionTasks.protect_lord});
    }

    public int getHatType() {
        return this.func_184582_a(EquipmentSlotType.HEAD).func_190926_b() ? this.getMinionData().map(d -> ((HunterMinionData)d).hat).orElse(0) : -2;
    }

    public void setHatType(int type) {
        assert (type >= -2);
        this.getMinionData().ifPresent(d -> ((HunterMinionData)d).hat = type);
    }

    public int getHunterType() {
        return this.getMinionData().map(d -> ((HunterMinionData)d).type).map(t -> Math.max(0, t)).orElse(0);
    }

    public void setHunterType(int type) {
        assert (type >= 0);
        this.getMinionData().ifPresent(d -> ((HunterMinionData)d).type = type);
    }

    @Override
    public LivingEntity getRepresentingEntity() {
        return this;
    }

    @Override
    public boolean isCrossbowInMainhand() {
        return this.func_184614_ca().func_77973_b() instanceof VampirismItemCrossbow;
    }

    public boolean isSwingingArms() {
        return (Boolean)this.func_184212_Q().func_187225_a(RAISED_ARM);
    }

    protected void setSwingingArms(boolean b) {
        this.func_184212_Q().func_187227_b(RAISED_ARM, (Object)b);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70173_aa % 100 == 0) {
            this.updateAttackGoal();
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void openAppearanceScreen() {
        Minecraft.func_71410_x().func_147108_a((Screen)new HunterMinionAppearanceScreen(this, Minecraft.func_71410_x().field_71462_r));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void openStatsScreen() {
        Minecraft.func_71410_x().func_147108_a((Screen)new HunterMinionStatsScreen(this, Minecraft.func_71410_x().field_71462_r));
    }

    public void setUseLordSkin(boolean useLordSkin) {
        this.getMinionData().ifPresent(d -> ((HunterMinionData)d).useLordSkin = useLordSkin);
    }

    @Override
    public boolean shouldRenderLordSkin() {
        return this.getMinionData().map(d -> ((HunterMinionData)d).useLordSkin).orElse(false);
    }

    @Override
    public void startTargeting() {
        this.setSwingingArms(true);
    }

    @Override
    public void stopTargeting() {
        this.setSwingingArms(false);
    }

    @Override
    protected void onMinionDataReceived(@Nonnull HunterMinionData data) {
        super.onMinionDataReceived(data);
        this.updateAttackGoal();
        this.updateAttributes();
    }

    @Override
    protected boolean func_184645_a(PlayerEntity player, Hand hand) {
        ItemStack heldItem;
        if (!this.field_70170_p.func_201670_d() && this.isLord(player) && this.minionData != null && (heldItem = player.func_184586_b(hand)).func_77973_b() instanceof MinionUpgradeItem && ((MinionUpgradeItem)heldItem.func_77973_b()).getFaction() == this.getFaction()) {
            if (((HunterMinionData)this.minionData).level + 1 >= ((MinionUpgradeItem)heldItem.func_77973_b()).getMinLevel() && ((HunterMinionData)this.minionData).level + 1 <= ((MinionUpgradeItem)heldItem.func_77973_b()).getMaxLevel()) {
                ((HunterMinionData)this.minionData).level++;
                if (!player.field_71075_bZ.field_75098_d) {
                    heldItem.func_190918_g(1);
                }
                player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.hunter_minion.equipment_upgrade", new Object[0]), false);
                HelperLib.sync(this);
            } else {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("text.vampirism.hunter_minion.equipment_wrong", new Object[0]));
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.updateAttributes();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(RAISED_ARM, (Object)false);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.meleeGoal = new MeleeAttackGoal((CreatureEntity)this, 1.0, false);
        this.crossbowGoal = new AttackRangedCrossbowGoal<HunterMinionEntity>(this, 0.8, 60, 25.0f);
        this.field_70714_bg.func_75776_a(1, (Goal)this.meleeGoal);
    }

    private void updateAttackGoal() {
        if (this.field_70170_p.func_201670_d()) {
            return;
        }
        boolean usingCrossbow = this.isCrossbowInMainhand();
        if (this.crossbowTask && !usingCrossbow) {
            this.field_70714_bg.func_85156_a(this.crossbowGoal);
            this.field_70714_bg.func_75776_a(1, (Goal)this.meleeGoal);
            this.crossbowTask = false;
        } else if (!this.crossbowTask && usingCrossbow) {
            this.field_70714_bg.func_85156_a((Goal)this.meleeGoal);
            this.field_70714_bg.func_75776_a(1, this.crossbowGoal);
            this.crossbowTask = true;
        }
    }

    private void updateAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(BalanceMobProps.mobProps.MINION_MAX_HEALTH + (double)BalanceMobProps.mobProps.ADVANCED_VAMPIRE_MAX_FOLLOWER * (double)this.getMinionData().map(HunterMinionData::getHealthLevel).orElse(0).intValue());
        IAttributeInstance iAttributeInstance = this.func_110148_a(SharedMonsterAttributes.field_111264_e);
        BalanceMobProps.mobProps.getClass();
        iAttributeInstance.func_111128_a(3.0 + (double)BalanceMobProps.mobProps.CONVERTED_MOB_DEFAULT_DMG * (double)this.getMinionData().map(HunterMinionData::getStrengthLevel).orElse(0).intValue());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(BalanceMobProps.mobProps.VAMPIRE_HUNTER_SPEED);
    }

    static {
        MinionData.registerDataType(HunterMinionData.ID, () -> new HunterMinionData());
    }

    public static class HunterMinionData
    extends MinionData {
        public static final ResourceLocation ID = new ResourceLocation("vampirism", "hunter");
        public static final int MAX_LEVEL = 6;
        public static final int MAX_LEVEL_INVENTORY = 2;
        public static final int MAX_LEVEL_HEALTH = 3;
        public static final int MAX_LEVEL_STRENGTH = 3;
        public static final int MAX_LEVEL_RESOURCES = 2;
        private int type;
        private int hat;
        private boolean useLordSkin;
        private int level;
        private int inventoryLevel;
        private int healthLevel;
        private int strengthLevel;
        private int resourceEfficiencyLevel;

        public HunterMinionData(String name, int type, int hat, boolean useLordSkin) {
            super(name, 9);
            this.type = type;
            this.hat = hat;
            this.useLordSkin = useLordSkin;
            this.level = 0;
        }

        private HunterMinionData() {
        }

        @Override
        public void deserializeNBT(CompoundNBT nbt) {
            super.deserializeNBT(nbt);
            this.type = nbt.func_74762_e("hunter_type");
            this.hat = nbt.func_74762_e("hunter_hat");
            this.level = nbt.func_74762_e("level");
            this.useLordSkin = nbt.func_74767_n("use_lord_skin");
            this.inventoryLevel = nbt.func_74762_e("l_inv");
            this.healthLevel = nbt.func_74762_e("l_he");
            this.strengthLevel = nbt.func_74762_e("l_str");
            this.resourceEfficiencyLevel = nbt.func_74762_e("l_res");
        }

        @Override
        public ITextComponent getFormattedName() {
            return super.getFormattedName().func_211708_a(VReference.HUNTER_FACTION.getChatColor());
        }

        public int getHealthLevel() {
            return this.healthLevel;
        }

        public int getInventoryLevel() {
            return this.inventoryLevel;
        }

        public int getInventorySize() {
            return this.inventoryLevel == 1 ? 12 : (this.inventoryLevel == 2 ? 15 : 9);
        }

        public int getLevel() {
            return this.level;
        }

        public int getRemainingStatPoints() {
            return Math.max(0, this.level - this.inventoryLevel - this.healthLevel - this.resourceEfficiencyLevel - this.strengthLevel);
        }

        public int getResourceEfficiencyLevel() {
            return this.resourceEfficiencyLevel;
        }

        public int getStrengthLevel() {
            return this.strengthLevel;
        }

        @Override
        public void handleMinionAppearanceConfig(String newName, int ... data) {
            this.setName(newName);
            if (data.length >= 3) {
                this.type = data[0];
                this.hat = data[1];
                this.useLordSkin = data[2] == 1;
            }
        }

        @Override
        public void serializeNBT(CompoundNBT tag) {
            super.serializeNBT(tag);
            tag.func_74768_a("hunter_type", this.type);
            tag.func_74768_a("hunter_hat", this.hat);
            tag.func_74768_a("level", this.level);
            tag.func_74768_a("l_inv", this.inventoryLevel);
            tag.func_74768_a("l_he", this.healthLevel);
            tag.func_74768_a("l_str", this.strengthLevel);
            tag.func_74768_a("l_res", this.resourceEfficiencyLevel);
            tag.func_74757_a("use_lord_skin", this.useLordSkin);
        }

        public boolean setLevel(int level) {
            if (level < 0 || level > 6) {
                return false;
            }
            boolean levelup = level > this.level;
            this.level = level;
            return levelup;
        }

        @Override
        public boolean upgradeStat(int statId, MinionEntity<?> entity) {
            if (this.getRemainingStatPoints() == 0) {
                LOGGER.warn("Cannot upgrade minion stat as no stat points are left");
                return false;
            }
            assert (entity instanceof HunterMinionEntity);
            switch (statId) {
                case 0: {
                    if (this.inventoryLevel >= 2) {
                        return false;
                    }
                    ++this.inventoryLevel;
                    this.getInventory().setAvailableSize(this.getInventorySize());
                    return true;
                }
                case 1: {
                    if (this.healthLevel >= 3) {
                        return false;
                    }
                    ++this.healthLevel;
                    ((HunterMinionEntity)entity).updateAttributes();
                    entity.func_70606_j(entity.func_110138_aP());
                    return true;
                }
                case 2: {
                    if (this.strengthLevel >= 3) {
                        return false;
                    }
                    ++this.strengthLevel;
                    ((HunterMinionEntity)entity).updateAttributes();
                    return true;
                }
                case 3: {
                    if (this.resourceEfficiencyLevel >= 2) {
                        return false;
                    }
                    ++this.resourceEfficiencyLevel;
                    return true;
                }
            }
            LOGGER.warn("Cannot upgrade minion stat {} as it does not exist", (Object)statId);
            return false;
        }

        @Override
        protected ResourceLocation getDataType() {
            return ID;
        }
    }
}

