/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.minion;

import com.mojang.authlib.GameProfile;
import de.teamlapen.lib.HelperLib;
import de.teamlapen.lib.lib.network.ISyncable;
import de.teamlapen.vampirism.api.entity.minion.IMinionEntity;
import de.teamlapen.vampirism.api.entity.minion.IMinionInventory;
import de.teamlapen.vampirism.api.entity.minion.IMinionTask;
import de.teamlapen.vampirism.api.entity.player.ILordPlayer;
import de.teamlapen.vampirism.entity.VampirismEntity;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.goals.ForceLookEntityGoal;
import de.teamlapen.vampirism.entity.goals.LookAtClosestVisibleGoal;
import de.teamlapen.vampirism.entity.minion.goals.DefendAreaGoal;
import de.teamlapen.vampirism.entity.minion.goals.DefendLordGoal;
import de.teamlapen.vampirism.entity.minion.goals.FollowLordGoal;
import de.teamlapen.vampirism.entity.minion.goals.MoveToTaskCenterGoal;
import de.teamlapen.vampirism.entity.minion.management.MinionDamageSource;
import de.teamlapen.vampirism.entity.minion.management.MinionData;
import de.teamlapen.vampirism.entity.minion.management.PlayerMinionController;
import de.teamlapen.vampirism.inventory.container.MinionContainer;
import de.teamlapen.vampirism.util.IPlayerOverlay;
import de.teamlapen.vampirism.util.PlayerSkinHelper;
import de.teamlapen.vampirism.world.MinionWorldData;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.OpenDoorGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MinionEntity<T extends MinionData>
extends VampirismEntity
implements IPlayerOverlay,
ISyncable,
ForceLookEntityGoal.TaskOwner,
IMinionEntity,
IEntityAdditionalSpawnData {
    protected static final DataParameter<Optional<UUID>> LORD_ID = EntityDataManager.func_187226_a(MinionEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final Logger LOGGER = LogManager.getLogger();
    private static final NonNullList<ItemStack> EMPTY_LIST = NonNullList.func_191196_a();
    private static final int CONVERT_DURATION = 20;
    private final Predicate<LivingEntity> hardAttackPredicate;
    private final Predicate<LivingEntity> softAttackPredicate;
    @Nullable
    protected PlayerMinionController playerMinionController;
    protected T minionData;
    @Nullable
    private GameProfile skinProfile;
    private int minionId;
    private int token;
    private int convertCounter;
    @Nullable
    private PlayerEntity interactingPlayer;

    protected MinionEntity(EntityType<? extends VampirismEntity> type, World world, @Nonnull Predicate<LivingEntity> attackPredicate) {
        super(type, world);
        this.softAttackPredicate = attackPredicate;
        this.hardAttackPredicate = livingEntity -> {
            boolean flag1 = this.getLordOpt().map(ILordPlayer::getPlayer).filter(entity -> entity == livingEntity).isPresent();
            boolean flag2 = livingEntity instanceof MinionEntity && ((MinionEntity)livingEntity).getLordID().filter(id -> this.getLordID().map(id2 -> id == id2).orElse(false)).isPresent();
            return !flag1 && !flag2;
        };
        this.setDontDropEquipment();
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag;
        int i;
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        float f1 = (float)this.func_110148_a(SharedMonsterAttributes.field_221120_g).func_111126_e();
        if (entityIn instanceof LivingEntity) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (CreatureAttribute)((LivingEntity)entityIn).func_70668_bt());
            f1 += (float)EnchantmentHelper.func_77501_a((LivingEntity)this);
        }
        if ((i = EnchantmentHelper.func_90036_a((LivingEntity)this)) > 0) {
            entityIn.func_70015_d(i * 4);
        }
        if (flag = entityIn.func_70097_a((DamageSource)new MinionDamageSource(this), f)) {
            if (f1 > 0.0f && entityIn instanceof LivingEntity) {
                ((LivingEntity)entityIn).func_70653_a((Entity)this, f1 * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.func_213317_d(this.func_213322_ci().func_216372_d(0.6, 1.0, 0.6));
            }
            ItemStack itemstack = this.func_184614_ca();
            if (entityIn instanceof PlayerEntity) {
                ItemStack itemstack1;
                PlayerEntity playerentity = (PlayerEntity)entityIn;
                ItemStack itemStack = itemstack1 = playerentity.func_184587_cr() ? playerentity.func_184607_cu() : ItemStack.field_190927_a;
                if (!itemstack.func_190926_b() && !itemstack1.func_190926_b() && itemstack.canDisableShield(itemstack1, (LivingEntity)playerentity, (LivingEntity)this) && itemstack1.isShield((LivingEntity)playerentity)) {
                    float f2 = 0.25f + (float)EnchantmentHelper.func_185293_e((LivingEntity)this) * 0.05f;
                    if (this.field_70146_Z.nextFloat() < f2) {
                        playerentity.func_184811_cZ().func_185145_a(itemstack.func_77973_b(), 100);
                        this.field_70170_p.func_72960_a((Entity)playerentity, (byte)30);
                    }
                }
            }
            if (!this.field_70170_p.field_72995_K && !itemstack.func_190926_b() && entityIn instanceof LivingEntity) {
                itemstack.func_77973_b().func_77644_a(itemstack, (LivingEntity)entityIn, (LivingEntity)this);
                if (itemstack.func_190926_b()) {
                    this.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
                }
            }
            this.func_174815_a((LivingEntity)this, entityIn);
            this.func_130011_c(entityIn);
        }
        return flag;
    }

    protected void func_70675_k(float damage) {
        if (this.minionData != null) {
            ((MinionData)this.minionData).getInventory().damageArmor(damage, this);
        }
    }

    public void changeMinionName(String name) {
        if (this.minionData != null) {
            ((MinionData)this.minionData).setName(name);
            super.func_200203_b(((MinionData)this.minionData).getFormattedName());
        }
    }

    public void claimMinionSlot(int id, @Nonnull PlayerMinionController controller) {
        assert (this.minionId == 0);
        controller.claimMinionSlot(id).ifPresent(token -> {
            this.playerMinionController = controller;
            this.minionId = id;
            this.token = token;
            this.func_184212_Q().func_187227_b(LORD_ID, Optional.of(this.playerMinionController.getUUID()));
        });
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean func_94059_bO() {
        return true;
    }

    @Nonnull
    public Iterable<ItemStack> func_184193_aE() {
        return (Iterable)this.getInventory().map(IMinionInventory::getInventoryArmor).orElse(EMPTY_LIST);
    }

    public Predicate<LivingEntity> getAttackPredicate(boolean onlyShould) {
        return onlyShould ? this.hardAttackPredicate.and(this.softAttackPredicate) : this.hardAttackPredicate;
    }

    public abstract List<IMinionTask<?, ?>> getAvailableTasks();

    @Override
    public Optional<IMinionTask.IMinionTaskDesc<?>> getCurrentTask() {
        return this.minionData != null ? Optional.of(((MinionData)this.minionData).getCurrentTaskDesc()) : Optional.empty();
    }

    @Override
    @Nonnull
    public Optional<PlayerEntity> getForceLookTarget() {
        return Optional.ofNullable(this.interactingPlayer);
    }

    @Nonnull
    public Iterable<ItemStack> func_184214_aD() {
        return (Iterable)this.getInventory().map(IMinionInventory::getInventoryHands).orElse(EMPTY_LIST);
    }

    @Override
    public Optional<IMinionInventory> getInventory() {
        if (this.minionData != null) {
            return Optional.of(((MinionData)this.minionData).getInventory());
        }
        return Optional.empty();
    }

    @Nonnull
    public ItemStack func_184582_a(@Nonnull EquipmentSlotType slotIn) {
        switch (slotIn.func_188453_a()) {
            case HAND: {
                return this.getInventory().map(IMinionInventory::getInventoryHands).map(i -> (ItemStack)i.get(slotIn.func_188454_b())).orElse(ItemStack.field_190927_a);
            }
            case ARMOR: {
                return this.getInventory().map(IMinionInventory::getInventoryArmor).map(i -> (ItemStack)i.get(slotIn.func_188454_b())).orElse(ItemStack.field_190927_a);
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    @Nonnull
    public Optional<ILordPlayer> getLordOpt() {
        return Optional.ofNullable(this.getLord());
    }

    public Optional<T> getMinionData() {
        return Optional.ofNullable(this.minionData);
    }

    @Override
    public Optional<Integer> getMinionId() {
        return this.minionData == null ? Optional.empty() : Optional.of(this.minionId);
    }

    @Override
    @Nullable
    public GameProfile getOverlayPlayerProfile() {
        if (this.skinProfile == null) {
            this.getLordID().ifPresent(id -> {
                this.skinProfile = new GameProfile(id, "Dummy");
                PlayerSkinHelper.updateGameProfileAsync(this.skinProfile, profile -> {
                    this.skinProfile = profile;
                });
            });
        }
        return this.skinProfile;
    }

    @Override
    public LivingEntity getRepresentingEntity() {
        return this;
    }

    public float getScale() {
        return 0.8f + (float)this.convertCounter / 20.0f * 0.2f;
    }

    @Nonnull
    public EntitySize func_213305_a(@Nonnull Pose p_213305_1_) {
        return super.func_213305_a(p_213305_1_).func_220313_a(this.getScale());
    }

    public boolean isTaskLocked() {
        return this.minionData != null && ((MinionData)this.minionData).isTaskLocked();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && this.field_70146_Z.nextInt(900) == 0 && this.field_70725_aQ == 0) {
            this.func_70691_i(1.0f);
        }
        if (this.convertCounter > 0) {
            --this.convertCounter;
        }
        if (!this.field_70170_p.field_72995_K && !this.isValid() && this.func_70089_S()) {
            LOGGER.warn("Minion without lord.");
            this.func_70106_y();
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void loadUpdateFromNBT(CompoundNBT nbt) {
        if (nbt.func_74764_b("data_type")) {
            MinionData data = MinionData.fromNBT(nbt);
            try {
                this.minionData = data;
                this.onMinionDataReceived(data);
                this.minionId = nbt.func_74762_e("minion_id");
                super.func_200203_b(data.getFormattedName());
            }
            catch (ClassCastException e) {
                LOGGER.error("Failed to cast minion data. Maybe the correct data was not registered", (Throwable)e);
            }
        } else {
            LOGGER.warn("Received empty minion data");
        }
    }

    public void markAsConverted() {
        this.convertCounter = 20;
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.checkoutMinionData();
    }

    public void func_70645_a(@Nonnull DamageSource p_70645_1_) {
        super.func_70645_a(p_70645_1_);
        if (this.playerMinionController != null) {
            this.getLordOpt().map(ILordPlayer::getPlayer).ifPresent(p -> p.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.minion.died", new Object[]{this.func_145748_c_()}), true));
            this.playerMinionController.markDeadAndReleaseMinionSlot(this.minionId, this.token);
            this.playerMinionController = null;
        }
    }

    public void onTaskChanged() {
        HelperLib.sync(this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void openAppearanceScreen() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void openStatsScreen() {
    }

    @Override
    public void func_70037_a(CompoundNBT nbt) {
        UUID id;
        super.func_70037_a(nbt);
        UUID uUID = id = nbt.func_186855_b("lord") ? nbt.func_186857_a("lord") : null;
        if (id != null && this.field_70170_p instanceof ServerWorld) {
            this.playerMinionController = MinionWorldData.getData((ServerWorld)this.field_70170_p).getController(id);
            if (this.playerMinionController == null) {
                LOGGER.warn("Cannot get PlayerMinionController for {}", (Object)id);
            } else {
                this.minionId = nbt.func_74762_e("minion_id");
                this.token = nbt.func_74762_e("minion_token");
                this.func_184212_Q().func_187227_b(LORD_ID, Optional.of(id));
            }
        }
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.convertCounter = additionalData.func_150792_a();
    }

    @Override
    @Deprecated
    public void recallMinion() {
        this.func_70106_y();
    }

    public void remove(boolean p_remove_1_) {
        super.remove(p_remove_1_);
        if (this.playerMinionController != null) {
            this.playerMinionController.checkInMinion(this.minionId, this.token);
            this.minionData = null;
            this.playerMinionController = null;
        }
    }

    public void func_70624_b(@Nullable LivingEntity entitylivingbaseIn) {
        if (entitylivingbaseIn == null || this.hardAttackPredicate.test(entitylivingbaseIn)) {
            super.func_70624_b(entitylivingbaseIn);
        }
    }

    public void func_200203_b(@Nullable ITextComponent name) {
    }

    public void func_70606_j(float health) {
        super.func_70606_j(health);
        if (this.minionData != null) {
            ((MinionData)this.minionData).setHealth(health);
        }
    }

    public void setInteractingPlayer(@Nullable PlayerEntity player) {
        this.interactingPlayer = player;
    }

    public void func_184201_a(@Nonnull EquipmentSlotType slotIn, @Nonnull ItemStack stack) {
        if (this.minionData == null) {
            return;
        }
        switch (slotIn.func_188453_a()) {
            case HAND: {
                this.getInventory().map(IMinionInventory::getInventoryHands).ifPresent(i -> {
                    ItemStack cfr_ignored_0 = (ItemStack)i.set(slotIn.func_188454_b(), (Object)stack);
                });
                break;
            }
            case ARMOR: {
                this.getInventory().map(IMinionInventory::getInventoryArmor).ifPresent(i -> {
                    ItemStack cfr_ignored_0 = (ItemStack)i.set(slotIn.func_188454_b(), (Object)stack);
                });
            }
        }
    }

    public abstract boolean shouldRenderLordSkin();

    @Override
    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        if (this.isValid()) {
            this.getLordID().ifPresent(id -> nbt.func_186854_a("lord", id));
            nbt.func_74768_a("minion_id", this.minionId);
            nbt.func_74768_a("minion_token", this.token);
        }
    }

    @Override
    public void writeFullUpdateToNBT(CompoundNBT nbt) {
        if (this.minionData == null && this.field_70170_p.func_73045_a(this.func_145782_y()) != null) {
            this.checkoutMinionData();
        }
        if (this.minionData != null) {
            ((MinionData)this.minionData).serializeNBT(nbt);
            nbt.func_74768_a("minion_id", this.minionId);
        }
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.func_150787_b(this.convertCounter);
    }

    @Nullable
    protected ILordPlayer getLord() {
        return this.getLordID().map(arg_0 -> ((World)this.field_70170_p).func_217371_b(arg_0)).filter(LivingEntity::func_70089_S).map(FactionPlayerHandler::get).orElse(null);
    }

    protected Optional<UUID> getLordID() {
        return (Optional)this.func_184212_Q().func_187225_a(LORD_ID);
    }

    protected boolean isValid() {
        return this.playerMinionController != null;
    }

    protected boolean isLord(PlayerEntity p) {
        return this.getLordID().map(id -> id.equals(p.func_110124_au())).orElse(false);
    }

    protected void onMinionDataReceived(@Nonnull T data) {
    }

    protected boolean func_184645_a(PlayerEntity player, Hand hand) {
        if (this.isLord(player)) {
            if (player instanceof ServerPlayerEntity) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new SimpleNamedContainerProvider((id, playerInventory, playerIn) -> MinionContainer.create(id, playerInventory, this), new TranslationTextComponent("text.vampirism.name", new Object[0]).func_150257_a(this.getMinionData().map(MinionData::getFormattedName).orElse((ITextComponent)new StringTextComponent("Minion")))), buf -> buf.func_150787_b(this.func_145782_y()));
            }
            return true;
        }
        return false;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(LORD_ID, Optional.empty());
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, new ForceLookEntityGoal<MinionEntity>(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new OpenDoorGoal((MobEntity)this, true));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowLordGoal(this, 1.1));
        this.field_70714_bg.func_75776_a(9, (Goal)new MoveToTaskCenterGoal(this));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtClosestVisibleGoal((MobEntity)this, PlayerEntity.class, 20.0f, 0.6f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new DefendAreaGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new DefendLordGoal(this));
    }

    private void checkoutMinionData() {
        if (this.playerMinionController != null && this.minionData == null) {
            this.minionData = this.playerMinionController.checkoutMinion(this.minionId, this.token, this);
            if (this.minionData == null) {
                this.playerMinionController = null;
            } else {
                this.handleLoadedMinionData(this.minionData);
            }
        }
    }

    private void handleLoadedMinionData(@Nonnull T data) {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)((MinionData)data).getMaxHealth());
        super.func_70606_j(((MinionData)data).getHealth());
        super.func_200203_b(((MinionData)data).getFormattedName());
        try {
            this.onMinionDataReceived(data);
        }
        catch (ClassCastException e) {
            LOGGER.error("Failed to cast minion data. Maybe the correct data was not registered", (Throwable)e);
            this.func_70106_y();
        }
    }
}

