/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.minion;

import com.google.common.collect.Lists;
import de.teamlapen.lib.HelperLib;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.api.entity.minion.IMinionTask;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.client.gui.VampireMinionAppearanceScreen;
import de.teamlapen.vampirism.client.gui.VampireMinionStatsScreen;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.entity.DamageHandler;
import de.teamlapen.vampirism.entity.VampirismEntity;
import de.teamlapen.vampirism.entity.goals.RestrictSunVampireGoal;
import de.teamlapen.vampirism.entity.minion.MinionEntity;
import de.teamlapen.vampirism.entity.minion.management.MinionData;
import de.teamlapen.vampirism.entity.minion.management.MinionTasks;
import de.teamlapen.vampirism.items.MinionUpgradeItem;
import de.teamlapen.vampirism.util.Helper;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class VampireMinionEntity
extends MinionEntity<VampireMinionData>
implements IVampire {
    private boolean sundamageCache;
    private EnumStrength garlicCache = EnumStrength.NONE;

    public static void init() {
    }

    public VampireMinionEntity(EntityType<? extends VampirismEntity> type, World world) {
        super(type, world, VampirismAPI.factionRegistry().getPredicate(VReference.VAMPIRE_FACTION, true, true, true, false, null).or(e -> !(e instanceof IFactionEntity) && e instanceof IMob && !(e instanceof ZombieEntity)));
    }

    @Override
    public boolean doesResistGarlic(EnumStrength strength) {
        return false;
    }

    @Override
    public void drinkBlood(int amt, float saturationMod, boolean useRemaining) {
    }

    @Override
    public List<IMinionTask<?, ?>> getAvailableTasks() {
        return Lists.newArrayList((Object[])new IMinionTask[]{MinionTasks.follow_lord, MinionTasks.stay, MinionTasks.defend_area, MinionTasks.collect_blood, MinionTasks.protect_lord});
    }

    @Override
    public LivingEntity getRepresentingEntity() {
        return this;
    }

    public int getVampireType() {
        return this.getMinionData().map(d -> ((VampireMinionData)d).type).map(t -> Math.max(0, t)).orElse(0);
    }

    public void setVampireType(int type) {
        this.getMinionData().ifPresent(d -> ((VampireMinionData)d).type = type);
    }

    @Override
    @Nonnull
    public EnumStrength isGettingGarlicDamage(IWorld iWorld, boolean forcerefresh) {
        if (forcerefresh) {
            this.garlicCache = Helper.getGarlicStrength((Entity)this, iWorld);
        }
        return this.garlicCache;
    }

    @Override
    public boolean isGettingSundamage(IWorld iWorld, boolean forceRefresh) {
        if (!forceRefresh) {
            return this.sundamageCache;
        }
        this.sundamageCache = Helper.gettingSundamge((LivingEntity)this, iWorld, this.field_70170_p.func_217381_Z());
        return this.sundamageCache;
    }

    @Override
    public boolean isIgnoringSundamage() {
        return this.func_70644_a(ModEffects.sunscreen);
    }

    @Override
    public void func_70636_d() {
        if (this.field_70173_aa % 40 == 3) {
            this.isGettingGarlicDamage((IWorld)this.field_70170_p, true);
        }
        if (this.field_70173_aa % 8 == 2) {
            this.isGettingSundamage((IWorld)this.field_70170_p, true);
        }
        if (!this.field_70170_p.field_72995_K) {
            double dmg;
            if (this.isGettingSundamage((IWorld)this.field_70170_p) && this.field_70173_aa % 40 == 11 && (dmg = this.func_110148_a(VReference.sunDamage).func_111126_e()) > 0.0) {
                this.func_70097_a(VReference.SUNDAMAGE, (float)dmg);
            }
            if (this.isGettingGarlicDamage((IWorld)this.field_70170_p) != EnumStrength.NONE) {
                DamageHandler.affectVampireGarlicAmbient(this, this.isGettingGarlicDamage((IWorld)this.field_70170_p), this.field_70173_aa);
            }
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && this.func_70090_H()) {
            this.func_70050_g(300);
            if (this.field_70173_aa % 16 == 4) {
                this.func_195064_c(new EffectInstance(Effects.field_76437_t, 80, 0));
            }
        }
        super.func_70636_d();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void openAppearanceScreen() {
        Minecraft.func_71410_x().func_147108_a((Screen)new VampireMinionAppearanceScreen(this, Minecraft.func_71410_x().field_71462_r));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void openStatsScreen() {
        Minecraft.func_71410_x().func_147108_a((Screen)new VampireMinionStatsScreen(this, Minecraft.func_71410_x().field_71462_r));
    }

    public void setUseLordSkin(boolean useLordSkin) {
        this.getMinionData().ifPresent(d -> ((VampireMinionData)d).useLordSkin = useLordSkin);
    }

    @Override
    public boolean shouldRenderLordSkin() {
        return this.getMinionData().map(d -> ((VampireMinionData)d).useLordSkin).orElse(false);
    }

    @Override
    public boolean useBlood(int amt, boolean allowPartial) {
        return false;
    }

    @Override
    public boolean wantsBlood() {
        return false;
    }

    @Override
    protected void onMinionDataReceived(@Nonnull VampireMinionData data) {
        super.onMinionDataReceived(data);
        this.updateAttributes();
    }

    @Override
    protected boolean func_184645_a(PlayerEntity player, Hand hand) {
        ItemStack heldItem;
        if (!this.field_70170_p.func_201670_d() && this.isLord(player) && this.minionData != null && (heldItem = player.func_184586_b(hand)).func_77973_b() instanceof MinionUpgradeItem && ((MinionUpgradeItem)heldItem.func_77973_b()).getFaction() == this.getFaction()) {
            if (((VampireMinionData)this.minionData).level + 1 >= ((MinionUpgradeItem)heldItem.func_77973_b()).getMinLevel() && ((VampireMinionData)this.minionData).level + 1 <= ((MinionUpgradeItem)heldItem.func_77973_b()).getMaxLevel()) {
                ((VampireMinionData)this.minionData).level++;
                if (!player.field_71075_bZ.field_75098_d) {
                    heldItem.func_190918_g(1);
                }
                player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.vampire_minion.binding_upgrade", new Object[0]), false);
                HelperLib.sync(this);
            } else {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("text.vampirism.vampire_minion.binding_wrong", new Object[0]));
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        IAttributeInstance iAttributeInstance = this.func_110140_aT().func_111150_b(VReference.sunDamage);
        BalanceMobProps.mobProps.getClass();
        iAttributeInstance.func_111128_a(7.0);
        this.updateAttributes();
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(3, new RestrictSunVampireGoal<VampireMinionEntity>(this));
    }

    private void updateAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(BalanceMobProps.mobProps.MINION_MAX_HEALTH + (double)BalanceMobProps.mobProps.ADVANCED_VAMPIRE_MAX_FOLLOWER * (double)this.getMinionData().map(VampireMinionData::getHealthLevel).orElse(0).intValue());
        IAttributeInstance iAttributeInstance = this.func_110148_a(SharedMonsterAttributes.field_111264_e);
        BalanceMobProps.mobProps.getClass();
        iAttributeInstance.func_111128_a(3.0 + (double)BalanceMobProps.mobProps.CONVERTED_MOB_DEFAULT_DMG * (double)this.getMinionData().map(VampireMinionData::getStrengthLevel).orElse(0).intValue());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(BalanceMobProps.mobProps.VAMPIRE_SPEED + 0.05 * (double)this.getMinionData().map(VampireMinionData::getSpeedLevel).orElse(0).intValue());
    }

    static {
        MinionData.registerDataType(VampireMinionData.ID, () -> new VampireMinionData());
    }

    public static class VampireMinionData
    extends MinionData {
        public static final ResourceLocation ID = new ResourceLocation("vampirism", "vampire");
        public static final int MAX_LEVEL = 6;
        public static final int MAX_LEVEL_INVENTORY = 2;
        public static final int MAX_LEVEL_HEALTH = 3;
        public static final int MAX_LEVEL_STRENGTH = 3;
        public static final int MAX_LEVEL_SPEED = 3;
        private int type;
        private boolean useLordSkin;
        private int level;
        private int inventoryLevel;
        private int healthLevel;
        private int strengthLevel;
        private int speedLevel;

        public VampireMinionData(String name, int type, boolean useLordSkin) {
            super(name, 9);
            this.type = type;
            this.useLordSkin = useLordSkin;
            this.level = 0;
        }

        private VampireMinionData() {
        }

        @Override
        public void deserializeNBT(CompoundNBT nbt) {
            super.deserializeNBT(nbt);
            this.type = nbt.func_74762_e("vampire_type");
            this.level = nbt.func_74762_e("level");
            this.useLordSkin = nbt.func_74767_n("use_lord_skin");
            this.inventoryLevel = nbt.func_74762_e("l_inv");
            this.healthLevel = nbt.func_74762_e("l_he");
            this.strengthLevel = nbt.func_74762_e("l_str");
            this.speedLevel = nbt.func_74762_e("l_spe");
        }

        @Override
        public ITextComponent getFormattedName() {
            return super.getFormattedName().func_211708_a(VReference.VAMPIRE_FACTION.getChatColor());
        }

        public int getHealthLevel() {
            return this.healthLevel;
        }

        public int getInventoryLevel() {
            return this.inventoryLevel;
        }

        public int getInventorySize() {
            return this.inventoryLevel == 1 ? 12 : (this.inventoryLevel == 2 ? 15 : 9);
        }

        public int getLevel() {
            return this.level;
        }

        public int getRemainingStatPoints() {
            return Math.max(0, this.level - this.inventoryLevel - this.healthLevel - this.speedLevel - this.strengthLevel);
        }

        public int getSpeedLevel() {
            return this.speedLevel;
        }

        public int getStrengthLevel() {
            return this.strengthLevel;
        }

        @Override
        public void handleMinionAppearanceConfig(String newName, int ... data) {
            this.setName(newName);
            if (data.length >= 2) {
                this.type = data[0];
                this.useLordSkin = data[1] == 1;
            }
        }

        @Override
        public void serializeNBT(CompoundNBT tag) {
            super.serializeNBT(tag);
            tag.func_74768_a("vampire_type", this.type);
            tag.func_74768_a("level", this.level);
            tag.func_74757_a("use_lord_skin", this.useLordSkin);
            tag.func_74768_a("l_inv", this.inventoryLevel);
            tag.func_74768_a("l_he", this.healthLevel);
            tag.func_74768_a("l_str", this.strengthLevel);
            tag.func_74768_a("l_spe", this.speedLevel);
        }

        public boolean setLevel(int level) {
            if (level < 0 || level > 6) {
                return false;
            }
            boolean levelup = level > this.level;
            this.level = level;
            return levelup;
        }

        @Override
        public boolean upgradeStat(int statId, MinionEntity<?> entity) {
            if (this.getRemainingStatPoints() == 0) {
                LOGGER.warn("Cannot upgrade minion stat as no stat points are left");
                return false;
            }
            assert (entity instanceof VampireMinionEntity);
            switch (statId) {
                case 0: {
                    if (this.inventoryLevel >= 2) {
                        return false;
                    }
                    ++this.inventoryLevel;
                    this.getInventory().setAvailableSize(this.getInventorySize());
                    return true;
                }
                case 1: {
                    if (this.healthLevel >= 3) {
                        return false;
                    }
                    ++this.healthLevel;
                    ((VampireMinionEntity)entity).updateAttributes();
                    return true;
                }
                case 2: {
                    if (this.strengthLevel >= 3) {
                        return false;
                    }
                    ++this.strengthLevel;
                    ((VampireMinionEntity)entity).updateAttributes();
                    return true;
                }
                case 3: {
                    if (this.speedLevel >= 3) {
                        return false;
                    }
                    ++this.speedLevel;
                    return true;
                }
            }
            LOGGER.warn("Cannot upgrade minion stat {} as it does not exist", (Object)statId);
            return false;
        }

        @Override
        protected ResourceLocation getDataType() {
            return ID;
        }
    }
}

