/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.minion.management;

import de.teamlapen.lib.util.WeightedRandomItem;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.minion.DefaultMinionTask;
import de.teamlapen.vampirism.api.entity.minion.IMinionEntity;
import de.teamlapen.vampirism.api.entity.minion.IMinionTask;
import de.teamlapen.vampirism.api.entity.player.ILordPlayer;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.entity.minion.management.MinionData;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class CollectResourcesTask<Q extends MinionData>
extends DefaultMinionTask<Desc<Q>, Q> {
    @Nonnull
    private final Function<Q, Integer> coolDownSupplier;
    @Nonnull
    private final List<WeightedRandomItem<ItemStack>> resources;
    private final Random rng = new Random();
    @Nullable
    private final IPlayableFaction<?> faction;

    public CollectResourcesTask(@Nullable IPlayableFaction<?> faction, Function<Q, Integer> coolDownSupplier, List<WeightedRandomItem<ItemStack>> resources) {
        this.coolDownSupplier = coolDownSupplier;
        this.resources = resources;
        this.faction = faction;
    }

    @Override
    public Desc<Q> activateTask(@Nullable PlayerEntity lord, @Nullable IMinionEntity minion, Q data) {
        if (minion != null) {
            minion.recallMinion();
        }
        if (lord != null) {
            lord.func_146105_b((ITextComponent)new TranslationTextComponent(Util.func_200697_a((String)"minion_task", (ResourceLocation)this.getRegistryName()) + ".start", new Object[0]), true);
        }
        return new Desc(this, this.coolDownSupplier.apply(data), lord != null ? lord.func_110124_au() : null);
    }

    @Override
    public void deactivateTask(Desc<Q> desc) {
    }

    @Override
    public boolean isAvailable(IPlayableFaction<?> faction, @Nullable ILordPlayer player) {
        return this.faction == null || this.faction == faction;
    }

    @Override
    public Desc<Q> readFromNBT(CompoundNBT nbt) {
        return new Desc(this, nbt.func_74762_e("cooldown"), nbt.func_74764_b("lordid") ? nbt.func_186857_a("lordid") : null);
    }

    @Override
    public void tickBackground(Desc<Q> desc, @Nonnull Q data) {
        if (--((Desc)desc).coolDown <= 0) {
            boolean lordOnline = ((Desc)desc).lordEntityID != null && ServerLifecycleHooks.getCurrentServer() != null && ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(((Desc)desc).lordEntityID) != null;
            ((Desc)desc).coolDown = lordOnline ? this.coolDownSupplier.apply(data) : (int)((double)this.coolDownSupplier.apply(data).intValue() * (Double)VampirismConfig.BALANCE.miResourceCooldownOfflineMult.get());
            ((MinionData)data).getInventory().addItemStack(((ItemStack)((WeightedRandomItem)WeightedRandom.func_76271_a((Random)this.rng, this.resources)).getItem()).func_77946_l());
        }
    }

    public static class Desc<Z extends MinionData>
    implements IMinionTask.IMinionTaskDesc<Z> {
        private final CollectResourcesTask<Z> task;
        private int coolDown;
        @Nullable
        private final UUID lordEntityID;

        public Desc(CollectResourcesTask<Z> task, int coolDown, @Nullable UUID lordEntityID) {
            this.task = task;
            this.coolDown = coolDown;
            this.lordEntityID = lordEntityID;
        }

        @Override
        public IMinionTask<?, Z> getTask() {
            return this.task;
        }

        @Override
        public void writeToNBT(CompoundNBT nbt) {
            nbt.func_74768_a("cooldown", this.coolDown);
            if (this.lordEntityID != null) {
                nbt.func_186854_a("lordid", this.lordEntityID);
            }
        }
    }
}

