/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.minion.management;

import de.teamlapen.vampirism.api.entity.minion.IMinionData;
import de.teamlapen.vampirism.api.entity.minion.IMinionTask;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.entity.minion.MinionEntity;
import de.teamlapen.vampirism.entity.minion.management.MinionInventory;
import de.teamlapen.vampirism.entity.minion.management.MinionTasks;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.util.INBTSerializable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MinionData
implements INBTSerializable<CompoundNBT>,
IMinionData {
    public static final int MAX_NAME_LENGTH = 15;
    protected static final Logger LOGGER = LogManager.getLogger();
    private static final Map<ResourceLocation, Supplier<? extends MinionData>> constructors = new HashMap<ResourceLocation, Supplier<? extends MinionData>>();
    private final MinionInventory inventory;
    private float health;
    private String name;
    @Nonnull
    private IMinionTask.IMinionTaskDesc<MinionData> activeTaskDesc;
    private boolean taskLocked;

    public static void registerDataType(ResourceLocation id, Supplier<? extends MinionData> supplier) {
        constructors.put(id, supplier);
    }

    @Nonnull
    public static MinionData fromNBT(CompoundNBT nbt) {
        ResourceLocation dataType = new ResourceLocation(nbt.func_74779_i("data_type"));
        Supplier<? extends MinionData> c = constructors.get(dataType);
        if (c == null) {
            LOGGER.error("No data constructor available for {}", (Object)dataType);
            return new MinionData();
        }
        MinionData d = c.get();
        d.deserializeNBT(nbt);
        return d;
    }

    protected MinionData(String name, int invSize) {
        this.health = this.getMaxHealth();
        this.name = name;
        this.inventory = new MinionInventory(invSize);
        this.activeTaskDesc = new IMinionTask.NoDesc<MinionData>(MinionTasks.nothing);
    }

    protected MinionData() {
        this.inventory = new MinionInventory();
        this.activeTaskDesc = new IMinionTask.NoDesc<MinionData>(MinionTasks.nothing);
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.inventory.read(nbt.func_150295_c("inv", 10));
        this.inventory.setAvailableSize(nbt.func_74762_e("inv_size"));
        this.health = nbt.func_74760_g("health");
        this.name = nbt.func_74779_i("name");
        this.taskLocked = nbt.func_74767_n("locked");
        if (nbt.func_150297_b("task", 10)) {
            CompoundNBT task = nbt.func_74775_l("task");
            ResourceLocation id = new ResourceLocation(task.func_74779_i("id"));
            IMinionTask activeTask = (IMinionTask)ModRegistries.MINION_TASKS.getValue(id);
            if (activeTask != null) {
                this.activeTaskDesc = activeTask.readFromNBT(task);
            } else {
                LOGGER.error("Saved minion task does not exist anymore {}", (Object)id);
            }
        }
    }

    @Nonnull
    public IMinionTask.IMinionTaskDesc<MinionData> getCurrentTaskDesc() {
        return this.activeTaskDesc;
    }

    @Override
    public ITextComponent getFormattedName() {
        return new StringTextComponent(this.name);
    }

    @Override
    public float getHealth() {
        return this.health;
    }

    public void setHealth(float health) {
        this.health = health;
    }

    @Override
    public MinionInventory getInventory() {
        return this.inventory;
    }

    @Override
    public int getMaxHealth() {
        BalanceMobProps.mobProps.getClass();
        return 45;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void handleMinionAppearanceConfig(String name, int ... data) {
    }

    public <Q extends IMinionTask.IMinionTaskDesc<MinionData>, T extends IMinionTask<Q, ?>> void switchTask(T oldTask, IMinionTask.IMinionTaskDesc<MinionData> oldDesc, IMinionTask.IMinionTaskDesc<MinionData> newDesc) {
        oldTask.deactivateTask(oldDesc);
        this.activeTaskDesc = newDesc;
    }

    public boolean isTaskLocked() {
        return this.taskLocked;
    }

    public final CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        this.serializeNBT(tag);
        return tag;
    }

    public void serializeNBT(CompoundNBT tag) {
        tag.func_74768_a("inv_size", this.inventory.getAvailableSize());
        tag.func_218657_a("inv", (INBT)this.inventory.write(new ListNBT()));
        tag.func_74776_a("health", this.health);
        tag.func_74778_a("name", this.name);
        tag.func_74778_a("data_type", this.getDataType().toString());
        tag.func_74757_a("locked", this.taskLocked);
        if (this.activeTaskDesc != null) {
            CompoundNBT task = new CompoundNBT();
            task.func_74778_a("id", this.activeTaskDesc.getTask().getRegistryName().toString());
            this.activeTaskDesc.writeToNBT(task);
            tag.func_218657_a("task", (INBT)task);
        }
    }

    public boolean setTaskLocked(boolean locked) {
        this.taskLocked = locked;
        return this.taskLocked;
    }

    public boolean upgradeStat(int statId, MinionEntity<?> entity) {
        return false;
    }

    protected ResourceLocation getDataType() {
        return new ResourceLocation("");
    }
}

