/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.minion.management;

import com.google.common.collect.ImmutableList;
import de.teamlapen.lib.lib.inventory.InventoryHelper;
import de.teamlapen.vampirism.api.entity.minion.IMinionInventory;
import de.teamlapen.vampirism.entity.minion.MinionEntity;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.NonNullList;

public class MinionInventory
implements IMinionInventory {
    private final NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)25, (Object)ItemStack.field_190927_a);
    private final NonNullList<ItemStack> inventoryHands = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    private final NonNullList<ItemStack> inventoryArmor = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    private final List<NonNullList<ItemStack>> allInventories = ImmutableList.of(this.inventoryHands, this.inventoryArmor, this.inventory);
    private int availableSize;

    public MinionInventory(int availableSize) {
        assert (availableSize == 9 || availableSize == 12 || availableSize == 15);
        this.availableSize = availableSize;
    }

    public MinionInventory() {
        this(9);
    }

    @Override
    public void addItemStack(@Nonnull ItemStack stack) {
        int slot;
        while (!stack.func_190926_b() && (slot = InventoryHelper.getFirstSuitableSlotToAdd(this.inventory, stack, this.func_70297_j_())) != -1) {
            int oldSize = stack.func_190916_E();
            InventoryHelper.addStackToSlotWithoutCheck(this, slot + 6, stack);
            if (stack.func_190916_E() < oldSize) continue;
            break;
        }
    }

    public void func_174888_l() {
        for (List list : this.allInventories) {
            list.clear();
        }
    }

    @Nonnull
    public ItemStack func_70298_a(int index, int count) {
        ItemStack s = this.func_70301_a(index);
        return !s.func_190926_b() && count > 0 ? s.func_77979_a(count) : ItemStack.field_190927_a;
    }

    @Override
    public int getAvailableSize() {
        return this.availableSize;
    }

    @Override
    public NonNullList<ItemStack> getInventoryHands() {
        return this.inventoryHands;
    }

    @Override
    public NonNullList<ItemStack> getInventoryArmor() {
        return this.inventoryArmor;
    }

    public void read(ListNBT nbtTagListIn) {
        this.inventory.clear();
        this.inventoryArmor.clear();
        this.inventoryHands.clear();
        for (int i = 0; i < nbtTagListIn.size(); ++i) {
            CompoundNBT compoundnbt = nbtTagListIn.func_150305_b(i);
            int j = compoundnbt.func_74771_c("Slot") & 0xFF;
            ItemStack itemstack = ItemStack.func_199557_a((CompoundNBT)compoundnbt);
            if (itemstack.func_190926_b()) continue;
            if (j < this.inventoryHands.size()) {
                this.inventoryHands.set(j, (Object)itemstack);
                continue;
            }
            if (j >= 10 && j < this.inventoryArmor.size() + 10) {
                this.inventoryArmor.set(j - 10, (Object)itemstack);
                continue;
            }
            if (j < 20 || j >= this.inventory.size() + 20) continue;
            this.inventory.set(j - 20, (Object)itemstack);
        }
    }

    public void damageArmor(float damage, MinionEntity<?> entity) {
        if (damage > 0.0f) {
            if ((damage /= 4.0f) < 1.0f) {
                damage = 1.0f;
            }
            for (int i = 0; i < this.inventoryArmor.size(); ++i) {
                ItemStack itemstack = (ItemStack)this.inventoryArmor.get(i);
                if (!(itemstack.func_77973_b() instanceof ArmorItem)) continue;
                int i_final = i;
                itemstack.func_222118_a((int)damage, entity, e -> e.func_213361_c(EquipmentSlotType.func_220318_a((EquipmentSlotType.Group)EquipmentSlotType.Group.ARMOR, (int)i_final)));
            }
        }
    }

    public int func_70302_i_() {
        return 6 + this.availableSize;
    }

    @Nonnull
    public ItemStack func_70301_a(int index) {
        assert (index >= 0);
        if (index < 2) {
            return (ItemStack)this.inventoryHands.get(index);
        }
        if (index < 6) {
            return (ItemStack)this.inventoryArmor.get(index - 2);
        }
        if (index < 6 + this.availableSize) {
            return (ItemStack)this.inventory.get(index - 6);
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        for (ItemStack itemstack1 : this.inventoryHands) {
            if (itemstack1.func_190926_b()) continue;
            return false;
        }
        for (ItemStack itemstack2 : this.inventoryArmor) {
            if (itemstack2.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public boolean func_70300_a(PlayerEntity player) {
        return true;
    }

    public void func_70296_d() {
    }

    public MinionInventory setAvailableSize(int newSize) {
        assert (newSize == 9 || newSize == 12 || newSize == 15);
        this.availableSize = newSize;
        return this;
    }

    @Nonnull
    public ItemStack func_70304_b(int index) {
        ItemStack s = this.func_70301_a(index);
        if (!s.func_190926_b()) {
            this.func_70299_a(index, ItemStack.field_190927_a);
        }
        return s;
    }

    public void func_70299_a(int index, @Nonnull ItemStack stack) {
        assert (index >= 0);
        if (index < 2) {
            this.inventoryHands.set(index, (Object)stack);
        } else if (index < 6) {
            this.inventoryArmor.set(index - 2, (Object)stack);
        } else if (index < 6 + this.availableSize) {
            this.inventory.set(index - 6, (Object)stack);
        }
    }

    public ListNBT write(ListNBT nbt) {
        for (int i = 0; i < this.inventoryHands.size(); ++i) {
            if (((ItemStack)this.inventoryHands.get(i)).func_190926_b()) continue;
            CompoundNBT compoundnbt = new CompoundNBT();
            compoundnbt.func_74774_a("Slot", (byte)i);
            ((ItemStack)this.inventoryHands.get(i)).func_77955_b(compoundnbt);
            nbt.add((Object)compoundnbt);
        }
        for (int j = 0; j < this.inventoryArmor.size(); ++j) {
            if (((ItemStack)this.inventoryArmor.get(j)).func_190926_b()) continue;
            CompoundNBT compoundnbt1 = new CompoundNBT();
            compoundnbt1.func_74774_a("Slot", (byte)(j + 10));
            ((ItemStack)this.inventoryArmor.get(j)).func_77955_b(compoundnbt1);
            nbt.add((Object)compoundnbt1);
        }
        for (int k = 0; k < this.inventory.size(); ++k) {
            if (((ItemStack)this.inventory.get(k)).func_190926_b()) continue;
            CompoundNBT compoundnbt2 = new CompoundNBT();
            compoundnbt2.func_74774_a("Slot", (byte)(k + 20));
            ((ItemStack)this.inventory.get(k)).func_77955_b(compoundnbt2);
            nbt.add((Object)compoundnbt2);
        }
        return nbt;
    }
}

