/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.vampire;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.difficulty.Difficulty;
import de.teamlapen.vampirism.api.entity.EntityClassType;
import de.teamlapen.vampirism.api.entity.IEntityLeader;
import de.teamlapen.vampirism.api.entity.actions.EntityActionTier;
import de.teamlapen.vampirism.api.entity.actions.IEntityActionUser;
import de.teamlapen.vampirism.api.entity.vampire.IBasicVampire;
import de.teamlapen.vampirism.api.world.ICaptureAttributes;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.entity.action.ActionHandlerEntity;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.goals.AttackMeleeNoSunGoal;
import de.teamlapen.vampirism.entity.goals.AttackVillageGoal;
import de.teamlapen.vampirism.entity.goals.BiteNearbyEntityVampireGoal;
import de.teamlapen.vampirism.entity.goals.DefendLeaderGoal;
import de.teamlapen.vampirism.entity.goals.DefendVillageGoal;
import de.teamlapen.vampirism.entity.goals.FleeSunVampireGoal;
import de.teamlapen.vampirism.entity.goals.FollowAdvancedVampireGoal;
import de.teamlapen.vampirism.entity.goals.LookAtClosestVisibleGoal;
import de.teamlapen.vampirism.entity.goals.MoveToBiteableVampireGoal;
import de.teamlapen.vampirism.entity.goals.RestrictSunVampireGoal;
import de.teamlapen.vampirism.entity.hunter.HunterBaseEntity;
import de.teamlapen.vampirism.entity.minion.VampireMinionEntity;
import de.teamlapen.vampirism.entity.minion.management.MinionTasks;
import de.teamlapen.vampirism.entity.minion.management.PlayerMinionController;
import de.teamlapen.vampirism.entity.vampire.VampireBaseEntity;
import de.teamlapen.vampirism.world.MinionWorldData;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.BreakDoorGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.monster.PatrollerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.Structures;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class BasicVampireEntity
extends VampireBaseEntity
implements IBasicVampire,
IEntityActionUser {
    private static final DataParameter<Integer> LEVEL = EntityDataManager.func_187226_a(BasicVampireEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> TYPE = EntityDataManager.func_187226_a(BasicVampireEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private final int MAX_LEVEL = 2;
    private final int ANGRY_TICKS_PER_ATTACK = 120;
    private int bloodtimer = 100;
    private IEntityLeader advancedLeader = null;
    private int angryTimer = 0;
    private Goal tasks_avoidHunter;
    @Nullable
    private ICaptureAttributes villageAttributes;
    private final ActionHandlerEntity<?> entityActionHandler;
    private final EntityClassType entityclass;
    private final EntityActionTier entitytier;
    private boolean attack;

    public BasicVampireEntity(EntityType<? extends BasicVampireEntity> type, World world) {
        super(type, world, true);
        this.canSuckBloodFromPlayer = true;
        this.hasArms = true;
        this.setSpawnRestriction(VampireBaseEntity.SpawnRestriction.SPECIAL);
        this.entitytier = EntityActionTier.Medium;
        this.entityclass = EntityClassType.getRandomClass(this.func_70681_au());
        IEntityActionUser.applyAttributes(this);
        this.entityActionHandler = new ActionHandlerEntity<BasicVampireEntity>(this);
        this.enableImobConversion();
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float p_70097_2_) {
        boolean flag = super.func_70097_a(damageSource, p_70097_2_);
        if (flag) {
            this.angryTimer += 120;
        }
        return flag;
    }

    @Override
    public void drinkBlood(int amt, float saturationMod) {
        super.drinkBlood(amt, saturationMod);
        boolean dedicated = ServerLifecycleHooks.getCurrentServer().func_71262_S();
        this.bloodtimer += amt * 40 + this.func_70681_au().nextInt(1000) * (dedicated ? 2 : 1);
    }

    @Nullable
    public IEntityLeader getAdvancedLeader() {
        return this.advancedLeader;
    }

    public void setAdvancedLeader(@Nullable IEntityLeader advancedLeader) {
        this.advancedLeader = advancedLeader;
    }

    @Override
    public int getLevel() {
        return (Integer)this.func_184212_Q().func_187225_a(LEVEL);
    }

    @Override
    public void setLevel(int level) {
        if (level >= 0) {
            this.func_184212_Q().func_187227_b(LEVEL, (Object)level);
            this.updateEntityAttributes();
            if (level == 2) {
                this.func_195064_c(new EffectInstance(Effects.field_76429_m, 1000000, 1));
            }
            if (level == 1) {
                this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151040_l));
            } else {
                this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
            }
        }
    }

    @Override
    public int getMaxLevel() {
        return 2;
    }

    public int func_70627_aG() {
        return 600;
    }

    @Override
    public boolean isIgnoringSundamage() {
        float health = this.func_110143_aJ() / this.func_110138_aP();
        return super.isIgnoringSundamage() || this.angryTimer > 0 && health < 0.7f || health < 0.3f;
    }

    @Override
    public void attackVillage(ICaptureAttributes totem) {
        this.field_70714_bg.func_85156_a(this.tasks_avoidHunter);
        this.villageAttributes = totem;
        this.attack = true;
    }

    @Override
    public void defendVillage(ICaptureAttributes totem) {
        this.field_70714_bg.func_85156_a(this.tasks_avoidHunter);
        this.villageAttributes = totem;
        this.attack = false;
    }

    @Override
    public int getEntityTextureType() {
        int i = (Integer)this.func_184212_Q().func_187225_a(TYPE);
        return Math.max(i, 0);
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.advancedLeader != null) {
            this.advancedLeader.decreaseFollowerCount();
        }
    }

    @Override
    public int suggestLevel(Difficulty d) {
        switch (this.field_70146_Z.nextInt(5)) {
            case 0: {
                return (int)((float)d.minPercLevel / 100.0f * 2.0f);
            }
            case 1: {
                return (int)((float)d.avgPercLevel / 100.0f * 2.0f);
            }
            case 2: {
                return (int)((float)d.maxPercLevel / 100.0f * 2.0f);
            }
        }
        return this.field_70146_Z.nextInt(3);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.advancedLeader != null && !this.advancedLeader.getRepresentingEntity().func_70089_S()) {
            this.advancedLeader = null;
        }
    }

    @Override
    public boolean wantsBlood() {
        return this.bloodtimer == 0;
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if ((Integer)this.func_184212_Q().func_187225_a(TYPE) == -1) {
            this.func_184212_Q().func_187227_b(TYPE, (Object)this.func_70681_au().nextInt(126));
        }
    }

    @Override
    protected float calculateFireDamage(float amount) {
        float protectionMod = 1.0f;
        EffectInstance protection = this.func_70660_b(ModEffects.fire_protection);
        if (protection != null) {
            protectionMod = 1.0f / (2.0f + (float)protection.func_76458_c());
        }
        double d = amount * protectionMod;
        BalanceMobProps.mobProps.getClass();
        return (float)(d * 2.0) * ((float)this.getLevel() * 0.5f + 1.0f);
    }

    protected SoundEvent func_184639_G() {
        return ModSounds.entity_vampire_scream;
    }

    protected int func_70693_a(PlayerEntity player) {
        return 6 + this.getLevel();
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.updateEntityAttributes();
    }

    @Override
    public void func_70037_a(CompoundNBT tagCompund) {
        super.func_70037_a(tagCompund);
        if (tagCompund.func_74764_b("level")) {
            this.setLevel(tagCompund.func_74762_e("level"));
        }
        if (tagCompund.func_74764_b("attack")) {
            this.attack = tagCompund.func_74767_n("attack");
        }
        if (tagCompund.func_74764_b("type")) {
            int t = tagCompund.func_74762_e("type");
            this.func_184212_Q().func_187227_b(TYPE, (Object)(t < 126 && t >= 0 ? t : -1));
        }
        if (this.entityActionHandler != null) {
            this.entityActionHandler.read(tagCompund);
        }
    }

    protected void updateEntityAttributes() {
        int l = Math.max(this.getLevel(), 0);
        IAttributeInstance iAttributeInstance = this.func_110148_a(SharedMonsterAttributes.field_111267_a);
        BalanceMobProps.mobProps.getClass();
        BalanceMobProps.mobProps.getClass();
        iAttributeInstance.func_111128_a(30.0 + 3.0 * (double)l);
        IAttributeInstance iAttributeInstance2 = this.func_110148_a(SharedMonsterAttributes.field_111264_e);
        BalanceMobProps.mobProps.getClass();
        iAttributeInstance2.func_111128_a(3.0 + (double)BalanceMobProps.mobProps.CONVERTED_MOB_DEFAULT_DMG * (double)l);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(BalanceMobProps.mobProps.VAMPIRE_SPEED);
    }

    @Override
    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74768_a("level", this.getLevel());
        nbt.func_74768_a("type", this.getEntityTextureType());
        nbt.func_74757_a("attack", this.attack);
        nbt.func_74768_a("entityclasstype", EntityClassType.getID(this.entityclass));
        if (this.entityActionHandler != null) {
            this.entityActionHandler.write(nbt);
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(LEVEL, (Object)-1);
        this.func_184212_Q().func_187214_a(TYPE, (Object)-1);
    }

    @Override
    protected EntityType<?> getIMobTypeOpt(boolean iMob) {
        return iMob ? ModEntities.vampire_imob : ModEntities.vampire;
    }

    @Override
    public EntityClassType getEntityClass() {
        return this.entityclass;
    }

    @Override
    public EntityActionTier getEntityTier() {
        return this.entitytier;
    }

    @Override
    public ActionHandlerEntity getActionHandler() {
        return this.entityActionHandler;
    }

    @Override
    @Nullable
    public ICaptureAttributes getCaptureInfo() {
        return this.villageAttributes;
    }

    @Override
    @Nullable
    public AxisAlignedBB getTargetVillageArea() {
        return this.villageAttributes == null ? null : this.villageAttributes.getVillageArea();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.bloodtimer > 0) {
            --this.bloodtimer;
        }
        if (this.angryTimer > 0) {
            --this.angryTimer;
        }
        if (this.field_70173_aa % 9 == 3 && ((Boolean)VampirismConfig.BALANCE.vpFireResistanceReplace.get()).booleanValue() && this.func_70644_a(Effects.field_76426_n)) {
            EffectInstance fireResistance = this.func_184596_c(Effects.field_76426_n);
            assert (fireResistance != null);
            this.func_70688_c(fireResistance);
            this.func_195064_c(new EffectInstance(ModEffects.fire_protection, fireResistance.func_76459_b(), fireResistance.func_76458_c()));
        }
        if (this.entityActionHandler != null) {
            this.entityActionHandler.handle();
        }
    }

    @Override
    public void stopVillageAttackDefense() {
        this.func_200203_b(null);
        this.villageAttributes = null;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new BreakDoorGoal((MobEntity)this, difficulty -> difficulty == net.minecraft.world.Difficulty.HARD));
        this.tasks_avoidHunter = new AvoidEntityGoal((CreatureEntity)this, CreatureEntity.class, 10.0f, 1.0, 1.1, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, VReference.HUNTER_FACTION));
        this.field_70714_bg.func_75776_a(2, this.tasks_avoidHunter);
        this.field_70714_bg.func_75776_a(2, new RestrictSunVampireGoal<BasicVampireEntity>(this));
        this.field_70714_bg.func_75776_a(3, new FleeSunVampireGoal<BasicVampireEntity>(this, 0.9, false));
        this.field_70714_bg.func_75776_a(4, (Goal)new AttackMeleeNoSunGoal(this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, new BiteNearbyEntityVampireGoal<BasicVampireEntity>(this));
        this.field_70714_bg.func_75776_a(6, (Goal)new FollowAdvancedVampireGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(7, new MoveToBiteableVampireGoal<BasicVampireEntity>(this, 0.75));
        this.field_70714_bg.func_75776_a(8, (Goal)new MoveThroughVillageGoal((CreatureEntity)this, 0.6, true, 600, () -> false));
        this.field_70714_bg.func_75776_a(9, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.7));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtClosestVisibleGoal((MobEntity)this, PlayerEntity.class, 20.0f, 0.6f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, HunterBaseEntity.class, 17.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(4, new AttackVillageGoal<BasicVampireEntity>(this));
        this.field_70715_bh.func_75776_a(4, new DefendVillageGoal<BasicVampireEntity>(this));
        this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), true, false, true, false, null)));
        this.field_70715_bh.func_75776_a(6, (Goal)new NearestAttackableTargetGoal((MobEntity)this, CreatureEntity.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, null)));
        this.field_70715_bh.func_75776_a(7, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PatrollerEntity.class, 5, true, true, living -> Structures.field_215157_o.func_175796_a((IWorld)living.field_70170_p, living.func_180425_c())));
        this.field_70715_bh.func_75776_a(8, (Goal)new DefendLeaderGoal(this));
    }

    @Override
    public boolean isAttackingVillage() {
        return this.villageAttributes != null && this.attack;
    }

    @Override
    public boolean isDefendingVillage() {
        return this.villageAttributes != null && !this.attack;
    }

    public void convertToMinion(PlayerEntity lord) {
        FactionPlayerHandler.getOpt(lord).ifPresent(fph -> {
            if (fph.getMaxMinions() > 0) {
                MinionWorldData.getData(lord.field_70170_p).map(w -> w.getOrCreateController((FactionPlayerHandler)fph)).ifPresent(controller -> {
                    if (controller.hasFreeMinionSlot()) {
                        if (fph.getCurrentFaction() == this.getFaction()) {
                            VampireMinionEntity.VampireMinionData data = new VampireMinionEntity.VampireMinionData("Minion", this.getEntityTextureType(), false);
                            int id = controller.createNewMinionSlot(data, ModEntities.vampire_minion);
                            if (id < 0) {
                                field_184243_a.error("Failed to get minion slot");
                                return;
                            }
                            VampireMinionEntity minion = (VampireMinionEntity)ModEntities.vampire_minion.func_200721_a(this.field_70170_p);
                            minion.claimMinionSlot(id, (PlayerMinionController)controller);
                            minion.func_82149_j((Entity)this);
                            minion.markAsConverted();
                            controller.activateTask(0, MinionTasks.stay);
                            this.field_70170_p.func_217376_c((Entity)minion);
                            this.func_70106_y();
                        } else {
                            field_184243_a.warn("Wrong faction for minion");
                        }
                    } else {
                        field_184243_a.warn("No free slot");
                    }
                });
            } else {
                field_184243_a.error("Can't have minions");
            }
        });
    }

    protected boolean func_184645_a(PlayerEntity player, Hand hand) {
        if (this.func_70089_S() && !player.func_225608_bj_()) {
            int vampireLevel;
            if (!this.field_70170_p.field_72995_K && (vampireLevel = ((Integer)FactionPlayerHandler.getOpt(player).map(fph -> fph.getCurrentLevel(VReference.VAMPIRE_FACTION)).orElse((Object)0)).intValue()) > 0) {
                FactionPlayerHandler.getOpt(player).ifPresent(fph -> {
                    if (fph.getMaxMinions() > 0) {
                        ItemStack heldItem = player.func_184586_b(hand);
                        if (this.getLevel() > 0) {
                            if (heldItem.func_77973_b() == ModItems.vampire_minion_binding) {
                                player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.basic_vampire.minion.unavailable", new Object[0]), true);
                            }
                        } else {
                            boolean freeSlot = MinionWorldData.getData(player.field_70170_p).map(data -> data.getOrCreateController((FactionPlayerHandler)fph)).map(PlayerMinionController::hasFreeMinionSlot).orElse(false);
                            player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.basic_vampire.minion.available", new Object[0]), true);
                            if (heldItem.func_77973_b() == ModItems.vampire_minion_binding) {
                                if (!freeSlot) {
                                    player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.basic_vampire.minion.no_free_slot", new Object[0]), true);
                                } else {
                                    String key;
                                    switch (this.func_70681_au().nextInt(3)) {
                                        case 0: {
                                            key = "text.vampirism.basic_vampire.minion.start_serving1";
                                            break;
                                        }
                                        case 1: {
                                            key = "text.vampirism.basic_vampire.minion.start_serving2";
                                            break;
                                        }
                                        default: {
                                            key = "text.vampirism.basic_vampire.minion.start_serving3";
                                        }
                                    }
                                    player.func_145747_a((ITextComponent)new TranslationTextComponent(key, new Object[0]));
                                    this.convertToMinion(player);
                                    if (!player.field_71075_bZ.field_75098_d) {
                                        heldItem.func_190918_g(1);
                                    }
                                }
                            } else if (freeSlot) {
                                player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.basic_vampire.minion.require_binding", new Object[]{UtilLib.translate(ModItems.vampire_minion_binding.func_77658_a(), new Object[0])}), true);
                            }
                        }
                    }
                });
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public static class IMob
    extends BasicVampireEntity
    implements net.minecraft.entity.monster.IMob {
        public IMob(EntityType<? extends BasicVampireEntity> type, World world) {
            super(type, world);
        }
    }
}

