/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.vampire;

import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.difficulty.Difficulty;
import de.teamlapen.vampirism.api.entity.vampire.IVampireBaron;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.goals.AttackRangedDarkBloodGoal;
import de.teamlapen.vampirism.entity.goals.FleeGarlicVampireGoal;
import de.teamlapen.vampirism.entity.goals.LookAtClosestVisibleGoal;
import de.teamlapen.vampirism.entity.vampire.VampireBaseEntity;
import de.teamlapen.vampirism.items.HunterCoatItem;
import de.teamlapen.vampirism.player.VampirismPlayer;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.world.gen.biome.VampireBiome;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VampireBaronEntity
extends VampireBaseEntity
implements IVampireBaron {
    private static final Logger LOGGER = LogManager.getLogger(VampireBaronEntity.class);
    private static final DataParameter<Integer> LEVEL = EntityDataManager.func_187226_a(VampireBaronEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> ENRAGED = EntityDataManager.func_187226_a(VampireBaronEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> LADY = EntityDataManager.func_187226_a(VampireBaronEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final int MAX_LEVEL = 4;
    private int attackDecisionCounter = 0;
    private boolean rangedAttack = false;
    private boolean prevAttacking = false;
    private int followingEntities = 0;
    private static final int ENRAGED_TRANSITION_TIME = 15;
    private int enragedTransitionTime = 0;

    public static boolean spawnPredicateBaron(EntityType<? extends VampireBaronEntity> entityType, IWorld world, SpawnReason spawnReason, BlockPos blockPos, Random random) {
        return world.func_226691_t_(blockPos) instanceof VampireBiome && world.func_175659_aa() != net.minecraft.world.Difficulty.PEACEFUL && VampireBaronEntity.spawnPredicateCanSpawn(entityType, world, spawnReason, blockPos, random);
    }

    public VampireBaronEntity(EntityType<? extends VampireBaronEntity> type, World world) {
        super(type, world, true);
        this.garlicResist = EnumStrength.MEDIUM;
        this.hasArms = true;
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        boolean flag = super.func_70652_k(entity);
        if (flag && entity instanceof LivingEntity) {
            float tm = 1.0f;
            int mr = 1;
            if (entity instanceof PlayerEntity) {
                float pld = (float)(this.getLevel() + 1) - (float)((Integer)VampirePlayer.getOpt((PlayerEntity)entity).map(VampirismPlayer::getLevel).orElse((Object)0)).intValue() / 3.0f;
                tm = pld + 1.0f;
                int n = pld < 1.5f ? 1 : (mr = pld < 3.0f ? 2 : 3);
                if (HunterCoatItem.isFullyEquipped((PlayerEntity)entity)) {
                    tm *= 0.5f;
                }
            }
            if (entity instanceof VampireBaronEntity) {
                ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_76420_g, 40, 5));
            }
            ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_76437_t, (int)(200.0f * tm), this.field_70146_Z.nextInt(mr)));
            ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_76421_d, (int)(100.0f * tm), this.field_70146_Z.nextInt(mr)));
            this.attackDecisionCounter = 0;
        }
        return flag;
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float amount) {
        ++this.attackDecisionCounter;
        return super.func_70097_a(damageSource, amount);
    }

    @Override
    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        int i = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
        if (i < 60) {
            return false;
        }
        BlockPos blockpos = new BlockPos(this.func_226277_ct_(), this.func_174813_aQ().field_72338_b, this.func_226281_cx_());
        return ((Object)((Object)ModBlocks.cursed_earth)).equals(worldIn.func_180495_p(blockpos.func_177977_b()).func_177230_c()) && super.func_213380_a(worldIn, spawnReasonIn);
    }

    public boolean func_94059_bO() {
        return true;
    }

    public int func_70646_bf() {
        return 5;
    }

    public int func_184649_cE() {
        return 5;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getEnragedProgress() {
        return (float)this.enragedTransitionTime / 15.0f;
    }

    public boolean isEnraged() {
        return (Boolean)this.func_184212_Q().func_187225_a(ENRAGED);
    }

    public boolean isLady() {
        return (Boolean)this.func_184212_Q().func_187225_a(LADY);
    }

    public void setLady(boolean lady) {
        this.func_184212_Q().func_187227_b(LADY, (Object)lady);
    }

    @Override
    public int getLevel() {
        return (Integer)this.func_184212_Q().func_187225_a(LEVEL);
    }

    @Override
    public void setLevel(int level) {
        if (level >= 0) {
            this.func_184212_Q().func_187227_b(LEVEL, (Object)level);
            this.updateEntityAttributes(false);
            float hp = this.func_110143_aJ() / this.func_110138_aP();
            this.func_70606_j(this.func_110138_aP() * hp);
            this.func_200203_b(this.func_225513_by_().func_150259_f().func_150257_a((ITextComponent)new TranslationTextComponent("entity.vampirism.vampire_baron.level", new Object[]{level + 1})));
        } else {
            this.func_200203_b(null);
        }
    }

    public int func_82145_z() {
        return 500;
    }

    @Override
    public int getMaxLevel() {
        return 4;
    }

    @Override
    public void decreaseFollowerCount() {
        this.followingEntities = Math.max(0, this.followingEntities - 1);
    }

    @Override
    public int getFollowingCount() {
        return this.followingEntities;
    }

    @Override
    public int getMaxFollowerCount() {
        return (int)((float)(BalanceMobProps.mobProps.ADVANCED_VAMPIRE_MAX_FOLLOWER * this.getLevel()) / (float)this.getMaxLevel() * 2.0f);
    }

    @Override
    public boolean increaseFollowerCount() {
        if (this.followingEntities < this.getMaxFollowerCount()) {
            ++this.followingEntities;
            return true;
        }
        return false;
    }

    @Override
    public LivingEntity getRepresentingEntity() {
        return this;
    }

    @Override
    public void func_70636_d() {
        if (!this.prevAttacking && this.func_70638_az() != null) {
            this.prevAttacking = true;
            this.updateEntityAttributes(true);
        }
        if (this.prevAttacking && this.func_70638_az() == null) {
            this.prevAttacking = false;
            this.rangedAttack = false;
            this.attackDecisionCounter = 0;
            this.updateEntityAttributes(false);
        }
        if (!this.field_70170_p.field_72995_K && this.isGettingSundamage((IWorld)this.field_70170_p)) {
            this.teleportAway();
        }
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null && this.field_70173_aa % 128 == 0) {
            if (this.rangedAttack) {
                if (this.field_70146_Z.nextInt(2) == 0 && this.field_70699_by.func_75494_a((Entity)this.func_70638_az(), 0) != null) {
                    this.rangedAttack = false;
                }
            } else if (this.attackDecisionCounter > 4 || this.field_70146_Z.nextInt(6) == 0) {
                this.rangedAttack = true;
                this.attackDecisionCounter = 0;
            }
            if (this.getLevel() > 3 && this.field_70146_Z.nextInt(9) == 0) {
                this.func_195064_c(new EffectInstance(Effects.field_76441_p, 60));
            }
        }
        if (this.field_70170_p.func_201670_d()) {
            if (this.isEnraged() && this.enragedTransitionTime < 15) {
                ++this.enragedTransitionTime;
            } else if (!this.isEnraged() && this.enragedTransitionTime > 0) {
                --this.enragedTransitionTime;
            }
        }
        super.func_70636_d();
    }

    public void func_70074_a(LivingEntity entity) {
        super.func_70074_a(entity);
        if (entity instanceof VampireBaronEntity) {
            this.func_70606_j(this.func_110138_aP());
        }
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.func_184212_Q().func_187227_b(LADY, (Object)this.func_70681_au().nextBoolean());
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    public int suggestLevel(Difficulty d) {
        int avg = Math.round(((float)d.avgPercLevel / 100.0f - 0.35714287f) / 0.64285713f * 4.0f);
        int max = Math.round(((float)d.maxPercLevel / 100.0f - 0.35714287f) / 0.64285713f * 4.0f);
        int min = Math.round(((float)d.minPercLevel / 100.0f - 0.35714287f) / 0.64285713f * 4.0f);
        switch (this.field_70146_Z.nextInt(7)) {
            case 0: {
                return min;
            }
            case 1: {
                return max + 1;
            }
            case 2: {
                return avg;
            }
            case 3: {
                return avg + 1;
            }
            case 4: 
            case 5: {
                return this.field_70146_Z.nextInt(5);
            }
        }
        return this.field_70146_Z.nextInt(max + 2 - min) + min;
    }

    @Override
    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.setLevel(MathHelper.func_76125_a((int)nbt.func_74762_e("level"), (int)0, (int)4));
        this.func_184212_Q().func_187227_b(LADY, (Object)nbt.func_74767_n("lady"));
    }

    @Override
    protected float calculateFireDamage(float amount) {
        double d = amount;
        BalanceMobProps.mobProps.getClass();
        return (float)(d * 3.0);
    }

    protected int func_70693_a(PlayerEntity player) {
        return 20 + 5 * this.getLevel();
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.updateEntityAttributes(false);
    }

    public void func_70624_b(@Nullable LivingEntity target) {
        super.func_70624_b(target);
        this.func_184212_Q().func_187227_b(ENRAGED, (Object)(target != null ? 1 : 0));
    }

    @Override
    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74768_a("level", this.getLevel());
        nbt.func_74757_a("lady", this.isLady());
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(LEVEL, (Object)-1);
        this.func_184212_Q().func_187214_a(ENRAGED, (Object)false);
        this.func_184212_Q().func_187214_a(LADY, (Object)false);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(4, (Goal)new FleeGarlicVampireGoal(this, (double)0.9f, false));
        this.field_70714_bg.func_75776_a(5, (Goal)new BaronAIAttackMelee(this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new BaronAIAttackRanged(this, 60, 64, 6.0f, 4.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, 6.0f, 0.6, (double)0.7f, input -> input != null && !this.isLowerLevel((LivingEntity)input)));
        this.field_70714_bg.func_75776_a(7, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.2));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtClosestVisibleGoal((MobEntity)this, PlayerEntity.class, 10.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, input -> input != null && this.isLowerLevel((LivingEntity)input)));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, VampireBaronEntity.class, true, false));
    }

    protected void updateEntityAttributes(boolean aggressive) {
        if (aggressive) {
            this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(20.0);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(BalanceMobProps.mobProps.VAMPIRE_BARON_MOVEMENT_SPEED * Math.pow((BalanceMobProps.mobProps.VAMPIRE_BARON_IMPROVEMENT_PER_LEVEL - 1.0) / 5.0 + 1.0, this.getLevel()));
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(5.0);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(BalanceMobProps.mobProps.VAMPIRE_BARON_MOVEMENT_SPEED * Math.pow(BalanceMobProps.mobProps.VAMPIRE_BARON_IMPROVEMENT_PER_LEVEL, this.getLevel()) / 3.0);
        }
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(BalanceMobProps.mobProps.VAMPIRE_BARON_MAX_HEALTH * Math.pow(BalanceMobProps.mobProps.VAMPIRE_BARON_IMPROVEMENT_PER_LEVEL, this.getLevel()));
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(BalanceMobProps.mobProps.VAMPIRE_BARON_ATTACK_DAMAGE * Math.pow(BalanceMobProps.mobProps.VAMPIRE_BARON_IMPROVEMENT_PER_LEVEL, this.getLevel()));
    }

    private boolean isLowerLevel(LivingEntity player) {
        if (player instanceof PlayerEntity) {
            int playerLevel = (Integer)FactionPlayerHandler.getOpt((PlayerEntity)player).map(FactionPlayerHandler::getCurrentLevel).orElse((Object)0);
            return (float)(playerLevel - 8) / 2.0f - (float)this.getLevel() <= 0.0f;
        }
        return false;
    }

    private class BaronAIAttackRanged
    extends AttackRangedDarkBloodGoal {
        BaronAIAttackRanged(VampireBaronEntity entity, int cooldown, int maxDistance, float damage, float indirectDamage) {
            super(entity, cooldown, maxDistance, damage, indirectDamage);
        }

        @Override
        public boolean func_75250_a() {
            return VampireBaronEntity.this.func_70638_az() != null && (VampireBaronEntity.this.rangedAttack || !VampireBaronEntity.this.func_70781_l());
        }
    }

    private class BaronAIAttackMelee
    extends MeleeAttackGoal {
        BaronAIAttackMelee(CreatureEntity creature, double speedIn) {
            super(creature, speedIn, false);
        }

        public boolean func_75253_b() {
            return !VampireBaronEntity.this.rangedAttack && super.func_75253_b();
        }

        public boolean func_75250_a() {
            return !VampireBaronEntity.this.rangedAttack && super.func_75250_a();
        }
    }
}

