/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory.container;

import de.teamlapen.lib.lib.inventory.InventoryContainer;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.core.ModContainer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntArray;
import net.minecraftforge.fml.network.IContainerFactory;

public class PotionTableContainer
extends InventoryContainer {
    public static InventoryContainer.SelectorInfo[] SELECTOR_INFOS = new InventoryContainer.SelectorInfo[6];
    public static InventoryContainer.SelectorInfo[] SELECTOR_INFOS_EXTENDED = new InventoryContainer.SelectorInfo[8];
    private final boolean extended;
    private final IIntArray syncedProperties;

    public PotionTableContainer(int id, PlayerInventory playerInventory, IWorldPosCallable worldPos, @Nonnull IInventory inventory, boolean extended, @Nullable IIntArray syncedProperties) {
        super(ModContainer.extended_potion_table, id, playerInventory, worldPos, inventory, extended ? SELECTOR_INFOS_EXTENDED : SELECTOR_INFOS);
        assert (inventory.func_70302_i_() >= (extended ? 8 : 6));
        this.syncedProperties = syncedProperties == null ? new IntArray(2) : syncedProperties;
        this.addPlayerSlots(playerInventory);
        this.func_216961_a(this.syncedProperties);
        this.extended = extended;
    }

    public int getBrewTime() {
        return this.syncedProperties.func_221476_a(0);
    }

    public int getFuelTime() {
        return this.syncedProperties.func_221476_a(1);
    }

    public boolean isExtendedTable() {
        return this.extended;
    }

    @Override
    protected boolean isSlotEnabled(int id) {
        return id <= 5 || this.isExtendedTable();
    }

    static {
        PotionTableContainer.SELECTOR_INFOS[0] = PotionTableContainer.SELECTOR_INFOS_EXTENDED[0] = new InventoryContainer.SelectorInfo(Items.field_151065_br, 23, 14);
        PotionTableContainer.SELECTOR_INFOS[1] = PotionTableContainer.SELECTOR_INFOS_EXTENDED[1] = new InventoryContainer.SelectorInfo(stack -> VampirismAPI.extendedBrewingRecipeRegistry().isValidExtraIngredient((ItemStack)stack), 101, 16);
        PotionTableContainer.SELECTOR_INFOS[2] = PotionTableContainer.SELECTOR_INFOS_EXTENDED[2] = new InventoryContainer.SelectorInfo(stack -> VampirismAPI.extendedBrewingRecipeRegistry().isValidIngredient((ItemStack)stack), 126, 8);
        PotionTableContainer.SELECTOR_INFOS[3] = PotionTableContainer.SELECTOR_INFOS_EXTENDED[3] = new InventoryContainer.SelectorInfo(stack -> VampirismAPI.extendedBrewingRecipeRegistry().isValidInput((ItemStack)stack), 148, 59);
        PotionTableContainer.SELECTOR_INFOS[4] = PotionTableContainer.SELECTOR_INFOS_EXTENDED[4] = new InventoryContainer.SelectorInfo(stack -> VampirismAPI.extendedBrewingRecipeRegistry().isValidInput((ItemStack)stack), 126, 59);
        PotionTableContainer.SELECTOR_INFOS[5] = PotionTableContainer.SELECTOR_INFOS_EXTENDED[5] = new InventoryContainer.SelectorInfo(stack -> VampirismAPI.extendedBrewingRecipeRegistry().isValidInput((ItemStack)stack), 104, 59);
        PotionTableContainer.SELECTOR_INFOS_EXTENDED[6] = new InventoryContainer.SelectorInfo(stack -> VampirismAPI.extendedBrewingRecipeRegistry().isValidInput((ItemStack)stack), 82, 59);
        PotionTableContainer.SELECTOR_INFOS_EXTENDED[7] = new InventoryContainer.SelectorInfo(stack -> VampirismAPI.extendedBrewingRecipeRegistry().isValidInput((ItemStack)stack), 60, 59);
    }

    public static class Factory
    implements IContainerFactory<PotionTableContainer> {
        @Nullable
        public PotionTableContainer create(int windowId, PlayerInventory inv, PacketBuffer data) {
            if (data == null) {
                return new PotionTableContainer(windowId, inv, IWorldPosCallable.field_221489_a, (IInventory)new Inventory(6), false, null);
            }
            boolean extraSlots = data.readBoolean();
            return new PotionTableContainer(windowId, inv, IWorldPosCallable.field_221489_a, (IInventory)new Inventory(extraSlots ? 8 : 6), extraSlots, null);
        }
    }
}

