/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory.container;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.task.Task;
import de.teamlapen.vampirism.api.entity.player.task.TaskRequirement;
import de.teamlapen.vampirism.core.ModContainer;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.network.TaskActionPacket;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TaskBoardContainer
extends Container {
    @Nonnull
    private final Set<Task> completableTasks = Sets.newHashSet();
    @Nonnull
    private final Set<Task> completedTasks = Sets.newHashSet();
    @Nonnull
    private final List<Task> visibleTasks = Lists.newArrayList();
    @Nonnull
    private final Set<Task> notAcceptedTasks = Sets.newHashSet();
    @Nonnull
    private final TextFormatting factionColor;
    @Nonnull
    private final IFactionPlayer<?> factionPlayer;
    @Nullable
    private Map<Task, Map<ResourceLocation, Integer>> completedRequirements;
    private UUID taskBoardId;

    public TaskBoardContainer(int id, PlayerInventory playerInventory) {
        super(ModContainer.task_master, id);
        this.factionPlayer = FactionPlayerHandler.get(playerInventory.field_70458_d).getCurrentFactionPlayer().get();
        this.factionColor = this.factionPlayer.getFaction().getChatColor();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void init(@Nonnull Set<Task> completableTasks, @Nonnull List<Task> visibleTasks, @Nonnull Set<Task> notAcceptedTasks, @Nonnull Map<Task, Map<ResourceLocation, Integer>> completedRequirements, UUID taskBoardId) {
        this.completableTasks.addAll(completableTasks);
        this.visibleTasks.addAll(visibleTasks.stream().filter(task -> !this.visibleTasks.contains(task)).sorted((task1, task2) -> this.completableTasks.contains(task1) && !this.completableTasks.contains(task2) || !completableTasks.contains(task1) && !this.completedTasks.contains(task1) && this.completedTasks.contains(task2) ? -1 : 0).collect(Collectors.toList()));
        this.completedRequirements = completedRequirements;
        this.taskBoardId = taskBoardId;
        this.notAcceptedTasks.addAll(notAcceptedTasks);
    }

    public boolean func_75145_c(@Nonnull PlayerEntity playerIn) {
        return (Boolean)FactionPlayerHandler.getOpt(playerIn).map(player -> player.getCurrentFaction() != null).orElse((Object)false);
    }

    public boolean canCompleteTask(Task task) {
        return this.completableTasks.contains((Object)task);
    }

    public boolean isTaskNotAccepted(Task task) {
        return this.notAcceptedTasks.contains((Object)task);
    }

    public boolean isRequirementCompleted(Task task, TaskRequirement.Requirement<?> requirement) {
        if (this.isCompleted(task)) {
            return true;
        }
        if (this.completedRequirements != null && this.completedRequirements.containsKey((Object)task)) {
            return this.completedRequirements.get((Object)task).containsKey(requirement.getId()) && this.completedRequirements.get((Object)task).get(requirement.getId()) >= requirement.getAmount(this.factionPlayer);
        }
        return false;
    }

    public boolean areRequirementsCompleted(Task task, TaskRequirement.Type type) {
        if (this.isCompleted(task)) {
            return true;
        }
        if (this.completedRequirements != null && this.completedRequirements.containsKey((Object)task)) {
            for (TaskRequirement.Requirement<?> requirement : task.getRequirement().requirements().get((Object)type)) {
                if (this.completedRequirements.get((Object)task).containsKey(requirement.getId()) && this.completedRequirements.get((Object)task).get(requirement.getId()) >= requirement.getAmount(this.factionPlayer)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int getRequirementStatus(Task task, TaskRequirement.Requirement<?> requirement) {
        assert (this.completedRequirements != null);
        if (this.completedRequirements.containsKey((Object)task)) {
            return this.completedRequirements.get((Object)task).get(requirement.getId());
        }
        return requirement.getAmount(this.factionPlayer);
    }

    public void completeTask(Task task) {
        if (this.canCompleteTask(task)) {
            VampirismMod.dispatcher.sendToServer(new TaskActionPacket(task, this.taskBoardId, TaskAction.COMPLETE));
            this.completedTasks.add(task);
            this.completableTasks.remove((Object)task);
        }
    }

    public void acceptTask(Task task) {
        VampirismMod.dispatcher.sendToServer(new TaskActionPacket(task, this.taskBoardId, TaskAction.ACCEPT));
        this.notAcceptedTasks.remove((Object)task);
    }

    public void abortTask(Task task) {
        VampirismMod.dispatcher.sendToServer(new TaskActionPacket(task, this.taskBoardId, TaskAction.ABORT));
        this.notAcceptedTasks.add(task);
    }

    public boolean isCompleted(Task task) {
        return this.completedTasks.contains((Object)task);
    }

    public int size() {
        return this.visibleTasks.size();
    }

    @Nonnull
    public List<Task> getVisibleTasks() {
        return this.visibleTasks;
    }

    public Task getTask(int i) {
        return this.visibleTasks.get(i);
    }

    @Nonnull
    public TextFormatting getFactionColor() {
        return this.factionColor;
    }

    @Nonnull
    public IPlayableFaction<?> getFaction() {
        return this.factionPlayer.getFaction();
    }

    public static enum TaskAction {
        COMPLETE,
        ACCEPT,
        ABORT;

    }
}

