/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory.recipes;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import de.teamlapen.vampirism.config.VampirismConfig;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class ConfigCondition
implements ICondition {
    private static final ResourceLocation ID = new ResourceLocation("vampirism", "config");
    private final Supplier<Boolean> tester;
    private final String option;

    public ConfigCondition(String option) {
        this.tester = this.getTester(option);
        this.option = option;
    }

    public ResourceLocation getID() {
        return ID;
    }

    public boolean test() {
        return this.tester.get();
    }

    private Supplier<Boolean> getTester(String option) {
        switch (option) {
            case "auto_convert": {
                return () -> ((ForgeConfigSpec.BooleanValue)VampirismConfig.SERVER.autoConvertGlassBottles).get();
            }
            case "umbrella": {
                return () -> ((ForgeConfigSpec.BooleanValue)VampirismConfig.SERVER.umbrella).get();
            }
        }
        throw new JsonSyntaxException("Unknown config option: " + option);
    }

    public static class Serializer
    implements IConditionSerializer<ConfigCondition> {
        public ResourceLocation getID() {
            return ID;
        }

        public ConfigCondition read(JsonObject json) {
            String option = json.get("option").getAsString();
            return new ConfigCondition(option);
        }

        public void write(JsonObject json, ConfigCondition value) {
            json.addProperty("option", value.option);
        }
    }
}

