/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.blocks.BloodContainerBlock;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.fluids.BloodHelper;
import de.teamlapen.vampirism.items.VampirismItem;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import javax.annotation.Nonnull;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class FeedingAdapterItem
extends VampirismItem {
    private static final String regName = "feeding_adapter";

    public FeedingAdapterItem() {
        super(regName, new Item.Properties().func_200917_a(1).func_200916_a(VampirismMod.creativeTab));
    }

    @Nonnull
    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.DRINK;
    }

    public int func_77626_a(ItemStack stack) {
        return 15;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, @Nonnull Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        VampirePlayer vampire = VampirePlayer.get(playerIn);
        if (vampire.getLevel() == 0) {
            return new ActionResult(ActionResultType.PASS, (Object)stack);
        }
        if (vampire.getBloodStats().needsBlood() && !BloodHelper.getBloodContainerInInventory(playerIn.field_71071_by, true, false).func_190926_b()) {
            playerIn.func_184598_c(handIn);
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        return new ActionResult(ActionResultType.PASS, (Object)stack);
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        if (!(player instanceof PlayerEntity) || !player.func_70089_S()) {
            player.func_184597_cx();
            return;
        }
        ItemStack bloodContainer = BloodHelper.getBloodContainerInInventory(((PlayerEntity)player).field_71071_by, true, false);
        FluidStack fluidStack = BloodContainerBlock.getFluidFromItemStack(bloodContainer);
        int blood = fluidStack.isEmpty() || fluidStack.getFluid() != ModFluids.blood ? 0 : fluidStack.getAmount();
        VampirePlayer vampire = VampirePlayer.get((PlayerEntity)player);
        if (vampire.getLevel() == 0 || blood == 0 || !vampire.getBloodStats().needsBlood()) {
            player.func_184597_cx();
            return;
        }
        if (blood > 0 && count == 1) {
            int drink = Math.min(blood, 300);
            BloodContainerBlock.writeFluidToItemStack(bloodContainer, new FluidStack(ModFluids.blood, blood - drink));
            vampire.drinkBlood(Math.round((float)drink / 100.0f), 0.3f, false);
            if ((blood -= drink) > 0) {
                player.func_184598_c(player.func_184600_cs());
            }
        }
    }
}

