/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.items.VampirismHunterArmor;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class HunterCoatItem
extends VampirismHunterArmor
implements IItemWithTier {
    private static final String baseRegName = "hunter_coat";
    private final int[] DAMAGE_REDUCTION_ULTIMATE = new int[]{3, 7, 9, 3};
    private final int[] DAMAGE_REDUCTION_ENHANCED = new int[]{3, 6, 8, 3};
    private final int[] DAMAGE_REDUCTION_NORMAL = new int[]{2, 5, 6, 2};
    private final IItemWithTier.TIER tier;

    public static boolean isFullyEquipped(PlayerEntity player) {
        for (ItemStack stack : player.field_71071_by.field_70460_b) {
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof HunterCoatItem) continue;
            return false;
        }
        return true;
    }

    public HunterCoatItem(EquipmentSlotType equipmentSlotIn, IItemWithTier.TIER tier) {
        super(baseRegName, tier.func_176610_l(), (IArmorMaterial)ArmorMaterial.IRON, equipmentSlotIn, new Item.Properties().func_200916_a(VampirismMod.creativeTab));
        this.tier = tier;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        this.addTierInformation(tooltip);
    }

    @Override
    public String getBaseRegName() {
        return baseRegName;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        switch (this.getVampirismTier()) {
            case ENHANCED: {
                return this.getTextureLocation("hunter_coat_enhanced", slot, type);
            }
            case ULTIMATE: {
                return this.getTextureLocation("hunter_coat_ultimate", slot, type);
            }
        }
        return this.getTextureLocation(baseRegName, slot, type);
    }

    @Override
    public IItemWithTier.TIER getVampirismTier() {
        return this.tier;
    }

    @Override
    protected int getDamageReduction(int slot, ItemStack stack) {
        IItemWithTier.TIER tier = this.getVampirismTier();
        switch (tier) {
            case ULTIMATE: {
                return this.DAMAGE_REDUCTION_ULTIMATE[slot];
            }
            case ENHANCED: {
                return this.DAMAGE_REDUCTION_ENHANCED[slot];
            }
        }
        return this.DAMAGE_REDUCTION_NORMAL[slot];
    }

    @Override
    protected double getToughness(int slot, ItemStack stack) {
        return 2.0;
    }
}

