/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.guide.pages;

import com.mojang.blaze3d.systems.RenderSystem;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.Page;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import de.maxanier.guideapi.api.impl.abstraction.EntryAbstract;
import de.maxanier.guideapi.gui.BaseScreen;
import de.teamlapen.lib.lib.util.UtilLib;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

public class PageTable
extends Page {
    private List<String[]> lines;
    private int[] width;
    private String headline;

    private PageTable(List<String[]> lines, int[] width, String headline) {
        this.lines = lines;
        this.width = width;
        this.headline = headline;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void draw(Book book, CategoryAbstract category, EntryAbstract entry, int guiLeft, int guiTop, int mouseX, int mouseY, BaseScreen guiBase, FontRenderer fontRendererObj) {
        float charWidth = fontRendererObj.func_211125_a('W');
        int y = guiTop + 12;
        int x = guiLeft + 39;
        if (this.headline != null) {
            fontRendererObj.func_211126_b("\u00a7l" + this.headline, (float)x, (float)y, 0);
            fontRendererObj.getClass();
            y += 9;
        }
        double d = x;
        fontRendererObj.getClass();
        double d2 = y + 9;
        double d3 = (float)x + (float)guiBase.xSize * 3.0f / 5.0f;
        fontRendererObj.getClass();
        this.drawLine(d, d2, d3, y + 9, guiBase.publicZLevel);
        for (String[] l : this.lines) {
            x = guiLeft + 39;
            for (int i = 0; i < l.length; ++i) {
                int mw = (int)((float)this.width[i] * charWidth);
                int aw = fontRendererObj.func_78256_a(l[i]);
                int dw = (mw - aw) / 2;
                fontRendererObj.func_211126_b(l[i], (float)(x + dw), (float)y, 0);
                x += mw;
            }
            fontRendererObj.getClass();
            y += 9;
        }
    }

    protected void drawLine(double x1, double y1, double x2, double y2, float publicZLevel) {
        RenderSystem.pushMatrix();
        GL11.glDisable((int)3553);
        RenderSystem.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderSystem.lineWidth((float)2.0f);
        BufferBuilder builder = Tessellator.func_178181_a().func_178180_c();
        builder.func_181668_a(1, DefaultVertexFormats.field_181705_e);
        builder.func_225582_a_((double)((float)x1), (double)((float)y1), (double)publicZLevel).func_181675_d();
        builder.func_225582_a_((double)((float)x2), (double)((float)y2), (double)publicZLevel).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GL11.glEnable((int)3553);
        RenderSystem.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderSystem.popMatrix();
    }

    public static class Builder {
        int columns;
        List<String[]> lines;
        String headline;

        public Builder(int columns) {
            this.columns = columns;
            this.lines = new ArrayList<String[]>();
        }

        public Builder addLine(Object ... objects) {
            if (objects.length != this.columns) {
                throw new IllegalArgumentException("Every added line as to contain one String for every column");
            }
            String[] l = new String[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                l[i] = String.valueOf(objects[i]);
            }
            this.lines.add(l);
            return this;
        }

        public Builder addUnlocLine(String ... strings) {
            Object[] loc = new String[strings.length];
            for (int i = 0; i < strings.length; ++i) {
                loc[i] = UtilLib.translate(strings[i], new Object[0]);
            }
            return this.addLine(loc);
        }

        public PageTable build() {
            int[] width = new int[this.columns];
            for (int i = 0; i < this.columns; ++i) {
                int max = 0;
                for (String[] s : this.lines) {
                    int w = s[i].length();
                    if (w <= max) continue;
                    max = w;
                }
                width[i] = max;
            }
            return new PageTable(this.lines, width, this.headline);
        }

        public Builder setHeadline(String s) {
            this.headline = s;
            return this;
        }
    }
}

