/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.jei;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.items.IWeaponTableRecipe;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.inventory.recipes.ShapedWeaponTableRecipe;
import de.teamlapen.vampirism.inventory.recipes.ShapelessWeaponTableRecipe;
import de.teamlapen.vampirism.modcompat.jei.VampirismJEIPlugin;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class WeaponTableRecipeCategory
implements IRecipeCategory<IWeaponTableRecipe> {
    private final String localizedName = UtilLib.translate(ModBlocks.weapon_table.func_149739_a(), new Object[0]);
    private final IDrawable background;
    private final IDrawable icon;
    private static final ResourceLocation location = new ResourceLocation("vampirism", "textures/gui/weapon_table_clean.png");
    private static final ItemStack lavaStack = new ItemStack((IItemProvider)Items.field_151129_at);

    WeaponTableRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(location, 32, 14, 134, 77).addPadding(0, 33, 0, 0).build();
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModBlocks.weapon_table));
    }

    public void draw(IWeaponTableRecipe recipe, double mouseX, double mouseY) {
        ISkill[] requiredSkills;
        int x = 2;
        int y = 80;
        Minecraft minecraft = Minecraft.func_71410_x();
        if (recipe.getRequiredLavaUnits() > 0) {
            minecraft.func_175599_af().func_175042_a(lavaStack, 83, 13);
        }
        if (recipe.getRequiredLevel() > 1) {
            String level = UtilLib.translate("gui.vampirism.hunter_weapon_table.level", recipe.getRequiredLevel());
            minecraft.field_71466_p.func_211126_b(level, (float)x, (float)y, Color.gray.getRGB());
            minecraft.field_71466_p.getClass();
            y += 9 + 2;
        }
        if ((requiredSkills = recipe.getRequiredSkills()) != null && requiredSkills.length > 0) {
            StringBuilder skills = new StringBuilder();
            for (ISkill skill : recipe.getRequiredSkills()) {
                skills.append(UtilLib.translate(skill.getTranslationKey(), new Object[0])).append(" ");
            }
            String skillText = UtilLib.translate("gui.vampirism.hunter_weapon_table.skill", skills.toString());
            minecraft.field_71466_p.func_78279_b(skillText, x, y, 132, Color.gray.getRGB());
        }
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public Class<? extends IWeaponTableRecipe> getRecipeClass() {
        return IWeaponTableRecipe.class;
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public ResourceLocation getUid() {
        return VampirismJEIPlugin.WEAPON_TABLE_RECIPE_ID;
    }

    public void setIngredients(IWeaponTableRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.func_192400_c());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
    }

    public void setRecipe(IRecipeLayout iRecipeLayout, IWeaponTableRecipe recipe, IIngredients ingredients) {
        int craftOutputSlot = 0;
        IGuiItemStackGroup guiItemStackGroup = iRecipeLayout.getItemStacks();
        guiItemStackGroup.init(craftOutputSlot, false, 111, 31);
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 4; ++x) {
                guiItemStackGroup.init(1 + x + y * 4, true, 1 + x * 19, 1 + y * 19);
            }
        }
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List outputs = ingredients.getOutputs(VanillaTypes.ITEM);
        if (recipe instanceof ShapedWeaponTableRecipe) {
            ShapedWeaponTableRecipe wrapper = (ShapedWeaponTableRecipe)recipe;
            this.setInputs(guiItemStackGroup, inputs, wrapper.getWidth(), wrapper.getHeight());
        } else if (recipe instanceof ShapelessWeaponTableRecipe) {
            this.setInputs(guiItemStackGroup, inputs);
            iRecipeLayout.setShapeless();
        }
        guiItemStackGroup.set(craftOutputSlot, (List)outputs.get(0));
    }

    private int getCraftingIndex(int i, int width, int height) {
        int index;
        if (width == 1) {
            index = height == 4 ? i * 4 + 1 : (height == 3 ? i * 4 + 1 : (height == 2 ? i * 4 + 1 : 0));
        } else if (height == 1) {
            index = i + 4;
        } else if (width == 2) {
            index = i;
            if (i > 1) {
                index += 2;
                if (i > 3) {
                    index += 2;
                }
            }
        } else if (width == 3) {
            index = i;
            if (i > 2) {
                ++index;
                if (i > 5) {
                    ++index;
                    if (i > 8) {
                        ++index;
                    }
                }
            }
        } else {
            index = height == 2 ? i + 4 : i;
        }
        return index;
    }

    private void setInputs(IGuiItemStackGroup ingredientGroup, List<List<ItemStack>> inputs) {
        int width;
        int height;
        if (inputs.size() > 4) {
            height = 4;
            width = 4;
        } else if (inputs.size() > 1) {
            height = 2;
            width = 2;
        } else {
            height = 1;
            width = 1;
        }
        this.setInputs(ingredientGroup, inputs, width, height);
    }

    private void setInputs(IGuiItemStackGroup ingredientGroup, List<List<ItemStack>> inputs, int width, int height) {
        for (int i = 0; i < inputs.size(); ++i) {
            List<ItemStack> recipeItem = inputs.get(i);
            int index = this.getCraftingIndex(i, width, height);
            ingredientGroup.set(1 + index, recipeItem);
        }
    }
}

