/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;

public class ActionBindingPacket
implements IMessage {
    public final int actionBindingId;
    public final IAction action;

    static void encode(ActionBindingPacket msg, PacketBuffer buf) {
        buf.func_150787_b(msg.actionBindingId);
        buf.func_180714_a(msg.action.getRegistryName().toString());
    }

    static ActionBindingPacket decode(PacketBuffer buf) {
        return new ActionBindingPacket(buf.func_150792_a(), (IAction)ModRegistries.ACTIONS.getValue(new ResourceLocation(buf.func_150789_c(Short.MAX_VALUE))));
    }

    public static void handle(ActionBindingPacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ctx.enqueueWork(() -> {
            if (msg.actionBindingId == 1) {
                FactionPlayerHandler.getOpt((PlayerEntity)ctx.getSender()).ifPresent(fph -> fph.setBoundAction1(msg.action, true));
            } else {
                FactionPlayerHandler.getOpt((PlayerEntity)ctx.getSender()).ifPresent(fph -> fph.setBoundAction2(msg.action, true));
            }
        });
        ctx.setPacketHandled(true);
    }

    public ActionBindingPacket(int actionBindingId, IAction action) {
        this.actionBindingId = actionBindingId;
        this.action = action;
    }
}

