/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.VampirismMod;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class AppearancePacket
implements IMessage {
    public final int entityId;
    public final String name;
    public final int[] data;

    static void encode(AppearancePacket msg, PacketBuffer buf) {
        buf.func_150787_b(msg.entityId);
        buf.func_180714_a(msg.name);
        buf.func_150787_b(msg.data.length);
        for (int value : msg.data) {
            buf.func_150787_b(value);
        }
    }

    static AppearancePacket decode(PacketBuffer buf) {
        int entityId = buf.func_150792_a();
        String newName = buf.func_150789_c(15);
        int[] data = new int[buf.func_150792_a()];
        for (int i = 0; i < data.length; ++i) {
            data[i] = buf.func_150792_a();
        }
        return new AppearancePacket(entityId, newName, data);
    }

    public static void handle(AppearancePacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ctx.enqueueWork(() -> VampirismMod.proxy.handleAppearancePacket((PlayerEntity)ctx.getSender(), msg));
        ctx.setPacketHandled(true);
    }

    public AppearancePacket(int entityId, String newName, int ... data) {
        this.entityId = entityId;
        this.name = newName;
        this.data = data;
    }
}

