/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.VampirismMod;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.commons.lang3.tuple.Pair;

public class RequestMinionSelectPacket
implements IMessage {
    public final List<Pair<Integer, ITextComponent>> minions;
    public final Action action;

    public static void handle(RequestMinionSelectPacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ctx.enqueueWork(() -> VampirismMod.proxy.handleRequestMinionSelect(msg.action, msg.minions));
        ctx.setPacketHandled(true);
    }

    static void encode(RequestMinionSelectPacket msg, PacketBuffer buf) {
        buf.func_150787_b(msg.action.ordinal());
        buf.func_150787_b(msg.minions.size());
        for (Pair<Integer, ITextComponent> minion : msg.minions) {
            buf.func_150787_b(((Integer)minion.getLeft()).intValue());
            buf.func_179256_a((ITextComponent)minion.getRight());
        }
    }

    static RequestMinionSelectPacket decode(PacketBuffer buf) {
        Action a = Action.values()[buf.func_150792_a()];
        int count = buf.func_150792_a();
        ArrayList<Pair<Integer, ITextComponent>> minions = new ArrayList<Pair<Integer, ITextComponent>>(count);
        for (int i = 0; i < count; ++i) {
            minions.add((Pair<Integer, ITextComponent>)Pair.of((Object)buf.func_150792_a(), (Object)buf.func_179258_d()));
        }
        return new RequestMinionSelectPacket(a, minions);
    }

    public RequestMinionSelectPacket(Action action, List<Pair<Integer, ITextComponent>> minions) {
        this.action = action;
        this.minions = minions;
    }

    public static enum Action {
        CALL;

    }
}

