/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.player.task.Task;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.inventory.container.TaskBoardContainer;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;

public class TaskActionPacket
implements IMessage {
    public final Task task;
    public final UUID entityId;
    public final TaskBoardContainer.TaskAction action;

    public TaskActionPacket(Task task, UUID entityId, TaskBoardContainer.TaskAction action) {
        this.task = task;
        this.entityId = entityId;
        this.action = action;
    }

    static void encode(TaskActionPacket msg, PacketBuffer buf) {
        buf.func_180714_a(Objects.requireNonNull(msg.task.getRegistryName()).toString());
        buf.func_179252_a(msg.entityId);
        buf.func_150787_b(msg.action.ordinal());
    }

    static TaskActionPacket decode(PacketBuffer buf) {
        return new TaskActionPacket((Task)ModRegistries.TASKS.getValue(new ResourceLocation(buf.func_150789_c(Short.MAX_VALUE))), buf.func_179253_g(), TaskBoardContainer.TaskAction.values()[buf.func_150792_a()]);
    }

    public static void handle(TaskActionPacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ctx.enqueueWork(() -> VampirismMod.proxy.handleTaskActionPacket(msg, (PlayerEntity)ctx.getSender()));
        ctx.setPacketHandled(true);
    }
}

