/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.player.task.Task;
import de.teamlapen.vampirism.core.ModRegistries;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;

public class TaskStatusPacket
implements IMessage {
    public final Set<Task> completableTasks;
    public final Collection<Task> visibleTasks;
    public final Set<Task> notAcceptedTasks;
    public final Map<Task, Map<ResourceLocation, Integer>> completedRequirements;
    public final int containerId;
    public final UUID taskBoardId;

    public TaskStatusPacket(Set<Task> completableTasks, Collection<Task> visibleTasks, Set<Task> notAcceptedTasks, Map<Task, Map<ResourceLocation, Integer>> completedRequirements, int containerId, UUID taskBoardId) {
        this.completableTasks = completableTasks;
        this.visibleTasks = visibleTasks;
        this.notAcceptedTasks = notAcceptedTasks;
        this.completedRequirements = completedRequirements;
        this.containerId = containerId;
        this.taskBoardId = taskBoardId;
    }

    static void encode(@Nonnull TaskStatusPacket msg, @Nonnull PacketBuffer buf) {
        buf.func_180714_a(msg.taskBoardId.toString());
        buf.func_150787_b(msg.containerId);
        buf.func_150787_b(msg.notAcceptedTasks.size());
        buf.func_150787_b(msg.completableTasks.size());
        buf.func_150787_b(msg.visibleTasks.size());
        buf.func_150787_b(msg.completedRequirements.size());
        msg.completableTasks.forEach(res -> buf.func_180714_a(Objects.requireNonNull(res.getRegistryName()).toString()));
        msg.visibleTasks.forEach(res -> buf.func_180714_a(Objects.requireNonNull(res.getRegistryName()).toString()));
        msg.notAcceptedTasks.forEach(res -> buf.func_180714_a(Objects.requireNonNull(res.getRegistryName()).toString()));
        msg.completedRequirements.forEach((task, resourceLocations) -> {
            buf.func_150787_b(resourceLocations.size());
            buf.func_180714_a(Objects.requireNonNull(task.getRegistryName()).toString());
            resourceLocations.forEach((resourceLocation, integer) -> {
                buf.func_180714_a(resourceLocation.toString());
                buf.func_150787_b(integer.intValue());
            });
        });
    }

    static TaskStatusPacket decode(@Nonnull PacketBuffer buf) {
        UUID taskBoardId = UUID.fromString(buf.func_218666_n());
        int containerId = buf.func_150792_a();
        int notAcceptedSize = buf.func_150792_a();
        int completableSize = buf.func_150792_a();
        int visibleSize = buf.func_150792_a();
        int completedReqSize = buf.func_150792_a();
        HashSet completable = Sets.newHashSet();
        for (int i = 0; i < completableSize; ++i) {
            completable.add(ModRegistries.TASKS.getValue(new ResourceLocation(buf.func_218666_n())));
        }
        ArrayList visible = Lists.newArrayList();
        for (int i = 0; i < visibleSize; ++i) {
            visible.add(ModRegistries.TASKS.getValue(new ResourceLocation(buf.func_218666_n())));
        }
        HashSet notAccepted = Sets.newHashSet();
        for (int i = 0; i < notAcceptedSize; ++i) {
            notAccepted.add(ModRegistries.TASKS.getValue(new ResourceLocation(buf.func_218666_n())));
        }
        HashMap completedRequirements = Maps.newHashMapWithExpectedSize((int)completedReqSize);
        for (int i = 0; i < completedReqSize; ++i) {
            int l;
            Task task = (Task)ModRegistries.TASKS.getValue(new ResourceLocation(buf.func_218666_n()));
            HashMap req = Maps.newHashMapWithExpectedSize((int)l);
            for (l = buf.func_150792_a(); l > 0; --l) {
                req.put(new ResourceLocation(buf.func_218666_n()), buf.func_150792_a());
            }
            completedRequirements.put(task, req);
        }
        return new TaskStatusPacket(completable, visible, notAccepted, completedRequirements, containerId, taskBoardId);
    }

    public static void handle(TaskStatusPacket msg, @Nonnull Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ctx.enqueueWork(() -> VampirismMod.proxy.handleTaskStatusPacket(msg));
        ctx.setPacketHandled(true);
    }
}

