/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import de.teamlapen.lib.HelperLib;
import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.entity.minion.MinionEntity;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UpgradeMinionStatPacket
implements IMessage {
    private static final Logger LOGGER = LogManager.getLogger();
    public final int entityId;
    public final int statId;

    public static void handle(UpgradeMinionStatPacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ctx.enqueueWork(() -> {
            Entity entity;
            ServerPlayerEntity player = ctx.getSender();
            if (player != null && (entity = player.field_70170_p.func_73045_a(msg.entityId)) instanceof MinionEntity && ((MinionEntity)entity).getMinionData().map(d -> d.upgradeStat(msg.statId, (MinionEntity)entity)).orElse(false).booleanValue()) {
                HelperLib.sync((MinionEntity)entity);
            }
        });
        ctx.setPacketHandled(true);
    }

    static void encode(UpgradeMinionStatPacket msg, PacketBuffer buf) {
        buf.func_150787_b(msg.entityId);
        buf.func_150787_b(msg.statId);
    }

    static UpgradeMinionStatPacket decode(PacketBuffer buf) {
        return new UpgradeMinionStatPacket(buf.func_150792_a(), buf.func_150792_a());
    }

    public UpgradeMinionStatPacket(int entityId, int statId) {
        this.entityId = entityId;
        this.statId = statId;
    }
}

