/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class GenericParticleData
implements IParticleData {
    public static final IParticleData.IDeserializer<GenericParticleData> DESERIALIZER = new IParticleData.IDeserializer<GenericParticleData>(){

        public GenericParticleData deserialize(ParticleType<GenericParticleData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            return new GenericParticleData(particleTypeIn, ResourceLocation.func_195826_a((StringReader)reader), reader.readInt(), reader.readInt());
        }

        public GenericParticleData read(ParticleType<GenericParticleData> particleTypeIn, PacketBuffer buffer) {
            return new GenericParticleData(particleTypeIn, buffer.func_192575_l(), buffer.func_150792_a(), buffer.func_150792_a(), buffer.readFloat());
        }
    };
    private final ResourceLocation texture;
    private final int color;
    private final int maxAge;
    private final float speed;
    private ParticleType<GenericParticleData> particleType;

    public GenericParticleData(ParticleType<GenericParticleData> particleType, ResourceLocation texture, int maxAge, int color) {
        this(particleType, texture, maxAge, color, 1.0f);
    }

    public GenericParticleData(ParticleType<GenericParticleData> particleType, ResourceLocation texture, int maxAge, int color, float speed) {
        this.particleType = particleType;
        this.texture = texture;
        this.maxAge = maxAge;
        this.color = color;
        this.speed = speed;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getColor() {
        return this.color;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getMaxAge() {
        return this.maxAge;
    }

    public String func_197555_a() {
        return ForgeRegistries.PARTICLE_TYPES.getKey(this.func_197554_b()) + " " + this.texture + " " + this.maxAge + " " + this.color;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getSpeed() {
        return this.speed;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getTexturePos() {
        return this.texture;
    }

    public ParticleType<?> func_197554_b() {
        return this.particleType;
    }

    public void func_197553_a(PacketBuffer packetBuffer) {
        packetBuffer.func_192572_a(this.texture);
        packetBuffer.func_150787_b(this.maxAge);
        packetBuffer.func_150787_b(this.color);
        packetBuffer.writeFloat(this.speed);
    }
}

