/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player;

import de.teamlapen.vampirism.api.VReference;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LevelAttributeModifier {
    private static final Logger LOGGER = LogManager.getLogger(LevelAttributeModifier.class);
    private static final Map<IAttribute, UUID> modifiers = new HashMap<IAttribute, UUID>();

    public static void registerModdedAttributeModifier(IAttribute attribute, UUID uuid) {
        modifiers.put(attribute, uuid);
    }

    public static void applyModifier(PlayerEntity player, IAttribute attribute, String name, int level, int lcap, double max, double type, AttributeModifier.Operation operation, boolean evenIntOnly) {
        UUID mod = modifiers.get(attribute);
        if (mod == null) {
            LOGGER.warn("Cannot modify {}, no modifier is registered", (Object)attribute);
            return;
        }
        double m = LevelAttributeModifier.calculateModifierValue(level, lcap, max, type);
        IAttributeInstance instance = player.func_110148_a(attribute);
        LevelAttributeModifier.rmMod(instance, mod);
        if (evenIntOnly) {
            m = Math.round(m / 2.0) * 2L;
        }
        instance.func_111121_a(new AttributeModifier(mod, attribute.func_111108_a() + " " + name + " Boost", m, operation));
    }

    public static double calculateModifierValue(int level, int lcap, double maxMod, double type) {
        return Math.pow(Math.min(level, lcap), type) / Math.pow(lcap, type) * maxMod;
    }

    private static void rmMod(IAttributeInstance att, UUID uuid) {
        AttributeModifier m = att.func_111127_a(uuid);
        if (m != null) {
            att.func_111124_b(m);
        }
    }

    public static UUID getUUID(IAttribute attribute) {
        return modifiers.get(attribute);
    }

    static {
        modifiers.put(SharedMonsterAttributes.field_111264_e, UUID.fromString("7600D8C4-3517-40BE-8CB1-359D46705A0F"));
        modifiers.put(SharedMonsterAttributes.field_111263_d, UUID.fromString("0FCBF922-DBEC-492A-82F5-99F73AFF5065"));
        modifiers.put(SharedMonsterAttributes.field_111267_a, UUID.fromString("56C17EFE-E3EC-4E27-A12F-99D2FE927B70"));
        modifiers.put(VReference.bloodExhaustion, UUID.fromString("4504ccfa-dfdc-11e5-b86d-9a79f06e9478"));
        modifiers.put(SharedMonsterAttributes.field_188790_f, UUID.fromString("37a4f596-2ff8-45e5-b074-c91df218f26b"));
    }
}

