/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.task.ITaskManager;
import de.teamlapen.vampirism.api.entity.player.task.Task;
import de.teamlapen.vampirism.api.entity.player.task.TaskRequirement;
import de.teamlapen.vampirism.api.entity.player.task.TaskUnlocker;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.inventory.container.TaskBoardContainer;
import de.teamlapen.vampirism.network.TaskStatusPacket;
import de.teamlapen.vampirism.player.tasks.req.ItemRequirement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.stats.Stats;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TaskManager
implements ITaskManager {
    @Nonnull
    private static final Logger LOGGER = LogManager.getLogger();
    @Nonnull
    private static final UUID UNIQUE_TASKS = UUID.fromString("e2c6068a-8f0e-4d5b-822a-38ad6ecf98c9");
    @Nonnull
    private final IPlayableFaction<?> faction;
    @Nonnull
    private final ServerPlayerEntity player;
    @Nonnull
    private final IFactionPlayer<?> factionPlayer;
    @Nonnull
    private final Set<Task> completedTasks = new HashSet<Task>();
    @Nonnull
    private final Map<UUID, Set<Task>> tasks = new HashMap<UUID, Set<Task>>();
    @Nonnull
    private final Map<UUID, Integer> lessTasks = new HashMap<UUID, Integer>();
    @Nonnull
    private final Map<UUID, Integer> taskAmount = new HashMap<UUID, Integer>();
    @Nonnull
    private final Map<UUID, Set<Task>> acceptedTasks = new HashMap<UUID, Set<Task>>();
    @Nonnull
    private final Map<UUID, Map<Task, Map<ResourceLocation, Integer>>> stats = Maps.newHashMap();

    public TaskManager(@Nonnull IFactionPlayer<?> factionPlayer, @Nonnull IPlayableFaction<?> faction) {
        this.faction = faction;
        this.player = (ServerPlayerEntity)factionPlayer.getRepresentingPlayer();
        this.factionPlayer = factionPlayer;
    }

    @Override
    public void completeTask(UUID taskBoardId, @Nonnull Task task) {
        UUID tmpId;
        UUID uUID = tmpId = task.isUnique() ? UNIQUE_TASKS : taskBoardId;
        if (!this.canCompleteTask(taskBoardId, task)) {
            return;
        }
        if (task.getRequirement().isHasStatBasedReq()) {
            this.stats.get(tmpId).remove((Object)task);
        }
        this.acceptedTasks.get(tmpId).remove((Object)task);
        this.completedTasks.add(task);
        this.tasks.get(tmpId).remove((Object)task);
        if (!task.isUnique()) {
            this.lessTasks.compute(taskBoardId, (id, value) -> value == null ? 1 : value + 1);
        }
        this.removeRequirements(task);
        this.applyRewards(task);
        this.updateTaskMasterScreen(taskBoardId);
    }

    @Override
    public void acceptTask(UUID taskBoardId, @Nonnull Task task) {
        this.acceptedTasks.compute(task.isUnique() ? UNIQUE_TASKS : taskBoardId, (id, tasks) -> {
            if (tasks == null) {
                return Sets.newHashSet((Object[])new Task[]{task});
            }
            tasks.add(task);
            return tasks;
        });
        this.updateTaskMasterScreen(taskBoardId);
    }

    @Override
    public void abortTask(UUID taskBoardId, @Nonnull Task task) {
        this.acceptedTasks.compute(task.isUnique() ? UNIQUE_TASKS : taskBoardId, (id, tasks) -> {
            if (tasks != null) {
                tasks.remove((Object)task);
                this.stats.computeIfPresent(task.isUnique() ? UNIQUE_TASKS : taskBoardId, (entityId1, tasks1) -> {
                    tasks1.remove((Object)task);
                    return tasks1;
                });
            }
            return tasks;
        });
        this.updateTaskMasterScreen(taskBoardId);
    }

    @Override
    public void openTaskMasterScreen(UUID taskBoardId) {
        HashSet<Task> selectedTasks = new HashSet<Task>(this.getTasks(taskBoardId));
        selectedTasks.addAll(this.getUniqueTasks());
        this.updateClient(taskBoardId, this.getCompletedRequirements(taskBoardId, selectedTasks), this.reduceToCompletableTasks(taskBoardId, selectedTasks), this.reduceToNotAcceptedTasks(taskBoardId, selectedTasks), selectedTasks);
    }

    @Override
    public void updateTaskMasterScreen(UUID taskBoardId) {
        HashSet<Task> selectedTasks = new HashSet<Task>(this.getTasks(taskBoardId));
        selectedTasks.addAll(this.getUniqueTasks());
        this.updateClient(taskBoardId, this.getCompletedRequirements(taskBoardId, selectedTasks), this.reduceToCompletableTasks(taskBoardId, selectedTasks), this.reduceToNotAcceptedTasks(taskBoardId, selectedTasks), selectedTasks);
    }

    @Override
    public boolean hasAvailableTasks(UUID taskBoardId) {
        return !this.getTasks(taskBoardId).isEmpty() || !this.getUniqueTasks().isEmpty();
    }

    private void updateClient(UUID taskBoardId, @Nonnull Map<Task, Map<ResourceLocation, Integer>> requirements, @Nonnull Set<Task> completable, @Nonnull Set<Task> notAcceptedTasks, @Nonnull Set<Task> available) {
        if (this.player.field_71070_bA instanceof TaskBoardContainer) {
            VampirismMod.dispatcher.sendTo(new TaskStatusPacket(completable, available, notAcceptedTasks, requirements, this.player.field_71070_bA.field_75152_c, taskBoardId), this.player);
        }
    }

    @Override
    public void resetUniqueTask(Task task) {
        if (!task.isUnique()) {
            return;
        }
        this.completedTasks.remove((Object)task);
        this.stats.computeIfPresent(UNIQUE_TASKS, (k, m) -> {
            m.remove((Object)task);
            return m;
        });
        this.acceptedTasks.computeIfPresent(UNIQUE_TASKS, (k, s) -> {
            s.remove((Object)task);
            return s;
        });
    }

    private boolean matchesFaction(@Nonnull Task task) {
        return task.getFaction() == this.faction || task.getFaction() == null;
    }

    public boolean isTaskUnlocked(@Nonnull Task task) {
        if (!this.matchesFaction(task)) {
            return false;
        }
        for (TaskUnlocker taskUnlocker : task.getUnlocker()) {
            if (taskUnlocker.isUnlocked(this.factionPlayer)) continue;
            return false;
        }
        return true;
    }

    public boolean canCompleteTask(UUID taskBoardId, @Nonnull Task task) {
        if (!this.isTaskUnlocked(task)) {
            return false;
        }
        for (TaskRequirement.Requirement<?> requirement : task.getRequirement().getAll()) {
            if (this.checkStat(taskBoardId, task, requirement)) continue;
            return false;
        }
        return true;
    }

    private boolean isTaskNotAccepted(UUID taskBoardId, @Nonnull Task task) {
        return !this.acceptedTasks.getOrDefault(task.isUnique() ? UNIQUE_TASKS : taskBoardId, Collections.emptySet()).contains((Object)task);
    }

    @Override
    public boolean isTaskCompleted(@Nonnull Task task) {
        return this.completedTasks.contains((Object)task);
    }

    public void removeRequirements(@Nonnull Task task) {
        task.getRequirement().removeRequirement(this.factionPlayer);
    }

    public void applyRewards(@Nonnull Task task) {
        task.getReward().applyReward(this.factionPlayer);
    }

    @Override
    public void reset() {
        this.completedTasks.clear();
        this.stats.clear();
        this.tasks.clear();
        this.completedTasks.clear();
        this.acceptedTasks.clear();
        this.lessTasks.clear();
    }

    public void tick() {
        if (this.player.func_130014_f_().func_82737_E() % 24000L == 0L) {
            this.updateTaskLists();
        }
    }

    @Override
    public void updateTaskLists() {
        for (Map.Entry<UUID, Set<Task>> entrySet : this.tasks.entrySet()) {
            if (entrySet.getKey() == UNIQUE_TASKS) continue;
            Set<Task> accepted = this.acceptedTasks.get(entrySet.getKey());
            if (accepted == null || accepted.isEmpty()) {
                this.tasks.get(entrySet.getKey()).clear();
                continue;
            }
            entrySet.getValue().removeIf(task -> !accepted.contains(task));
        }
    }

    @Override
    public void resetTaskLists() {
        this.acceptedTasks.clear();
        this.lessTasks.clear();
        this.taskAmount.clear();
        this.updateTaskLists();
    }

    private Set<Task> getTasks(UUID taskBoardId) {
        Set selectedTasks = this.tasks.getOrDefault(taskBoardId, new HashSet());
        if (!selectedTasks.isEmpty()) {
            this.removeLockedTasks(taskBoardId, selectedTasks);
        }
        int neededTaskAmount = this.taskAmount.getOrDefault(taskBoardId, this.player.func_70681_au().nextInt((Integer)VampirismConfig.BALANCE.taskMasterMaxTaskAmount.get()) + 1) - this.lessTasks.getOrDefault(taskBoardId, 0);
        if (selectedTasks.size() < neededTaskAmount) {
            ArrayList tasks = new ArrayList(ModRegistries.TASKS.getValues());
            Collections.shuffle(tasks);
            selectedTasks.addAll(tasks.stream().filter(this::matchesFaction).filter(task -> !task.isUnique()).filter(this::isTaskUnlocked).limit(neededTaskAmount - selectedTasks.size()).collect(Collectors.toList()));
        }
        this.tasks.put(taskBoardId, selectedTasks);
        this.updateStats(taskBoardId, selectedTasks);
        return selectedTasks;
    }

    private Set<Task> getUniqueTasks() {
        Set uniqueTasks = this.tasks.getOrDefault(UNIQUE_TASKS, new HashSet());
        if (!uniqueTasks.isEmpty()) {
            this.removeLockedTasks(UNIQUE_TASKS, uniqueTasks);
        }
        uniqueTasks.addAll(ModRegistries.TASKS.getValues().stream().filter(this::matchesFaction).filter(Task::isUnique).filter(task -> !this.completedTasks.contains(task)).filter(this::isTaskUnlocked).collect(Collectors.toSet()));
        this.tasks.put(UNIQUE_TASKS, uniqueTasks);
        this.updateStats(UNIQUE_TASKS, uniqueTasks);
        return uniqueTasks;
    }

    private Set<Task> reduceToCompletableTasks(UUID taskBoardId, @Nonnull Set<Task> tasks) {
        Set<Task> completable = tasks.stream().filter(task -> this.canCompleteTask(taskBoardId, (Task)((Object)task))).collect(Collectors.toSet());
        tasks.removeAll(completable);
        return completable;
    }

    private Set<Task> reduceToNotAcceptedTasks(UUID taskBoardId, @Nonnull Set<Task> tasks) {
        Set<Task> notAccepted = tasks.stream().filter(task -> this.isTaskNotAccepted(taskBoardId, (Task)((Object)task))).collect(Collectors.toSet());
        tasks.removeAll(notAccepted);
        return notAccepted;
    }

    @Nonnull
    public Map<Task, Map<ResourceLocation, Integer>> getCompletedRequirements(UUID taskBoardId, @Nonnull Set<Task> tasks) {
        HashMap completedRequirements = Maps.newHashMap();
        tasks.forEach(task -> {
            Map<ResourceLocation, Integer> completed = this.getCompletedRequirements(taskBoardId, (Task)((Object)task));
            if (!completed.isEmpty()) {
                completedRequirements.put(task, completed);
            }
        });
        return completedRequirements;
    }

    private Map<ResourceLocation, Integer> getCompletedRequirements(UUID taskBoardId, @Nonnull Task task) {
        HashMap completed = Maps.newHashMap();
        for (TaskRequirement.Requirement<?> requirement : task.getRequirement().getAll()) {
            completed.put(requirement.getId(), this.getStat(taskBoardId, task, requirement));
        }
        return completed;
    }

    private void removeLockedTasks(UUID taskBoardId, @Nonnull Collection<Task> tasks) {
        tasks.removeIf(task -> {
            if (!this.isTaskUnlocked((Task)((Object)task))) {
                this.stats.getOrDefault(taskBoardId, Collections.emptyMap()).remove(task);
                return true;
            }
            return false;
        });
    }

    private boolean checkStat(UUID taskBoardId, @Nonnull Task task, @Nonnull TaskRequirement.Requirement<?> requirement) {
        return this.getStat(taskBoardId, task, requirement) >= requirement.getAmount(this.factionPlayer);
    }

    private int getStat(UUID taskBoardId, @Nonnull Task task, @Nonnull TaskRequirement.Requirement<?> requirement) {
        if (task.isUnique()) {
            taskBoardId = UNIQUE_TASKS;
        }
        if (this.isTaskNotAccepted(taskBoardId, task)) {
            return 0;
        }
        int neededStat = 0;
        int actualStat = 0;
        switch (requirement.getType()) {
            case STATS: {
                actualStat = this.player.func_147099_x().func_77444_a(Stats.field_199092_j.func_199076_b((Object)((ResourceLocation)requirement.getStat(this.factionPlayer))));
                neededStat = this.stats.get(taskBoardId).get((Object)task).get(requirement.getId()) + requirement.getAmount(this.factionPlayer);
                break;
            }
            case ENTITY: {
                actualStat = this.player.func_147099_x().func_77444_a(Stats.field_199090_h.func_199076_b((Object)((EntityType)requirement.getStat(this.factionPlayer))));
                neededStat = this.stats.get(taskBoardId).get((Object)task).get(requirement.getId()) + requirement.getAmount(this.factionPlayer);
                break;
            }
            case ENTITY_TAG: {
                for (EntityType type : ((Tag)requirement.getStat(this.factionPlayer)).func_199885_a()) {
                    actualStat += this.player.func_147099_x().func_77444_a(Stats.field_199090_h.func_199076_b((Object)type));
                }
                neededStat = this.stats.get(taskBoardId).get((Object)task).get(requirement.getId()) + requirement.getAmount(this.factionPlayer);
                break;
            }
            case ITEMS: {
                ItemStack stack = ((ItemRequirement)requirement).getItemStack();
                neededStat = stack.func_190916_E();
                actualStat = this.player.field_71071_by.func_213901_a(stack.func_77973_b());
                break;
            }
            case BOOLEAN: {
                if (!((Boolean)requirement.getStat(this.factionPlayer)).booleanValue()) {
                    return 0;
                }
                return 1;
            }
        }
        return Math.min(requirement.getAmount(this.factionPlayer) - (neededStat - actualStat), requirement.getAmount(this.factionPlayer));
    }

    private void updateStats(UUID taskBoardId, @Nonnull Collection<Task> tasks) {
        tasks.forEach(task -> this.updateStats(taskBoardId, (Task)((Object)task)));
    }

    private void updateStats(UUID taskBoardId, @Nonnull Task task) {
        if (this.isTaskNotAccepted(taskBoardId, task)) {
            return;
        }
        if (!task.getRequirement().isHasStatBasedReq()) {
            return;
        }
        Map taskStats = this.stats.getOrDefault(task.isUnique() ? UNIQUE_TASKS : taskBoardId, new HashMap());
        Map reqStats = taskStats.getOrDefault((Object)task, new HashMap());
        for (TaskRequirement.Requirement<?> requirement : task.getRequirement().getAll()) {
            switch (requirement.getType()) {
                case STATS: {
                    reqStats.putIfAbsent(requirement.getId(), this.player.func_147099_x().func_77444_a(Stats.field_199092_j.func_199076_b((Object)((ResourceLocation)requirement.getStat(this.factionPlayer)))));
                    break;
                }
                case ENTITY: {
                    reqStats.putIfAbsent(requirement.getId(), this.player.func_147099_x().func_77444_a(Stats.field_199090_h.func_199076_b((Object)((EntityType)requirement.getStat(this.factionPlayer)))));
                    break;
                }
                case ENTITY_TAG: {
                    int amount = 0;
                    for (EntityType type : ((Tag)requirement.getStat(this.factionPlayer)).func_199885_a()) {
                        amount += this.player.func_147099_x().func_77444_a(Stats.field_199090_h.func_199076_b((Object)type));
                    }
                    reqStats.putIfAbsent(requirement.getId(), amount);
                    break;
                }
            }
        }
        taskStats.put(task, reqStats);
        this.stats.put(task.isUnique() ? UNIQUE_TASKS : taskBoardId, taskStats);
    }

    public void writeNBT(@Nonnull CompoundNBT compoundNBT) {
        CompoundNBT tasksNBT;
        if (!this.completedTasks.isEmpty()) {
            tasksNBT = new CompoundNBT();
            this.completedTasks.forEach(task -> tasksNBT.func_74757_a(Objects.requireNonNull(task.getRegistryName()).toString(), true));
            compoundNBT.func_218657_a("completedTasks", (INBT)tasksNBT);
        }
        if (!this.tasks.isEmpty()) {
            tasksNBT = new CompoundNBT();
            this.tasks.forEach((entityId, tasks) -> {
                CompoundNBT entityIdNBT = new CompoundNBT();
                tasks.forEach(task -> entityIdNBT.func_74757_a(Objects.requireNonNull(task.getRegistryName()).toString(), true));
                tasksNBT.func_218657_a(entityId.toString(), (INBT)entityIdNBT);
            });
            compoundNBT.func_218657_a("tasks", (INBT)tasksNBT);
        }
        if (!this.lessTasks.isEmpty()) {
            tasksNBT = new CompoundNBT();
            this.lessTasks.forEach((entityId, tasks) -> tasksNBT.func_74768_a(entityId.toString(), tasks.intValue()));
            compoundNBT.func_218657_a("lessTasks", (INBT)tasksNBT);
        }
        if (!this.acceptedTasks.isEmpty()) {
            tasksNBT = new CompoundNBT();
            this.acceptedTasks.forEach((entityId, tasks) -> {
                CompoundNBT entityIdNBT = new CompoundNBT();
                tasks.forEach(task -> entityIdNBT.func_74757_a(Objects.requireNonNull(task.getRegistryName()).toString(), true));
                tasksNBT.func_218657_a(entityId.toString(), (INBT)entityIdNBT);
            });
            compoundNBT.func_218657_a("acceptedTasks", (INBT)tasksNBT);
        }
        if (!this.stats.isEmpty()) {
            CompoundNBT stats = new CompoundNBT();
            for (Map.Entry<UUID, Map<Task, Map<ResourceLocation, Integer>>> taskBoardEntries : this.stats.entrySet()) {
                CompoundNBT board = new CompoundNBT();
                for (Map.Entry<Task, Map<ResourceLocation, Integer>> taskEntries : taskBoardEntries.getValue().entrySet()) {
                    CompoundNBT task2 = new CompoundNBT();
                    for (Map.Entry<ResourceLocation, Integer> requirementEntries : taskEntries.getValue().entrySet()) {
                        task2.func_74768_a(requirementEntries.getKey().toString(), requirementEntries.getValue().intValue());
                    }
                    board.func_218657_a(taskEntries.getKey().getRegistryName().toString(), (INBT)task2);
                }
                stats.func_218657_a(taskBoardEntries.getKey().toString(), (INBT)board);
            }
            compoundNBT.func_218657_a("stats", (INBT)stats);
        }
    }

    public void readNBT(@Nonnull CompoundNBT compoundNBT) {
        if (compoundNBT.func_74764_b("completedTasks")) {
            compoundNBT.func_74775_l("completedTasks").func_150296_c().forEach(taskId -> {
                Task task = (Task)ModRegistries.TASKS.getValue(new ResourceLocation(taskId));
                if (task != null) {
                    this.completedTasks.add(task);
                }
            });
        }
        if (compoundNBT.func_74764_b("tasks")) {
            compoundNBT.func_74775_l("tasks").func_150296_c().forEach(taskBoardId -> {
                CompoundNBT entityIdNBT = compoundNBT.func_74775_l("tasks").func_74775_l(taskBoardId);
                HashSet tasks = new HashSet();
                entityIdNBT.func_150296_c().forEach(taskId -> {
                    Task task = (Task)ModRegistries.TASKS.getValue(new ResourceLocation(taskId));
                    if (task != null) {
                        tasks.add(task);
                    }
                });
                this.tasks.put(UUID.fromString(taskBoardId), tasks);
            });
        }
        if (compoundNBT.func_74764_b("lessTasks")) {
            CompoundNBT lessTasksNBT = compoundNBT.func_74775_l("lessTasks");
            lessTasksNBT.func_150296_c().forEach(taskBoardId -> this.lessTasks.put(UUID.fromString(taskBoardId), lessTasksNBT.func_74762_e(taskBoardId)));
        }
        if (compoundNBT.func_74764_b("acceptedTasks")) {
            compoundNBT.func_74775_l("acceptedTasks").func_150296_c().forEach(taskBoardId -> {
                CompoundNBT entityIdNBT = compoundNBT.func_74775_l("acceptedTasks").func_74775_l(taskBoardId);
                HashSet tasks = new HashSet();
                entityIdNBT.func_150296_c().forEach(taskId -> {
                    Task task = (Task)ModRegistries.TASKS.getValue(new ResourceLocation(taskId));
                    if (task != null) {
                        tasks.add(task);
                    }
                });
                this.acceptedTasks.put(UUID.fromString(taskBoardId), tasks);
            });
        }
        if (compoundNBT.func_74764_b("stats")) {
            CompoundNBT stats = compoundNBT.func_74775_l("stats");
            for (String taskBoardId2 : stats.func_150296_c()) {
                CompoundNBT taskBoardNBT = stats.func_74775_l(taskBoardId2);
                HashMap tasks = new HashMap();
                for (String taskRegistryName : taskBoardNBT.func_150296_c()) {
                    CompoundNBT taskNBT = taskBoardNBT.func_74775_l(taskRegistryName);
                    HashMap<ResourceLocation, Integer> requirements = new HashMap<ResourceLocation, Integer>();
                    for (String requirementString : taskNBT.func_150296_c()) {
                        requirements.put(new ResourceLocation(requirementString), taskNBT.func_74762_e(requirementString));
                    }
                    tasks.put(ModRegistries.TASKS.getValue(new ResourceLocation(taskRegistryName)), requirements);
                }
                this.stats.put(UUID.fromString(taskBoardId2), tasks);
            }
        }
    }
}

