/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.hunter;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.player.actions.IActionHandler;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.items.ObsidianArmorItem;
import de.teamlapen.vampirism.player.LevelAttributeModifier;
import de.teamlapen.vampirism.player.VampirismPlayer;
import de.teamlapen.vampirism.player.actions.ActionHandler;
import de.teamlapen.vampirism.player.hunter.HunterPlayerDefaultImpl;
import de.teamlapen.vampirism.player.hunter.HunterPlayerSpecialAttribute;
import de.teamlapen.vampirism.player.skills.SkillHandler;
import de.teamlapen.vampirism.util.REFERENCE;
import de.teamlapen.vampirism.util.ScoreboardUtil;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HunterPlayer
extends VampirismPlayer<IHunterPlayer>
implements IHunterPlayer {
    private static final Logger LOGGER = LogManager.getLogger(HunterPlayer.class);
    @CapabilityInject(value=IHunterPlayer.class)
    public static Capability<IHunterPlayer> CAP = (Capability)UtilLib.getNull();
    private final ActionHandler<IHunterPlayer> actionHandler = new ActionHandler<HunterPlayer>(this);
    private final SkillHandler<IHunterPlayer> skillHandler = new SkillHandler<IHunterPlayer>(this, VReference.HUNTER_FACTION);
    private final HunterPlayerSpecialAttribute specialAttributes = new HunterPlayerSpecialAttribute();

    public static HunterPlayer get(@Nonnull PlayerEntity player) {
        return (HunterPlayer)player.getCapability(CAP, null).orElseThrow(() -> new IllegalStateException("Cannot get HunterPlayer from player " + player));
    }

    public static LazyOptional<HunterPlayer> getOpt(@Nonnull PlayerEntity player) {
        LazyOptional opt = player.getCapability(CAP, null).cast();
        if (!opt.isPresent()) {
            LOGGER.warn("Cannot get Hunter player capability. This might break mod functionality.", new Throwable().fillInStackTrace());
        }
        return opt;
    }

    public static void registerCapability() {
        CapabilityManager.INSTANCE.register(IHunterPlayer.class, (Capability.IStorage)new Storage(), HunterPlayerDefaultImpl::new);
    }

    public static ICapabilityProvider createNewCapability(final PlayerEntity player) {
        return new ICapabilitySerializable<CompoundNBT>(){
            final IHunterPlayer inst;
            final LazyOptional<IHunterPlayer> opt;
            {
                this.inst = new HunterPlayer(player);
                this.opt = LazyOptional.of(() -> this.inst);
            }

            public void deserializeNBT(CompoundNBT nbt) {
                CAP.getStorage().readNBT(CAP, (Object)this.inst, null, (INBT)nbt);
            }

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
                return CAP.orEmpty(capability, this.opt);
            }

            public CompoundNBT serializeNBT() {
                return (CompoundNBT)CAP.getStorage().writeNBT(CAP, (Object)this.inst, null);
            }
        };
    }

    public HunterPlayer(PlayerEntity player) {
        super(player);
    }

    @Override
    public boolean canLeaveFaction() {
        return true;
    }

    @Override
    public IActionHandler<IHunterPlayer> getActionHandler() {
        return this.actionHandler;
    }

    @Override
    public ResourceLocation getCapKey() {
        return REFERENCE.HUNTER_PLAYER_KEY;
    }

    @Override
    public IFaction getDisguisedAs() {
        return this.player.func_70644_a(ModEffects.disguise_as_vampire) ? VReference.VAMPIRE_FACTION : this.getFaction();
    }

    @Override
    public int getMaxLevel() {
        return 14;
    }

    @Override
    public Predicate<LivingEntity> getNonFriendlySelector(boolean otherFactionPlayers, boolean ignoreDisguise) {
        if (otherFactionPlayers) {
            return entity -> true;
        }
        return VampirismAPI.factionRegistry().getPredicate(this.getFaction(), ignoreDisguise);
    }

    @Override
    @Nonnull
    public ISkillHandler<IHunterPlayer> getSkillHandler() {
        return this.skillHandler;
    }

    @Nonnull
    public HunterPlayerSpecialAttribute getSpecialAttributes() {
        return this.specialAttributes;
    }

    @Override
    public int getTheEntityID() {
        return this.player.func_145782_y();
    }

    @Override
    public boolean isDisguised() {
        return this.player.func_70644_a(ModEffects.disguise_as_vampire);
    }

    @Override
    public void loadData(CompoundNBT compound) {
        super.loadData(compound);
        this.actionHandler.loadFromNbt(compound);
        this.skillHandler.loadFromNbt(compound);
    }

    @Override
    public void onChangedDimension(DimensionType from, DimensionType to) {
    }

    @Override
    public void onDeath(DamageSource src) {
        this.actionHandler.deactivateAllActions();
    }

    @Override
    public boolean onEntityAttacked(DamageSource src, float amt) {
        if (DamageSource.field_76370_b.equals(src) || DamageSource.field_76372_a.equals(src)) {
            return ObsidianArmorItem.isFullyEquipped(this.player);
        }
        return false;
    }

    @Override
    public void onJoinWorld() {
        if (this.getLevel() > 0) {
            this.actionHandler.onActionsReactivated();
        }
    }

    @Override
    public void onLevelChanged(int level, int oldLevel) {
        if (!this.isRemote()) {
            ScoreboardUtil.updateScoreboard(this.player, ScoreboardUtil.HUNTER_LEVEL_CRITERIA, level);
            LevelAttributeModifier.applyModifier(this.player, SharedMonsterAttributes.field_111264_e, "Hunter", this.getLevel(), this.getMaxLevel(), (Double)VampirismConfig.BALANCE.hpStrengthMaxMod.get(), (Double)VampirismConfig.BALANCE.hpStrengthType.get(), AttributeModifier.Operation.MULTIPLY_TOTAL, false);
            if (level > 0) {
                if (oldLevel == 0) {
                    this.skillHandler.enableRootSkill();
                }
            } else {
                this.skillHandler.disableAllSkills();
                this.actionHandler.resetTimers();
            }
        } else if (level == 0) {
            this.actionHandler.resetTimers();
        }
    }

    @Override
    public void onPlayerLoggedIn() {
    }

    @Override
    public void onPlayerLoggedOut() {
    }

    @Override
    public void onUpdate() {
        this.player.func_130014_f_().func_217381_Z().func_76320_a("vampirism_hunterPlayer");
        super.onUpdate();
        int level = this.getLevel();
        if (!this.isRemote()) {
            if (level > 0) {
                boolean sync = false;
                boolean syncToAll = false;
                CompoundNBT syncPacket = new CompoundNBT();
                if (this.actionHandler.updateActions()) {
                    sync = true;
                    syncToAll = true;
                    this.actionHandler.writeUpdateForClient(syncPacket);
                }
                if (this.skillHandler.isDirty()) {
                    sync = true;
                    this.skillHandler.writeUpdateForClient(syncPacket);
                }
                if (sync) {
                    this.sync(syncPacket, syncToAll);
                }
            }
        } else {
            if (level > 0) {
                this.actionHandler.updateActions();
            }
            VampirismMod.proxy.handleSleepClient(this.player);
        }
        this.player.func_130014_f_().func_217381_Z().func_76319_b();
    }

    @Override
    public void onUpdatePlayer(TickEvent.Phase phase) {
    }

    @Override
    public void saveData(CompoundNBT compound) {
        super.saveData(compound);
        this.actionHandler.saveToNbt(compound);
        this.skillHandler.saveToNbt(compound);
    }

    @Override
    protected VampirismPlayer copyFromPlayer(PlayerEntity old) {
        HunterPlayer oldHunter = HunterPlayer.get(old);
        CompoundNBT nbt = new CompoundNBT();
        oldHunter.saveData(nbt);
        this.loadData(nbt);
        return oldHunter;
    }

    @Override
    protected void loadUpdate(CompoundNBT nbt) {
        super.loadUpdate(nbt);
        this.actionHandler.readUpdateFromServer(nbt);
        this.skillHandler.readUpdateFromServer(nbt);
    }

    @Override
    protected void writeFullUpdate(CompoundNBT nbt) {
        super.writeFullUpdate(nbt);
        this.actionHandler.writeUpdateForClient(nbt);
        this.skillHandler.writeUpdateForClient(nbt);
    }

    private static class Storage
    implements Capability.IStorage<IHunterPlayer> {
        private Storage() {
        }

        public void readNBT(Capability<IHunterPlayer> capability, IHunterPlayer instance, Direction side, INBT nbt) {
            ((HunterPlayer)instance).loadData((CompoundNBT)nbt);
        }

        public INBT writeNBT(Capability<IHunterPlayer> capability, IHunterPlayer instance, Direction side) {
            CompoundNBT nbt = new CompoundNBT();
            ((HunterPlayer)instance).saveData(nbt);
            return nbt;
        }
    }
}

