/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.skills;

import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.DefaultSkill;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class VampirismSkill<T extends IFactionPlayer>
extends DefaultSkill<T> {
    private Supplier<ITextComponent> description = () -> null;
    private Consumer<T> activate;
    private Consumer<T> deactivate;
    private String translationKey;

    @Deprecated
    public VampirismSkill(IPlayableFaction<T> faction) {
        super(faction);
        this.activate = player -> {};
        this.deactivate = player -> {};
        this.translationKey = null;
    }

    public VampirismSkill() {
        this.activate = player -> {};
        this.deactivate = player -> {};
        this.translationKey = null;
    }

    @Override
    public ITextComponent getDescription() {
        return this.description.get();
    }

    public VampirismSkill<T> setDescription(Supplier<ITextComponent> descriptionIn) {
        this.description = descriptionIn;
        return this;
    }

    @Override
    public String getTranslationKey() {
        return this.translationKey == null ? super.getTranslationKey() : this.translationKey;
    }

    public VampirismSkill<T> setTranslationKey(String translationKeyIn) {
        this.translationKey = translationKeyIn;
        return this;
    }

    public VampirismSkill<T> setHasDefaultDescription() {
        this.description = () -> new TranslationTextComponent(this.getTranslationKey() + ".desc", new Object[0]);
        return this;
    }

    public VampirismSkill<T> setToggleActions(Consumer<T> activateIn, Consumer<T> deactivateIn) {
        this.activate = activateIn;
        this.deactivate = deactivateIn;
        return this;
    }

    @Override
    protected void onDisabled(T player) {
        this.deactivate.accept(player);
        super.onDisabled(player);
    }

    @Override
    protected void onEnabled(T player) {
        this.activate.accept(player);
        super.onEnabled(player);
    }

    public static class SimpleVampireSkill
    extends VampirismSkill<IVampirePlayer> {
        @Deprecated
        public SimpleVampireSkill(String id, boolean desc) {
            this(new ResourceLocation("vampirism", id), desc);
        }

        public SimpleVampireSkill(ResourceLocation id, boolean desc) {
            this.setRegistryName(id);
            if (desc) {
                this.setHasDefaultDescription();
            }
        }

        @Override
        @Nonnull
        public IPlayableFaction getFaction() {
            return VReference.VAMPIRE_FACTION;
        }
    }

    public static class SimpleHunterSkill
    extends VampirismSkill<IHunterPlayer> {
        public SimpleHunterSkill(ResourceLocation id, boolean desc) {
            this.setRegistryName(id);
            if (desc) {
                this.setHasDefaultDescription();
            }
        }

        @Deprecated
        public SimpleHunterSkill(String id, boolean desc) {
            this(new ResourceLocation("vampirism", id), desc);
        }

        @Override
        @Nonnull
        public IPlayableFaction getFaction() {
            return VReference.HUNTER_FACTION;
        }
    }
}

