/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.vampire;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.advancements.VampireActionTrigger;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.IBiteableEntity;
import de.teamlapen.vampirism.api.entity.IExtendedCreatureVampirism;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IActionHandler;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.api.entity.player.vampire.IBloodStats;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampireVision;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModAdvancements;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.entity.DamageHandler;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.fluids.BloodHelper;
import de.teamlapen.vampirism.items.HunterCoatItem;
import de.teamlapen.vampirism.network.InputEventPacket;
import de.teamlapen.vampirism.particle.FlyingBloodEntityParticleData;
import de.teamlapen.vampirism.player.LevelAttributeModifier;
import de.teamlapen.vampirism.player.VampirismPlayer;
import de.teamlapen.vampirism.player.actions.ActionHandler;
import de.teamlapen.vampirism.player.skills.SkillHandler;
import de.teamlapen.vampirism.player.vampire.BloodStats;
import de.teamlapen.vampirism.player.vampire.VampirePlayerDefaultImpl;
import de.teamlapen.vampirism.player.vampire.VampirePlayerSpecialAttributes;
import de.teamlapen.vampirism.player.vampire.actions.VampireActions;
import de.teamlapen.vampirism.potion.PotionSanguinare;
import de.teamlapen.vampirism.potion.VampireNightVisionEffect;
import de.teamlapen.vampirism.util.GeneralRegistryImpl;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.util.Permissions;
import de.teamlapen.vampirism.util.REFERENCE;
import de.teamlapen.vampirism.util.ScoreboardUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.server.permission.PermissionAPI;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VampirePlayer
extends VampirismPlayer<IVampirePlayer>
implements IVampirePlayer {
    private static final Logger LOGGER = LogManager.getLogger(VampirePlayer.class);
    private static final String KEY_EYE = "eye_type";
    private static final String KEY_FANGS = "fang_type";
    private static final String KEY_GLOWING_EYES = "glowing_eyes";
    private static final String KEY_SPAWN_BITE_PARTICLE = "bite_particle";
    private static final String KEY_VISION = "vision";
    private static final String KEY_VICTIM_ID = "feed_victim";
    private static final int FEED_TIMER = 20;
    @CapabilityInject(value=IVampirePlayer.class)
    public static Capability<IVampirePlayer> CAP = (Capability)UtilLib.getNull();
    private final BloodStats bloodStats;
    private final ActionHandler<IVampirePlayer> actionHandler;
    private final SkillHandler<IVampirePlayer> skillHandler;
    private final VampirePlayerSpecialAttributes specialAttributes = new VampirePlayerSpecialAttributes();
    private boolean sundamage_cache = false;
    private EnumStrength garlic_cache = EnumStrength.NONE;
    private int eyeType = 0;
    private int fangType = 0;
    private boolean glowingEyes = false;
    private int ticksInSun = 0;
    private boolean wasDead = false;
    private final List<IVampireVision> unlockedVisions = new ArrayList<IVampireVision>();
    private IVampireVision activatedVision = null;
    private int feed_victim = -1;
    private IVampirePlayer.BITE_TYPE feed_victim_bite_type;
    private int feedBiteTickCounter = 0;

    public static VampirePlayer get(@Nonnull PlayerEntity player) {
        return (VampirePlayer)player.getCapability(CAP, null).orElseThrow(() -> new IllegalStateException("Cannot get Vampire player capability from player " + player));
    }

    public static LazyOptional<VampirePlayer> getOpt(@Nonnull PlayerEntity player) {
        LazyOptional opt = player.getCapability(CAP, null).cast();
        if (!opt.isPresent()) {
            LOGGER.warn("Cannot get Vampire player capability. This might break mod functionality.", new Throwable().fillInStackTrace());
        }
        return opt;
    }

    public static void registerCapability() {
        CapabilityManager.INSTANCE.register(IVampirePlayer.class, (Capability.IStorage)new Storage(), VampirePlayerDefaultImpl::new);
    }

    public static ICapabilityProvider createNewCapability(final PlayerEntity player) {
        return new ICapabilitySerializable<CompoundNBT>(){
            final IVampirePlayer inst;
            final LazyOptional<IVampirePlayer> opt;
            {
                this.inst = new VampirePlayer(player);
                this.opt = LazyOptional.of(() -> this.inst);
            }

            public void deserializeNBT(CompoundNBT nbt) {
                CAP.getStorage().readNBT(CAP, (Object)this.inst, null, (INBT)nbt);
            }

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
                return CAP.orEmpty(capability, this.opt);
            }

            public CompoundNBT serializeNBT() {
                return (CompoundNBT)CAP.getStorage().writeNBT(CAP, (Object)this.inst, null);
            }
        };
    }

    public VampirePlayer(PlayerEntity player) {
        super(player);
        this.applyEntityAttributes();
        this.bloodStats = new BloodStats(player);
        this.actionHandler = new ActionHandler<VampirePlayer>(this);
        this.skillHandler = new SkillHandler<IVampirePlayer>(this, VReference.VAMPIRE_FACTION);
    }

    @Override
    public void activateVision(@Nullable IVampireVision vision) {
        if (vision != null && !this.isRemote() && ((GeneralRegistryImpl)VampirismAPI.vampireVisionRegistry()).getIdOfVision(vision) == -1) {
            throw new IllegalArgumentException("You have to register the vision first: " + vision);
        }
        if (!Objects.equals(this.activatedVision, vision)) {
            if (this.activatedVision != null) {
                this.activatedVision.onDeactivated(this);
            }
            this.activatedVision = vision;
            if (vision != null) {
                vision.onActivated(this);
            }
            if (!this.isRemote()) {
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_74768_a(KEY_VISION, this.activatedVision == null ? -1 : ((GeneralRegistryImpl)VampirismAPI.vampireVisionRegistry()).getIdOfVision(this.activatedVision));
                this.sync(nbt, false);
            }
        }
    }

    public void addExhaustion(float p_71020_1_) {
        if (!this.player.field_71075_bZ.field_75102_a && this.getLevel() > 0 && !this.isRemote()) {
            this.bloodStats.addExhaustion(p_71020_1_);
        }
    }

    public void biteBlock(BlockPos pos) {
        if (this.player.func_175149_v()) {
            LOGGER.warn("Player can't bite in spectator mode");
            return;
        }
        double dist = this.player.func_110148_a(PlayerEntity.REACH_DISTANCE).func_111126_e() + 1.0;
        if (this.player.func_70092_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) > dist * dist) {
            LOGGER.warn("Block sent by client is not in reach" + pos);
        } else {
            this.biteBlock(pos, this.player.field_70170_p.func_180495_p(pos), this.player.field_70170_p.func_175625_s(pos));
        }
    }

    public void biteEntity(int entityId) {
        if (this.getLevel() == 0) {
            LOGGER.warn("Player can't bite. Isn't a vampire");
            return;
        }
        Entity e = this.player.func_130014_f_().func_73045_a(entityId);
        if (this.player.func_175149_v()) {
            LOGGER.warn("Player can't bite in spectator mode");
            return;
        }
        if (this.getActionHandler().isActionActive(VampireActions.bat)) {
            LOGGER.warn("Cannot bite in bat mode");
            return;
        }
        if (e instanceof LivingEntity) {
            if ((double)e.func_70032_d((Entity)this.player) <= this.player.func_110148_a(PlayerEntity.REACH_DISTANCE).func_111126_e() + 1.0) {
                this.feed_victim_bite_type = this.determineBiteType((LivingEntity)e);
                if (this.feed_victim_bite_type == IVampirePlayer.BITE_TYPE.ATTACK || this.feed_victim_bite_type == IVampirePlayer.BITE_TYPE.ATTACK_HUNTER || this.feed_victim_bite_type == IVampirePlayer.BITE_TYPE.HUNTER_CREATURE) {
                    this.biteAttack((LivingEntity)e, this.feed_victim_bite_type == IVampirePlayer.BITE_TYPE.ATTACK_HUNTER);
                } else {
                    if (this.feed_victim_bite_type == IVampirePlayer.BITE_TYPE.NONE) {
                        return;
                    }
                    if (this.feed_victim == -1) {
                        this.feedBiteTickCounter = 0;
                    }
                    this.feed_victim = e.func_145782_y();
                    ((LivingEntity)e).func_195064_c(new EffectInstance(Effects.field_76421_d, 20, 7, false, false));
                    this.player.func_195064_c(new EffectInstance(Effects.field_76421_d, 25, 4, false, false));
                    CompoundNBT nbt = new CompoundNBT();
                    nbt.func_74768_a(KEY_VICTIM_ID, this.feed_victim);
                    this.sync(nbt, true);
                }
            } else {
                LOGGER.warn("Entity sent by client is not in reach " + entityId);
            }
        }
    }

    @Override
    public float calculateFireDamage(float amount) {
        float protectionMod = 1.0f;
        EffectInstance protection = this.player.func_70660_b(ModEffects.fire_protection);
        if (protection != null) {
            int amplifier = protection.func_76458_c();
            protectionMod = amplifier >= 5 ? 0.0f : 1.0f / (2.0f + (float)amplifier);
        }
        return amount * protectionMod * (float)LevelAttributeModifier.calculateModifierValue(this.getLevel(), this.getMaxLevel(), (Double)VampirismConfig.BALANCE.vpFireVulnerabilityMod.get(), 0.5);
    }

    @Override
    public boolean canBeBitten(IVampire biter) {
        return !this.player.func_175149_v() && !this.player.func_184812_l_();
    }

    @Override
    public boolean canLeaveFaction() {
        return true;
    }

    @Override
    public IVampirePlayer.BITE_TYPE determineBiteType(LivingEntity entity) {
        if (entity instanceof IBiteableEntity && ((IBiteableEntity)entity).canBeBitten(this)) {
            return IVampirePlayer.BITE_TYPE.SUCK_BLOOD;
        }
        if (entity instanceof CreatureEntity && entity.func_70089_S()) {
            LazyOptional<IExtendedCreatureVampirism> opt = ExtendedCreature.getSafe((Entity)entity);
            if (((Boolean)opt.map(creature -> creature.canBeBitten(this)).orElse((Object)false)).booleanValue()) {
                if (((Boolean)opt.map(IExtendedCreatureVampirism::hasPoisonousBlood).orElse((Object)false)).booleanValue()) {
                    return IVampirePlayer.BITE_TYPE.HUNTER_CREATURE;
                }
                return IVampirePlayer.BITE_TYPE.SUCK_BLOOD_CREATURE;
            }
        } else if (entity instanceof PlayerEntity) {
            if (((PlayerEntity)entity).field_71075_bZ.field_75098_d || !Permissions.isPvpEnabled(this.player)) {
                return IVampirePlayer.BITE_TYPE.NONE;
            }
            boolean hunter = Helper.isHunter(this.player);
            if (!UtilLib.canReallySee(entity, (LivingEntity)this.player, false) && ((Boolean)VampirePlayer.getOpt((PlayerEntity)entity).map(v -> v.canBeBitten(this)).orElse((Object)false)).booleanValue()) {
                return hunter ? IVampirePlayer.BITE_TYPE.SUCK_BLOOD_HUNTER_PLAYER : IVampirePlayer.BITE_TYPE.SUCK_BLOOD_PLAYER;
            }
            return hunter ? IVampirePlayer.BITE_TYPE.ATTACK_HUNTER : IVampirePlayer.BITE_TYPE.ATTACK;
        }
        return IVampirePlayer.BITE_TYPE.ATTACK;
    }

    @Override
    public boolean doesResistGarlic(EnumStrength strength) {
        return false;
    }

    @Override
    public void drinkBlood(int amt, float saturationMod, boolean useRemaining) {
        int left = this.bloodStats.addBlood(amt, saturationMod);
        if (useRemaining && left > 0) {
            this.handleSpareBlood(left);
        }
    }

    public void endFeeding(boolean sync) {
        if (this.feed_victim != -1) {
            this.feed_victim = -1;
        }
        this.feed_victim_bite_type = null;
        if (this.player.func_70644_a(Effects.field_76421_d)) {
            this.player.func_195063_d(Effects.field_76421_d);
        }
        if (sync) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74768_a(KEY_VICTIM_ID, this.feed_victim);
            this.sync(nbt, true);
        }
    }

    @Override
    public IActionHandler<IVampirePlayer> getActionHandler() {
        return this.actionHandler;
    }

    @Override
    @Nullable
    public IVampireVision getActiveVision() {
        return this.activatedVision;
    }

    @Override
    public int getBloodLevel() {
        return this.bloodStats.getBloodLevel();
    }

    @Override
    public float getBloodLevelRelative() {
        if (this.getLevel() == 0) {
            return (float)this.player.func_71024_bL().func_75116_a() / 20.0f;
        }
        return (float)this.bloodStats.getBloodLevel() / (float)this.bloodStats.getMaxBlood();
    }

    @Override
    public float getBloodSaturation() {
        return ((Double)VampirismConfig.BALANCE.vpPlayerBloodSaturation.get()).floatValue();
    }

    @Override
    public IBloodStats getBloodStats() {
        return this.bloodStats;
    }

    @Override
    public ResourceLocation getCapKey() {
        return REFERENCE.VAMPIRE_PLAYER_KEY;
    }

    @Override
    @Nullable
    public IFaction getDisguisedAs() {
        return this.isDisguised() ? this.specialAttributes.disguisedAs : this.getFaction();
    }

    public int getEyeType() {
        return this.eyeType;
    }

    public int getFangType() {
        return this.fangType;
    }

    public float getFeedProgress() {
        return (float)this.feedBiteTickCounter / 20.0f;
    }

    public boolean getGlowingEyes() {
        return this.glowingEyes;
    }

    public void setGlowingEyes(boolean value) {
        if (value != this.glowingEyes) {
            this.glowingEyes = value;
            if (!this.isRemote()) {
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_74757_a(KEY_GLOWING_EYES, this.glowingEyes);
                this.sync(nbt, true);
            }
        }
    }

    @Override
    public int getMaxLevel() {
        return 14;
    }

    @Override
    public Predicate<LivingEntity> getNonFriendlySelector(boolean otherFactionPlayers, boolean ignoreDisguise) {
        if (otherFactionPlayers) {
            return entity -> true;
        }
        return VampirismAPI.factionRegistry().getPredicate(this.getFaction(), ignoreDisguise);
    }

    @Override
    public ISkillHandler<IVampirePlayer> getSkillHandler() {
        return this.skillHandler;
    }

    @Nonnull
    public VampirePlayerSpecialAttributes getSpecialAttributes() {
        return this.specialAttributes;
    }

    @Override
    public int getTicksInSun() {
        return this.ticksInSun;
    }

    @Override
    public boolean isAdvancedBiter() {
        return this.specialAttributes.advanced_biter;
    }

    @Override
    public boolean isAutoFillEnabled() {
        return false;
    }

    @Override
    public boolean isDisguised() {
        return this.specialAttributes.disguised;
    }

    @Override
    @Nonnull
    public EnumStrength isGettingGarlicDamage(IWorld iWorld, boolean forcerefresh) {
        if (forcerefresh) {
            this.garlic_cache = Helper.getGarlicStrength((Entity)this.player, iWorld);
        }
        return this.garlic_cache;
    }

    @Override
    public boolean isGettingSundamage(IWorld iWorld, boolean forcerefresh) {
        if (forcerefresh) {
            this.sundamage_cache = Helper.gettingSundamge((LivingEntity)this.player, iWorld, this.player.field_70170_p.func_217381_Z()) && !((Object)((Object)ModItems.umbrella)).equals(this.player.func_184614_ca().func_77973_b());
        }
        return this.sundamage_cache;
    }

    @Override
    public boolean isIgnoringSundamage() {
        return false;
    }

    @Override
    public void loadData(CompoundNBT nbt) {
        super.loadData(nbt);
        this.bloodStats.readNBT(nbt);
        this.eyeType = nbt.func_74762_e(KEY_EYE);
        this.fangType = nbt.func_74762_e(KEY_FANGS);
        this.glowingEyes = nbt.func_74767_n(KEY_GLOWING_EYES);
        this.actionHandler.loadFromNbt(nbt);
        this.skillHandler.loadFromNbt(nbt);
    }

    @Override
    public int onBite(IVampire biter) {
        float perc;
        float f = perc = biter instanceof IVampirePlayer ? 0.2f : 0.08f;
        if (this.getLevel() == 0) {
            int amt = this.player.func_71024_bL().func_75116_a();
            int sucked = (int)Math.ceil((float)amt * perc);
            this.player.func_71024_bL().func_75114_a(amt - sucked);
            this.player.func_71020_j(1000.0f);
            if (!this.player.func_70644_a(ModEffects.sanguinare) && Helper.canTurnPlayer(biter, this.player) && Helper.canBecomeVampire(this.player) && !this.player.func_184812_l_()) {
                PotionSanguinare.addRandom((LivingEntity)this.player, true);
            }
            return sucked;
        }
        int amt = this.getBloodStats().getBloodLevel();
        int sucked = (int)Math.ceil((float)amt * perc);
        this.bloodStats.removeBlood(sucked, true);
        this.sync(this.bloodStats.writeUpdate(new CompoundNBT()), true);
        return sucked;
    }

    @Override
    public void onChangedDimension(DimensionType from, DimensionType to) {
    }

    @Override
    public void onDeath(DamageSource src) {
        if (this.actionHandler.isActionActive(VampireActions.bat) && src.func_76364_f() instanceof IProjectile && this.player instanceof ServerPlayerEntity) {
            ModAdvancements.TRIGGER_VAMPIRE_ACTION.trigger((ServerPlayerEntity)this.player, VampireActionTrigger.Action.SNIPED_IN_BAT);
        }
        this.actionHandler.deactivateAllActions();
        this.wasDead = true;
    }

    @Override
    public boolean onEntityAttacked(DamageSource src, float amt) {
        if (this.getLevel() > 0) {
            if (DamageSource.field_76370_b.equals(src)) {
                this.player.func_70097_a(VReference.VAMPIRE_ON_FIRE, this.calculateFireDamage(amt));
                return true;
            }
            if (DamageSource.field_76372_a.equals(src) || DamageSource.field_76371_c.equals(src)) {
                this.player.func_70097_a(VReference.VAMPIRE_IN_FIRE, this.calculateFireDamage(amt));
                return true;
            }
        }
        if (this.getSpecialAttributes().half_invulnerable && (double)amt >= (double)this.getRepresentingEntity().func_110138_aP() * (Double)VampirismConfig.BALANCE.vaHalfInvulnerableThreshold.get() && amt < 999.0f) {
            if (this.useBlood((Integer)VampirismConfig.BALANCE.vaHalfInvulnerableBloodCost.get(), false)) {
                return true;
            }
            this.actionHandler.toggleAction(VampireActions.half_invulnerable);
        }
        this.endFeeding(true);
        return false;
    }

    @Override
    public void onJoinWorld() {
        if (this.getLevel() > 0) {
            this.actionHandler.onActionsReactivated();
            this.ticksInSun = 0;
            if (this.wasDead) {
                this.player.func_195064_c(new EffectInstance(ModEffects.sunscreen, 400, 4, true, false));
                this.player.func_70606_j(this.player.func_110138_aP());
                this.bloodStats.setBloodLevel(this.bloodStats.getMaxBlood());
            }
        }
    }

    @Override
    public void onLevelChanged(int newLevel, int oldLevel) {
        if (!this.isRemote()) {
            ScoreboardUtil.updateScoreboard(this.player, ScoreboardUtil.VAMPIRE_LEVEL_CRITERIA, newLevel);
            LevelAttributeModifier.applyModifier(this.player, SharedMonsterAttributes.field_111263_d, "Vampire", this.getLevel(), this.getMaxLevel(), (Double)VampirismConfig.BALANCE.vpSpeedMaxMod.get(), 0.5, AttributeModifier.Operation.MULTIPLY_TOTAL, false);
            LevelAttributeModifier.applyModifier(this.player, SharedMonsterAttributes.field_111264_e, "Vampire", this.getLevel(), this.getMaxLevel(), (Double)VampirismConfig.BALANCE.vpStrengthMaxMod.get(), 0.5, AttributeModifier.Operation.MULTIPLY_TOTAL, false);
            LevelAttributeModifier.applyModifier(this.player, SharedMonsterAttributes.field_111267_a, "Vampire", this.getLevel(), this.getMaxLevel(), (Double)VampirismConfig.BALANCE.vpHealthMaxMod.get(), 0.5, AttributeModifier.Operation.ADDITION, true);
            if (this.player.func_110143_aJ() > this.player.func_110138_aP()) {
                this.player.func_70606_j(this.player.func_110138_aP());
            }
            LevelAttributeModifier.applyModifier(this.player, VReference.bloodExhaustion, "Vampire", this.getLevel(), this.getMaxLevel(), (Double)VampirismConfig.BALANCE.vpExhaustionMaxMod.get(), 0.5, AttributeModifier.Operation.MULTIPLY_TOTAL, false);
            if (newLevel > 13) {
                this.bloodStats.setMaxBlood(40);
            } else if (newLevel > 9) {
                this.bloodStats.setMaxBlood(34);
            } else if (newLevel > 6) {
                this.bloodStats.setMaxBlood(30);
            } else if (newLevel > 3) {
                this.bloodStats.setMaxBlood(26);
            } else {
                this.bloodStats.setMaxBlood(20);
            }
            if (newLevel > 0) {
                if (oldLevel == 0) {
                    this.skillHandler.enableRootSkill();
                }
            } else {
                this.actionHandler.resetTimers();
                this.skillHandler.disableAllSkills();
            }
        } else if (oldLevel == 0) {
            if (this.player.func_70644_a(Effects.field_76439_r)) {
                this.player.func_195063_d(Effects.field_76439_r);
            }
        } else if (newLevel == 0) {
            if (this.player.func_70660_b(Effects.field_76439_r) instanceof VampireNightVisionEffect) {
                this.player.func_195063_d(Effects.field_76439_r);
            }
            this.actionHandler.resetTimers();
        }
    }

    @Override
    public void onPlayerLoggedIn() {
        if (this.getLevel() > 0 && !this.player.field_70170_p.field_72995_K) {
            this.player.func_195064_c(new EffectInstance(ModEffects.sunscreen, 200, 4, true, false));
        }
    }

    @Override
    public void onPlayerLoggedOut() {
        this.endFeeding(false);
    }

    public void onSanguinareFinished() {
        if (Helper.canBecomeVampire(this.player) && !this.isRemote() && this.player.func_70089_S()) {
            FactionPlayerHandler handler = FactionPlayerHandler.get(this.player);
            handler.joinFaction((IPlayableFaction<? extends IFactionPlayer<?>>)this.getFaction());
            this.player.func_195064_c(new EffectInstance(Effects.field_76429_m, 300));
            this.player.func_195064_c(new EffectInstance(Effects.field_76443_y, 300));
        }
    }

    @Override
    public void onUpdate() {
        World world = this.player.func_130014_f_();
        world.func_217381_Z().func_76320_a("vampirism_vampirePlayer");
        super.onUpdate();
        int level = this.getLevel();
        if (level > 0) {
            if (this.player.field_70173_aa % 8 == 0) {
                this.isGettingSundamage((IWorld)world, true);
            }
            if (this.player.field_70173_aa % 40 == 0) {
                this.isGettingGarlicDamage((IWorld)world, true);
            }
        } else {
            this.sundamage_cache = false;
            this.garlic_cache = EnumStrength.NONE;
        }
        if (this.activatedVision != null) {
            this.activatedVision.tick(this);
        }
        if (!this.isRemote()) {
            if (level > 0) {
                boolean sync = false;
                boolean syncToAll = false;
                CompoundNBT syncPacket = new CompoundNBT();
                if (this.isGettingSundamage((IWorld)world)) {
                    this.handleSunDamage(false);
                } else if (this.ticksInSun > 0) {
                    --this.ticksInSun;
                }
                if (this.isGettingGarlicDamage((IWorld)world) != EnumStrength.NONE) {
                    DamageHandler.affectVampireGarlicAmbient(this, this.isGettingGarlicDamage((IWorld)world), this.player.field_70173_aa);
                }
                if (this.player.func_70089_S()) {
                    this.player.func_70050_g(300);
                    if (this.player.field_70173_aa % 16 == 4 && !this.getSpecialAttributes().waterResistance && !this.player.field_71075_bZ.field_75098_d) {
                        if (this.player.func_70090_H()) {
                            this.player.func_195064_c(new EffectInstance(Effects.field_76437_t, 80, (int)((float)this.getLevel() / (float)this.getMaxLevel() * 3.0f)));
                        } else if (this.player.func_70026_G()) {
                            this.player.func_195064_c(new EffectInstance(Effects.field_76437_t, 80, 0));
                        }
                    }
                }
                if (this.player.field_70173_aa % 9 == 3 && ((Boolean)VampirismConfig.BALANCE.vpFireResistanceReplace.get()).booleanValue() && this.player.func_70644_a(Effects.field_76426_n)) {
                    EffectInstance fireResistance = this.player.func_70660_b(Effects.field_76426_n);
                    this.player.func_195064_c(new EffectInstance(ModEffects.fire_protection, fireResistance.func_76459_b(), fireResistance.func_76458_c()));
                    this.player.func_195063_d(Effects.field_76426_n);
                }
                if (this.player.field_70173_aa % 9 == 3 && this.player.func_70644_a(Effects.field_76438_s)) {
                    EffectInstance hunterEffect = this.player.func_70660_b(Effects.field_76438_s);
                    this.player.func_195064_c(new EffectInstance(ModEffects.thirst, hunterEffect.func_76459_b(), hunterEffect.func_76458_c()));
                    this.player.func_195063_d(Effects.field_76438_s);
                }
                if (this.player.field_70173_aa % 64 == 0 && this.player instanceof ServerPlayerEntity) {
                    ((ServerPlayerEntity)this.player).func_147099_x().func_150873_a(this.player, Stats.field_199092_j.func_199076_b((Object)Stats.field_203284_n), 1);
                }
                if (this.actionHandler.updateActions()) {
                    sync = true;
                    syncToAll = true;
                    this.actionHandler.writeUpdateForClient(syncPacket);
                }
                if (this.skillHandler.isDirty()) {
                    sync = true;
                    this.skillHandler.writeUpdateForClient(syncPacket);
                }
                if (sync) {
                    this.sync(syncPacket, syncToAll);
                }
                if (this.feed_victim != -1 && this.feedBiteTickCounter++ >= 20) {
                    this.updateFeeding();
                    this.feedBiteTickCounter = 0;
                }
            } else {
                this.ticksInSun = 0;
            }
        } else {
            if (level > 0) {
                this.actionHandler.updateActions();
                if (this.isGettingSundamage((IWorld)world)) {
                    this.handleSunDamage(true);
                } else if (this.ticksInSun > 0) {
                    --this.ticksInSun;
                }
            } else {
                this.ticksInSun = 0;
            }
            if (this.feed_victim != -1 && this.feedBiteTickCounter++ % 5 == 0) {
                Entity e = VampirismMod.proxy.getMouseOverEntity();
                if (e == null || e.func_145782_y() != this.feed_victim) {
                    VampirismMod.dispatcher.sendToServer(new InputEventPacket("esb", ""));
                    this.feedBiteTickCounter = 0;
                    this.feed_victim = -1;
                    return;
                }
                if (this.feedBiteTickCounter >= 20) {
                    this.feedBiteTickCounter = 0;
                }
            }
            VampirismMod.proxy.handleSleepClient(this.player);
        }
        if (this.feed_victim == -1) {
            this.feedBiteTickCounter = 0;
        }
        world.func_217381_Z().func_76319_b();
    }

    @Override
    public void onUpdatePlayer(TickEvent.Phase phase) {
        if (phase == TickEvent.Phase.END && this.getLevel() > 0) {
            this.player.field_70170_p.func_217381_Z().func_76320_a("vampirism_bloodupdate");
            if (!this.player.field_70170_p.field_72995_K && this.bloodStats.onUpdate()) {
                this.sync(this.bloodStats.writeUpdate(new CompoundNBT()), false);
            }
            this.player.field_70170_p.func_217381_Z().func_76319_b();
        }
    }

    @Override
    public void saveData(CompoundNBT nbt) {
        super.saveData(nbt);
        this.bloodStats.writeNBT(nbt);
        nbt.func_74768_a(KEY_EYE, this.eyeType);
        nbt.func_74768_a(KEY_FANGS, this.fangType);
        nbt.func_74757_a(KEY_GLOWING_EYES, this.glowingEyes);
        this.actionHandler.saveToNbt(nbt);
        this.skillHandler.saveToNbt(nbt);
    }

    public boolean setEyeType(int eyeType) {
        if (eyeType >= 16 || eyeType < 0) {
            return false;
        }
        if (eyeType != this.eyeType) {
            this.eyeType = eyeType;
            if (!this.isRemote()) {
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_74768_a(KEY_EYE, eyeType);
                this.sync(nbt, true);
            }
        }
        return true;
    }

    public boolean setFangType(int fangType) {
        if (fangType >= 7 || fangType < 0) {
            return false;
        }
        if (fangType != this.fangType) {
            this.fangType = fangType;
            if (!this.isRemote()) {
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_74768_a(KEY_FANGS, fangType);
                this.sync(nbt, true);
            }
        }
        return true;
    }

    public void switchVision() {
        int id = -1;
        if (this.activatedVision != null) {
            id = this.unlockedVisions.indexOf(this.activatedVision);
        }
        if (++id > this.unlockedVisions.size() - 1) {
            id = -1;
        }
        this.activateVision(id == -1 ? null : this.unlockedVisions.get(id));
    }

    @Override
    public void unUnlockVision(@Nonnull IVampireVision vision) {
        if (vision.equals(this.activatedVision)) {
            this.activateVision(null);
        }
        this.unlockedVisions.remove(vision);
    }

    @Override
    public void unlockVision(@Nonnull IVampireVision vision) {
        if (((GeneralRegistryImpl)VampirismAPI.vampireVisionRegistry()).getIdOfVision(vision) == -1) {
            throw new IllegalArgumentException("You have to register the vision first: " + vision);
        }
        this.unlockedVisions.add(vision);
    }

    @Override
    public boolean useBlood(int amt, boolean allowPartial) {
        return this.bloodStats.removeBlood(amt, allowPartial);
    }

    @Override
    public boolean wantsBlood() {
        return this.getLevel() > 0 && this.bloodStats.needsBlood();
    }

    @Override
    protected VampirismPlayer copyFromPlayer(PlayerEntity old) {
        VampirePlayer oldVampire = VampirePlayer.get(old);
        CompoundNBT nbt = new CompoundNBT();
        oldVampire.saveData(nbt);
        this.loadData(nbt);
        this.wasDead = oldVampire.wasDead;
        return oldVampire;
    }

    @Override
    protected void loadUpdate(CompoundNBT nbt) {
        super.loadUpdate(nbt);
        if (nbt.func_74764_b(KEY_EYE)) {
            this.setEyeType(nbt.func_74762_e(KEY_EYE));
        }
        if (nbt.func_74764_b(KEY_FANGS)) {
            this.setFangType(nbt.func_74762_e(KEY_FANGS));
        }
        if (nbt.func_74764_b(KEY_SPAWN_BITE_PARTICLE)) {
            this.spawnBiteParticle(nbt.func_74762_e(KEY_SPAWN_BITE_PARTICLE));
        }
        if (nbt.func_74764_b(KEY_GLOWING_EYES)) {
            this.setGlowingEyes(nbt.func_74767_n(KEY_GLOWING_EYES));
        }
        if (nbt.func_74764_b(KEY_VICTIM_ID)) {
            this.feed_victim = nbt.func_74762_e(KEY_VICTIM_ID);
        }
        this.bloodStats.loadUpdate(nbt);
        this.actionHandler.readUpdateFromServer(nbt);
        this.skillHandler.readUpdateFromServer(nbt);
        if (nbt.func_74764_b(KEY_VISION)) {
            IVampireVision vision;
            int id = nbt.func_74762_e(KEY_VISION);
            if (id == -1) {
                vision = null;
            } else {
                vision = ((GeneralRegistryImpl)VampirismAPI.vampireVisionRegistry()).getVisionOfId(id);
                if (vision == null) {
                    LOGGER.warn("Failed to find vision with id {}", (Object)id);
                }
            }
            this.activateVision(vision);
        }
    }

    @Override
    protected void writeFullUpdate(CompoundNBT nbt) {
        super.writeFullUpdate(nbt);
        nbt.func_74768_a(KEY_EYE, this.getEyeType());
        nbt.func_74768_a(KEY_FANGS, this.getFangType());
        nbt.func_74757_a(KEY_GLOWING_EYES, this.getGlowingEyes());
        nbt.func_74768_a(KEY_VICTIM_ID, this.feed_victim);
        this.bloodStats.writeUpdate(nbt);
        this.actionHandler.writeUpdateForClient(nbt);
        this.skillHandler.writeUpdateForClient(nbt);
        nbt.func_74768_a(KEY_VISION, this.activatedVision == null ? -1 : ((GeneralRegistryImpl)VampirismAPI.vampireVisionRegistry()).getIdOfVision(this.activatedVision));
    }

    private void applyEntityAttributes() {
        if (this.player.func_110140_aT().func_111151_a(VReference.sunDamage) == null) {
            this.player.func_110140_aT().func_111150_b(VReference.sunDamage).func_111128_a(((Double)VampirismConfig.BALANCE.vpSundamage.get()).doubleValue());
        }
        if (this.player.func_110140_aT().func_111151_a(VReference.bloodExhaustion) == null) {
            this.player.func_110140_aT().func_111150_b(VReference.bloodExhaustion).func_111128_a(((Double)VampirismConfig.BALANCE.vpExhaustionMaxMod.get()).doubleValue());
        }
        if (this.player.func_110140_aT().func_111151_a(VReference.biteDamage) == null) {
            this.player.func_110140_aT().func_111150_b(VReference.biteDamage).func_111128_a((double)((Integer)VampirismConfig.BALANCE.vpBiteDamage.get()).intValue());
        }
    }

    private void biteAttack(LivingEntity entity, boolean hunter) {
        if (!PermissionAPI.hasPermission((PlayerEntity)this.player, (String)"vampirism.bite.attack.player")) {
            return;
        }
        float damage = this.getSpecialAttributes().bat ? 0.1f : (float)this.player.func_110148_a(VReference.biteDamage).func_111126_e();
        entity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)this.player), damage);
        if (hunter || ((Boolean)ExtendedCreature.getSafe((Entity)entity).map(IExtendedCreatureVampirism::hasPoisonousBlood).orElse((Object)false)).booleanValue()) {
            this.player.func_195064_c(new EffectInstance(ModEffects.poison, 60));
            if (this.player instanceof ServerPlayerEntity) {
                ModAdvancements.TRIGGER_VAMPIRE_ACTION.trigger((ServerPlayerEntity)this.player, VampireActionTrigger.Action.POISONOUS_BITE);
            }
        }
        if (hunter && entity instanceof PlayerEntity && HunterCoatItem.isFullyEquipped((PlayerEntity)entity)) {
            this.player.func_70097_a(DamageSource.func_92087_a((Entity)entity), damage);
        }
    }

    private void biteBlock(@Nonnull BlockPos pos, @Nonnull BlockState blockState, @Nullable TileEntity tileEntity) {
        if (this.isRemote()) {
            return;
        }
        if (this.getLevel() == 0) {
            return;
        }
        if (!this.bloodStats.needsBlood()) {
            return;
        }
        int need = Math.min(8, this.bloodStats.getMaxBlood() - this.bloodStats.getBloodLevel());
        if (((Object)((Object)ModBlocks.blood_container)).equals(blockState.func_177230_c()) && tileEntity != null) {
            tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null).ifPresent(handler -> {
                FluidStack drained;
                int blood = 0;
                FluidStack drainable = handler.drain(new FluidStack(ModFluids.blood, need * 100), IFluidHandler.FluidAction.SIMULATE);
                if (drainable != null && drainable.getAmount() >= 100 && (drained = handler.drain(drainable.getAmount() / 100 * 100, IFluidHandler.FluidAction.EXECUTE)) != null) {
                    blood = drained.getAmount() / 100;
                }
                if (blood > 0) {
                    this.drinkBlood(blood, 0.3f);
                    CompoundNBT updatePacket = this.bloodStats.writeUpdate(new CompoundNBT());
                    this.sync(updatePacket, true);
                }
            });
        }
    }

    private boolean biteFeed(LivingEntity entity) {
        if (this.isRemote()) {
            return true;
        }
        if (this.getLevel() == 0) {
            return false;
        }
        int blood = 0;
        float saturationMod = 1.0f;
        boolean continue_feeding = true;
        if (this.feed_victim_bite_type == IVampirePlayer.BITE_TYPE.SUCK_BLOOD_CREATURE && entity.func_70089_S()) {
            LazyOptional<IExtendedCreatureVampirism> opt = ExtendedCreature.getSafe((Entity)entity);
            blood = (Integer)opt.map(creature -> creature.onBite(this)).orElse((Object)0);
            saturationMod = ((Float)opt.map(IBiteableEntity::getBloodSaturation).orElse((Object)Float.valueOf(0.0f))).floatValue();
            if (this.isAdvancedBiter() && (Integer)opt.map(IExtendedCreatureVampirism::getBlood).orElse((Object)0) == 1) {
                continue_feeding = false;
            }
        } else if (this.feed_victim_bite_type == IVampirePlayer.BITE_TYPE.SUCK_BLOOD_PLAYER || this.feed_victim_bite_type == IVampirePlayer.BITE_TYPE.SUCK_BLOOD_HUNTER_PLAYER) {
            blood = (Integer)VampirePlayer.getOpt((PlayerEntity)entity).map(v -> v.onBite(this)).orElse((Object)0);
            saturationMod = ((Float)VampirePlayer.getOpt((PlayerEntity)entity).map(VampirePlayer::getBloodSaturation).orElse((Object)Float.valueOf(0.0f))).floatValue();
            if (this.feed_victim_bite_type == IVampirePlayer.BITE_TYPE.SUCK_BLOOD_HUNTER_PLAYER) {
                this.player.func_195064_c(new EffectInstance(ModEffects.poison, 15, 2));
            }
        } else if (this.feed_victim_bite_type == IVampirePlayer.BITE_TYPE.SUCK_BLOOD) {
            blood = ((IBiteableEntity)entity).onBite(this);
            saturationMod = ((IBiteableEntity)entity).getBloodSaturation();
        }
        if (blood > 0) {
            this.drinkBlood(blood, saturationMod);
            CompoundNBT updatePacket = this.bloodStats.writeUpdate(new CompoundNBT());
            updatePacket.func_74768_a(KEY_SPAWN_BITE_PARTICLE, entity.func_145782_y());
            this.sync(updatePacket, true);
            if (this.player instanceof ServerPlayerEntity) {
                ModAdvancements.TRIGGER_VAMPIRE_ACTION.trigger((ServerPlayerEntity)this.player, VampireActionTrigger.Action.SUCK_BLOOD);
            }
            return continue_feeding;
        }
        return false;
    }

    public void setSkinData(int ... data) {
        if (data.length > 0) {
            this.setFangType(data[0]);
            if (data.length > 1) {
                this.setEyeType(data[1]);
                if (data.length > 2) {
                    this.setGlowingEyes(data[2] > 0);
                }
            }
        }
    }

    private void handleSpareBlood(int amt) {
        BloodHelper.fillBloodIntoInventory(this.player, amt * 100);
    }

    private void handleSunDamage(boolean isRemote) {
        float damage;
        int sunscreen;
        EffectInstance potionEffect = this.player.func_70660_b(ModEffects.sunscreen);
        int n = sunscreen = potionEffect == null ? -1 : potionEffect.func_76458_c();
        if (this.ticksInSun < 100) {
            ++this.ticksInSun;
        }
        if (sunscreen >= 5 && this.ticksInSun > 50) {
            this.ticksInSun = 50;
        }
        if (isRemote || this.player.field_71075_bZ.field_75098_d || this.player.field_71075_bZ.field_75102_a) {
            return;
        }
        if (((Boolean)VampirismConfig.BALANCE.vpSundamageNausea.get()).booleanValue() && this.getLevel() >= (Integer)VampirismConfig.BALANCE.vpSundamageNauseaMinLevel.get() && this.player.field_70173_aa % 300 == 1 && this.ticksInSun > 50 && sunscreen == -1) {
            this.player.func_195064_c(new EffectInstance(Effects.field_76431_k, 180));
        }
        if (this.getLevel() >= (Integer)VampirismConfig.BALANCE.vpSundamageWeaknessMinLevel.get() && this.player.field_70173_aa % 150 == 3 && sunscreen < 5) {
            this.player.func_195064_c(new EffectInstance(Effects.field_76437_t, 152, 0));
        }
        if (this.getLevel() >= (Integer)VampirismConfig.BALANCE.vpSundamageMinLevel.get() && this.ticksInSun >= 100 && this.player.field_70173_aa % 40 == 5 && (damage = (float)this.player.func_110148_a(VReference.sunDamage).func_111126_e()) > 0.0f) {
            this.player.func_70097_a(VReference.SUNDAMAGE, damage);
        }
    }

    private void spawnBiteParticle(int entityId) {
        Entity entity = this.player.field_70170_p.func_73045_a(entityId);
        if (entity != null) {
            UtilLib.spawnParticles(this.player.field_70170_p, (IParticleData)ParticleTypes.field_197614_g, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), this.player.func_226277_ct_() - entity.func_226277_ct_(), this.player.func_226278_cu_() - entity.func_226278_cu_(), this.player.func_226281_cx_() - entity.func_226281_cx_(), 10, 1.0f);
        }
        for (int j = 0; j < 16; ++j) {
            Vec3d vec3 = new Vec3d(((double)this.player.func_70681_au().nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vec3 = vec3.func_178789_a(-this.player.field_70125_A * (float)Math.PI / 180.0f);
            vec3 = vec3.func_178785_b(-this.player.field_70177_z * (float)Math.PI / 180.0f);
            double d0 = (double)(-this.player.func_70681_au().nextFloat()) * 0.6 - 0.3;
            Vec3d vec31 = new Vec3d(((double)this.player.func_70681_au().nextFloat() - 0.5) * 0.3, d0, 0.6);
            vec31 = vec31.func_178789_a(-this.player.field_70125_A * (float)Math.PI / 180.0f);
            vec31 = vec31.func_178785_b(-this.player.field_70177_z * (float)Math.PI / 180.0f);
            vec31 = vec31.func_72441_c(this.player.func_226277_ct_(), this.player.func_226278_cu_() + (double)this.player.func_70047_e(), this.player.func_226281_cx_());
            this.player.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, new ItemStack((IItemProvider)Items.field_151034_e)), vec31.field_72450_a, vec31.field_72448_b, vec31.field_72449_c, vec3.field_72450_a, vec3.field_72448_b + 0.05, vec3.field_72449_c);
        }
        this.player.field_70170_p.func_184134_a(this.player.func_226277_ct_(), this.player.func_226278_cu_(), this.player.func_226281_cx_(), ModSounds.player_bite, SoundCategory.PLAYERS, 1.0f, 1.0f, false);
    }

    private void updateFeeding() {
        Entity entity = this.player.field_70170_p.func_73045_a(this.feed_victim);
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity e = (LivingEntity)entity;
        if (e.func_110143_aJ() == 0.0f) {
            this.endFeeding(true);
            return;
        }
        e.func_195064_c(new EffectInstance(Effects.field_76421_d, 20, 7, false, false));
        this.player.func_195064_c(new EffectInstance(Effects.field_76421_d, 25, 4, false, false));
        ModParticles.spawnParticlesServer(this.player.field_70170_p, new FlyingBloodEntityParticleData(ModParticles.flying_blood_entity, this.player.func_145782_y(), true), e.func_226277_ct_(), e.func_226278_cu_() + (double)(e.func_70047_e() / 2.0f), e.func_226281_cx_(), 10, 0.1f, 0.1f, 0.1f, 0.0);
        if (!this.biteFeed(e)) {
            this.endFeeding(true);
        }
        if (!((double)e.func_70032_d((Entity)this.player) <= this.player.func_110148_a(PlayerEntity.REACH_DISTANCE).func_111126_e() + 1.0) || e.func_110143_aJ() == 0.0f) {
            this.endFeeding(true);
        }
    }

    private static class Storage
    implements Capability.IStorage<IVampirePlayer> {
        private Storage() {
        }

        public void readNBT(Capability<IVampirePlayer> capability, IVampirePlayer instance, Direction side, INBT nbt) {
            ((VampirePlayer)instance).loadData((CompoundNBT)nbt);
        }

        public INBT writeNBT(Capability<IVampirePlayer> capability, IVampirePlayer instance, Direction side) {
            CompoundNBT nbt = new CompoundNBT();
            ((VampirePlayer)instance).saveData(nbt);
            return nbt;
        }
    }
}

