/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.potion;

import com.google.common.base.Preconditions;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.entity.IExtendedCreatureVampirism;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.potion.PotionSanguinareEffect;
import de.teamlapen.vampirism.potion.VampirismEffect;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.DisplayEffectsScreen;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PotionSanguinare
extends VampirismEffect {
    public static void addRandom(LivingEntity entity, boolean player) {
        int n;
        if (player) {
            n = (Integer)VampirismConfig.BALANCE.vpSanguinareAverageDuration.get();
        } else {
            BalanceMobProps.mobProps.getClass();
            n = 60;
        }
        int avgDuration = 20 * n;
        int duration = (int)((entity.func_70681_au().nextFloat() + 0.5f) * (float)avgDuration);
        PotionSanguinareEffect effect = new PotionSanguinareEffect(duration);
        Preconditions.checkNotNull((Object)((Object)effect));
        if (!((Boolean)VampirismConfig.BALANCE.canCancelSanguinare.get()).booleanValue()) {
            effect.setCurativeItems(new ArrayList());
        }
        entity.func_195064_c((EffectInstance)effect);
    }

    public PotionSanguinare(String name, EffectType effectType, int potionColor) {
        super(name, effectType, potionColor);
        this.func_220304_a(SharedMonsterAttributes.field_111264_e, "22663B89-116E-49DC-9B6B-9971489B5BE5", 2.0, AttributeModifier.Operation.ADDITION);
    }

    public boolean func_76397_a(int duration, int p_76397_2_) {
        return duration == 2;
    }

    public void func_76394_a(LivingEntity entity, int p_76394_2_) {
        if (entity.field_70170_p.field_72995_K || !entity.func_70089_S()) {
            return;
        }
        if (entity instanceof CreatureEntity) {
            ExtendedCreature.getSafe((Entity)entity).ifPresent(IExtendedCreatureVampirism::makeVampire);
        }
        if (entity instanceof PlayerEntity) {
            VampirePlayer.getOpt((PlayerEntity)entity).ifPresent(VampirePlayer::onSanguinareFinished);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRenderInvText(EffectInstance effect) {
        return false;
    }

    public List<ItemStack> getCurativeItems() {
        List l = super.getCurativeItems();
        l.add(new ItemStack((IItemProvider)ModItems.garlic_bread));
        return l;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderInventoryEffect(EffectInstance effect, DisplayEffectsScreen<?> gui, int x, int y, float z) {
        String s = UtilLib.translate(effect.func_188419_a().func_76393_a(), new Object[0]);
        gui.font.func_175063_a(s, (float)(x + 10 + 18), (float)(y + 6), 0xFFFFFF);
    }
}

