/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.tileentity;

import de.teamlapen.lib.lib.util.FluidTankWithListener;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.items.BloodBottleFluidHandler;
import de.teamlapen.vampirism.particle.FlyingBloodEntityParticleData;
import de.teamlapen.vampirism.player.vampire.VampireLevelingConf;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.TileFluidHandler;

public class AltarInspirationTileEntity
extends TileFluidHandler
implements ITickableTileEntity,
FluidTankWithListener.IFluidTankListener {
    public static final int CAPACITY = 10000;
    public static final ModelProperty<Integer> FLUID_LEVEL_PROP = new ModelProperty();
    private final int RITUAL_TIME = 60;
    private int ritualTicksLeft = 0;
    private PlayerEntity ritualPlayer;
    private IModelData modelData;

    public AltarInspirationTileEntity() {
        super(ModTiles.altar_inspiration);
        this.tank = new InternalTank(10000).setListener(this);
    }

    @Nonnull
    public IModelData getModelData() {
        if (this.modelData == null) {
            this.updateModelData(false);
        }
        return this.modelData;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 1, this.func_189517_E_());
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void func_70296_d() {
        if (this.field_145850_b != null) {
            if (this.field_145850_b.field_72995_K) {
                this.updateModelData(true);
            }
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
            super.func_70296_d();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        FluidStack old = this.tank.getFluid();
        this.func_145839_a(pkt.func_148857_g());
        if (!old.isFluidStackIdentical(this.tank.getFluid())) {
            this.updateModelData(true);
        }
    }

    @Override
    public void onTankContentChanged() {
        this.func_70296_d();
    }

    public void startRitual(PlayerEntity p) {
        if (this.ritualTicksLeft > 0 || !p.func_70089_S()) {
            return;
        }
        VampirePlayer player = VampirePlayer.get(p);
        int targetLevel = player.getLevel() + 1;
        VampireLevelingConf levelingConf = VampireLevelingConf.getInstance();
        if (!levelingConf.isLevelValidForAltarInspiration(targetLevel)) {
            if (p.field_70170_p.field_72995_K) {
                p.func_145747_a((ITextComponent)new TranslationTextComponent("text.vampirism.altar_infusion.ritual_level_wrong", new Object[0]));
            }
            return;
        }
        int neededBlood = levelingConf.getRequiredBloodForAltarInspiration(targetLevel) * 100;
        if (this.tank.getFluidAmount() + 99 < neededBlood) {
            if (p.field_70170_p.field_72995_K) {
                p.func_145747_a((ITextComponent)new TranslationTextComponent("text.vampirism.not_enough_blood", new Object[0]));
            }
            return;
        }
        if (!p.field_70170_p.field_72995_K) {
            ModParticles.spawnParticlesServer(p.field_70170_p, new FlyingBloodEntityParticleData(ModParticles.flying_blood_entity, player.getRepresentingEntity().func_145782_y(), false), (double)this.field_174879_c.func_177958_n() + 0.5, this.field_174879_c.func_177956_o() + 1, (double)this.field_174879_c.func_177952_p() + 0.5, 40, 0.1f, 0.1f, 0.1f, 0.0);
        } else {
            ((InternalTank)this.tank).doDrain(neededBlood, IFluidHandler.FluidAction.EXECUTE);
        }
        this.ritualPlayer = p;
        this.ritualTicksLeft = 60;
    }

    public void func_73660_a() {
        if (this.ritualTicksLeft == 0 || this.field_145850_b == null || this.ritualPlayer == null || !this.ritualPlayer.func_70089_S()) {
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            switch (this.ritualTicksLeft) {
                case 5: {
                    ((ServerWorld)this.field_145850_b).func_217468_a(new LightningBoltEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), true));
                    this.ritualPlayer.func_70606_j(this.ritualPlayer.func_110138_aP());
                    break;
                }
                case 1: {
                    VampirePlayer player = VampirePlayer.get(this.ritualPlayer);
                    int targetLevel = player.getLevel() + 1;
                    VampireLevelingConf levelingConf = VampireLevelingConf.getInstance();
                    int blood = levelingConf.getRequiredBloodForAltarInspiration(targetLevel) * 100;
                    ((InternalTank)this.tank).doDrain(blood, IFluidHandler.FluidAction.EXECUTE);
                    this.ritualPlayer.func_195064_c(new EffectInstance(Effects.field_76428_l, targetLevel * 10 * 20));
                    FactionPlayerHandler.get(this.ritualPlayer).setFactionLevel(VReference.VAMPIRE_FACTION, targetLevel);
                    VampirePlayer.get(this.ritualPlayer).drinkBlood(Integer.MAX_VALUE, 0.0f, false);
                    break;
                }
            }
        }
        --this.ritualTicksLeft;
    }

    private void updateModelData(boolean refresh) {
        FluidStack fluid = this.tank.getFluid();
        int l = 0;
        if (!fluid.isEmpty()) {
            float i = (float)fluid.getAmount() / 10000.0f * 10.0f;
            l = i > 0.0f && i < 1.0f ? 1 : (int)i;
        }
        this.modelData = new ModelDataMap.Builder().withInitial(FLUID_LEVEL_PROP, (Object)l).build();
        if (refresh) {
            ModelDataManager.requestModelDataRefresh((TileEntity)this);
        }
    }

    public static void setBloodValue(IBlockReader worldIn, Random randomIn, BlockPos blockPosIn) {
        TileEntity tileEntity = worldIn.func_175625_s(blockPosIn);
        if (tileEntity instanceof AltarInspirationTileEntity) {
            tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).ifPresent(fluidHandler -> fluidHandler.fill(new FluidStack(ModFluids.blood, BloodBottleFluidHandler.getAdjustedAmount((int)(10000.0f * randomIn.nextFloat()))), IFluidHandler.FluidAction.EXECUTE));
        }
    }

    private static class InternalTank
    extends FluidTankWithListener {
        private InternalTank(int capacity) {
            super(capacity, (FluidStack fluidStack) -> ModFluids.blood.func_207187_a(fluidStack.getFluid()));
            this.setDrainable(false);
        }

        void doDrain(int maxDrain, IFluidHandler.FluidAction action) {
            this.setDrainable(true);
            super.drain(maxDrain, action);
            this.setDrainable(false);
        }
    }
}

