/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.tileentity;

import de.teamlapen.lib.lib.util.FluidTankWithListener;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.items.BloodBottleFluidHandler;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.TileFluidHandler;

public class BloodContainerTileEntity
extends TileFluidHandler
implements FluidTankWithListener.IFluidTankListener {
    public static final int LEVEL_AMOUNT = 900;
    public static final int CAPACITY = 12600;
    public static final ModelProperty<Integer> FLUID_LEVEL_PROP = new ModelProperty();
    public static final ModelProperty<Boolean> FLUID_IMPURE = new ModelProperty();
    private int lastSyncedAmount = Integer.MIN_VALUE;
    private IModelData modelData;

    public BloodContainerTileEntity() {
        super(ModTiles.blood_container);
        this.tank = new FluidTankWithListener(12600, fluidStack -> ModFluids.blood.func_207187_a(fluidStack.getFluid()) || ModFluids.impure_blood.func_207187_a(fluidStack.getFluid())).setListener(this);
    }

    @Nonnull
    public FluidStack getFluid() {
        return this.tank.getFluid();
    }

    @Nonnull
    public IModelData getModelData() {
        if (this.modelData == null) {
            this.updateModelData(false);
        }
        return this.modelData;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbtTag = new CompoundNBT();
        this.func_189515_b(nbtTag);
        return new SUpdateTileEntityPacket(this.func_174877_v(), 1, this.func_189517_E_());
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void func_70296_d() {
        if (this.field_145850_b != null) {
            if (this.field_145850_b.field_72995_K) {
                this.updateModelData(true);
            }
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
            super.func_70296_d();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        FluidStack old = this.tank.getFluid();
        this.func_145839_a(pkt.func_148857_g());
        if (!old.isEmpty() && !old.isFluidStackIdentical(this.tank.getFluid()) || old.isEmpty() && !this.tank.getFluid().isEmpty()) {
            this.func_70296_d();
        }
    }

    @Override
    public void onTankContentChanged() {
        FluidStack fluid = this.tank.getFluid();
        if (this.lastSyncedAmount != Integer.MIN_VALUE || !fluid.isEmpty() && Math.abs(fluid.getAmount() - this.lastSyncedAmount) >= 100) {
            this.func_70296_d();
            this.lastSyncedAmount = fluid.isEmpty() ? Integer.MIN_VALUE : fluid.getAmount();
        }
    }

    public void setFluidStack(FluidStack stack) {
        this.tank.setFluid(stack);
    }

    private void updateModelData(boolean refresh) {
        FluidStack fluid = this.tank.getFluid();
        int l = 0;
        if (!fluid.isEmpty()) {
            float amount = (float)fluid.getAmount() / 900.0f;
            l = amount > 0.0f && amount < 1.0f ? 1 : (int)amount;
        }
        this.modelData = new ModelDataMap.Builder().withInitial(FLUID_LEVEL_PROP, (Object)l).withInitial(FLUID_IMPURE, (Object)fluid.getFluid().equals(ModFluids.impure_blood)).build();
        if (refresh) {
            ModelDataManager.requestModelDataRefresh((TileEntity)this);
        }
    }

    public static void setBloodValue(IBlockReader worldIn, Random randomIn, BlockPos blockPosIn) {
        TileEntity tileEntity = worldIn.func_175625_s(blockPosIn);
        if (tileEntity instanceof BloodContainerTileEntity) {
            ((BloodContainerTileEntity)tileEntity).setFluidStack(new FluidStack(ModFluids.blood, BloodBottleFluidHandler.getAdjustedAmount((int)(12600.0f * randomIn.nextFloat()))));
        }
    }
}

