/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.tileentity;

import de.teamlapen.lib.lib.inventory.InventoryHelper;
import de.teamlapen.lib.lib.tile.InventoryTileEntity;
import de.teamlapen.vampirism.api.general.BloodConversionRegistry;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.inventory.container.BloodGrinderContainer;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class BloodGrinderTileEntity
extends InventoryTileEntity
implements ITickableTileEntity {
    private int cooldownPull = 0;
    private int cooldownProcess = 0;
    private final IItemHandler itemHandler = this.createWrapper();
    private final LazyOptional<IItemHandler> itemHandlerOptional = LazyOptional.of(() -> this.itemHandler);

    private static List<ItemEntity> getCaptureItems(World worldIn, BlockPos pos) {
        int posX = pos.func_177958_n();
        int posY = pos.func_177956_o();
        int posZ = pos.func_177952_p();
        return worldIn.func_175647_a(ItemEntity.class, new AxisAlignedBB((double)posX, (double)posY + 0.5, (double)posZ, (double)posX + 1.0, (double)posY + 1.5, (double)posZ + 1.0), EntityPredicates.field_94557_a);
    }

    public BloodGrinderTileEntity() {
        super(ModTiles.grinder, 1, BloodGrinderContainer.SELECTOR_INFOS);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (side != Direction.DOWN && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandlerOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_145839_a(CompoundNBT tagCompound) {
        super.func_145839_a(tagCompound);
        this.cooldownPull = tagCompound.func_74762_e("cooldown_pull");
        this.cooldownProcess = tagCompound.func_74762_e("cooldown_process");
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            --this.cooldownPull;
            if (this.cooldownPull <= 0) {
                this.cooldownPull = 10;
                this.updatePull();
            }
            --this.cooldownProcess;
            if (this.cooldownProcess <= 0) {
                this.cooldownProcess = 10;
                this.updateProcess();
            }
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("cooldown_pull", this.cooldownPull);
        compound.func_74768_a("cooldown_process", this.cooldownProcess);
        return super.func_189515_b(compound);
    }

    @Nonnull
    protected Container func_213906_a(int id, PlayerInventory player) {
        return new BloodGrinderContainer(id, player, (IInventory)this, IWorldPosCallable.func_221488_a((World)player.field_70458_d.func_130014_f_(), (BlockPos)this.func_174877_v()));
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("tile.vampirism.blood_grinder", new Object[0]);
    }

    private boolean pullItems() {
        if (this.field_145850_b == null) {
            return false;
        }
        boolean flag = (Boolean)InventoryHelper.tryGetItemHandler((IBlockReader)this.field_145850_b, this.field_174879_c.func_177984_a(), Direction.DOWN).map(pair -> {
            IItemHandler handler = (IItemHandler)pair.getLeft();
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack simulated;
                ItemStack extracted = handler.extractItem(i, 1, true);
                if (extracted.func_190926_b() || !(simulated = ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemHandler, (ItemStack)extracted, (boolean)true)).func_190926_b()) continue;
                extracted = handler.extractItem(i, 1, false);
                ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemHandler, (ItemStack)extracted, (boolean)false);
                return true;
            }
            return false;
        }).orElse((Object)false);
        if (flag) {
            return true;
        }
        for (ItemEntity entityItem : BloodGrinderTileEntity.getCaptureItems(this.field_145850_b, this.field_174879_c)) {
            ItemStack stack = entityItem.func_92059_d();
            for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                ItemStack stack2 = this.itemHandler.insertItem(i, stack, true);
                if (!stack2.func_190926_b()) continue;
                stack2 = this.itemHandler.insertItem(i, stack, false);
                if (stack2.func_190916_E() < stack.func_190916_E()) {
                    entityItem.func_70106_y();
                } else {
                    entityItem.func_92058_a(stack2);
                }
                return true;
            }
        }
        return false;
    }

    private void updateProcess() {
        if (this.field_145850_b != null && !this.func_191420_l()) {
            for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                int slot = i;
                ItemStack stack = this.itemHandler.extractItem(i, 1, true);
                int blood = BloodConversionRegistry.getImpureBloodValue(stack.func_77973_b());
                if (blood <= 0) continue;
                FluidStack fluid = new FluidStack(ModFluids.impure_blood, blood);
                FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177977_b(), (Direction)Direction.UP).ifPresent(handler -> {
                    int filled = handler.fill(fluid, IFluidHandler.FluidAction.SIMULATE);
                    if ((float)filled >= 0.9f * (float)blood) {
                        ItemStack extractedStack = this.itemHandler.extractItem(slot, 1, false);
                        handler.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
                        this.field_145850_b.func_184133_a(null, this.func_174877_v(), ModSounds.grinder, SoundCategory.BLOCKS, 0.5f, 0.7f);
                        this.cooldownProcess = MathHelper.func_76125_a((int)(20 * filled / 100), (int)20, (int)100);
                    }
                });
            }
        }
    }

    private boolean updatePull() {
        if (!this.isFull()) {
            boolean flag = this.pullItems();
            if (flag) {
                this.cooldownPull = 20;
            }
            return flag;
        }
        return false;
    }
}

