/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.tileentity;

import de.teamlapen.lib.lib.util.FluidTankWithListener;
import de.teamlapen.vampirism.api.general.BloodConversionRegistry;
import de.teamlapen.vampirism.blocks.SieveBlock;
import de.teamlapen.vampirism.core.ModTiles;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class SieveTileEntity
extends TileEntity
implements ITickableTileEntity,
FluidTankWithListener.IFluidTankListener {
    private final LazyOptional<IFluidHandler> cap;
    private FluidTankWithListener tank = new FilteringFluidTank(2000).setListener(this);
    private int cooldownPull = 0;
    private int cooldownProcess = 0;
    private boolean active;

    public SieveTileEntity() {
        super(ModTiles.sieve);
        this.tank.setDrainable(false);
        this.cap = LazyOptional.of(() -> this.tank);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (facing != Direction.DOWN && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.cap.cast();
        }
        return super.getCapability(capability, facing);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 1, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74757_a("active", this.isActive());
        return nbt;
    }

    public boolean isActive() {
        return this.active;
    }

    private void setActive(boolean active) {
        if (this.active != active) {
            this.active = active;
            if (this.field_145850_b != null) {
                this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((IProperty)SieveBlock.PROPERTY_ACTIVE, (Comparable)Boolean.valueOf(active)));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        boolean old = this.active;
        this.active = pkt.func_148857_g().func_74767_n("active");
        if (this.active != old && this.field_145850_b != null) {
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        }
    }

    @Override
    public void onTankContentChanged() {
        this.setActive(true);
    }

    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        this.tank.readFromNBT(tag);
        this.cooldownProcess = tag.func_74762_e("cooldown_process");
        this.cooldownPull = tag.func_74762_e("cooldown_pull");
    }

    public void func_73660_a() {
        if (this.field_145850_b == null) {
            return;
        }
        if (--this.cooldownProcess < 0) {
            this.cooldownProcess = 15;
            if (this.tank.getFluidAmount() > 0) {
                FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177977_b(), (Direction)Direction.UP).ifPresent(handler -> {
                    this.tank.setDrainable(true);
                    FluidStack transferred = FluidUtil.tryFluidTransfer((IFluidHandler)handler, (IFluidHandler)this.tank, (int)200, (boolean)true);
                    this.tank.setDrainable(false);
                    if (!transferred.isEmpty()) {
                        this.cooldownProcess = 30;
                        this.setActive(true);
                    }
                });
            } else if (this.active) {
                this.setActive(false);
            }
        }
        if (--this.cooldownPull < 0) {
            this.cooldownPull = 10;
            FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177984_a(), (Direction)Direction.DOWN).ifPresent(handler -> {
                FluidStack transferred = FluidUtil.tryFluidTransfer((IFluidHandler)this.tank, (IFluidHandler)handler, (int)200, (boolean)true);
            });
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag = super.func_189515_b(tag);
        this.tank.writeToNBT(tag);
        this.cooldownProcess = tag.func_74762_e("cooldown_process");
        this.cooldownPull = tag.func_74762_e("cooldown_pull");
        return tag;
    }

    private class FilteringFluidTank
    extends FluidTankWithListener {
        private FilteringFluidTank(int capacity) {
            super(capacity);
        }

        @Override
        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (!BloodConversionRegistry.existsBloodValue(resource.getFluid())) {
                return 0;
            }
            FluidStack converted = BloodConversionRegistry.getBloodFromFluid(resource);
            int filled = super.fill(converted, action);
            if (action.execute()) {
                SieveTileEntity.this.cooldownPull = 10;
            }
            return (int)((float)filled / BloodConversionRegistry.getBloodValue(resource));
        }
    }
}

