/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.tileentity;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.tileentity.TotemTileEntity;
import de.teamlapen.vampirism.world.FactionPointOfInterestType;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.village.PointOfInterest;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.structure.Structures;
import net.minecraft.world.server.ServerWorld;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TotemHelper {
    public static final int MIN_HOMES = 4;
    public static final int MIN_WORKSTATIONS = 2;
    public static final int MIN_VILLAGER = 4;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final HashMap<Dimension, Map<BlockPos, MutableBoundingBox>> vampireVillages = Maps.newHashMap();
    private static final Map<BlockPos, BlockPos> totemPositions = Maps.newHashMap();
    private static final Map<BlockPos, Set<PointOfInterest>> poiSets = Maps.newHashMap();

    public static void clearCacheForDimension(Dimension dimension) {
        vampireVillages.remove(dimension);
    }

    public static void addVampireVillage(Dimension dimension, BlockPos pos, AxisAlignedBB box) {
        TotemHelper.updateVampireBoundingBox(dimension, pos, box);
    }

    public static void removeVampireVillage(Dimension dimension, BlockPos pos) {
        TotemHelper.updateVampireBoundingBox(dimension, pos, null);
    }

    public static boolean isInsideVampireAreaCached(Dimension dimension, BlockPos blockPos) {
        if (vampireVillages.containsKey(dimension)) {
            for (Map.Entry<BlockPos, MutableBoundingBox> entry : vampireVillages.get(dimension).entrySet()) {
                if (!entry.getValue().func_175898_b((Vec3i)blockPos)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean addTotem(World world, Set<PointOfInterest> pois, BlockPos totemPos) {
        BlockPos conflict = null;
        for (PointOfInterest poi2 : pois) {
            if (!totemPositions.containsKey(poi2.func_218261_f()) || totemPositions.get(poi2.func_218261_f()).equals((Object)totemPos)) continue;
            conflict = totemPositions.get(poi2.func_218261_f());
            break;
        }
        if (conflict != null) {
            TotemHelper.handleTotemConflict(pois, world, totemPos, conflict);
        }
        if (pois.isEmpty()) {
            return false;
        }
        for (PointOfInterest pointOfInterest : pois) {
            totemPositions.put(pointOfInterest.func_218261_f(), totemPos);
        }
        totemPositions.put(totemPos, totemPos);
        if (poiSets.containsKey(totemPos)) {
            poiSets.get(totemPos).forEach(poi -> {
                if (!pois.contains(poi)) {
                    totemPositions.remove(poi.func_218261_f());
                }
            });
        }
        poiSets.put(totemPos, pois);
        return !pois.isEmpty();
    }

    private static void handleTotemConflict(Set<PointOfInterest> pois, World world, BlockPos totem, BlockPos conflicting) {
        TotemTileEntity totem1 = (TotemTileEntity)world.func_175625_s(totem);
        TotemTileEntity totem2 = (TotemTileEntity)world.func_175625_s(conflicting);
        if (totem2 != null) {
            return;
        }
        boolean ignoreOtherTotem = true;
        if (totem1.getControllingFaction() != totem2.getControllingFaction()) {
            ignoreOtherTotem = false;
        }
        if (totem1.getCapturingFaction() != null || totem2.getCapturingFaction() != null) {
            ignoreOtherTotem = false;
        }
        StructureStart structure1 = Structures.field_215157_o.func_202364_a((IWorld)world, totem, false);
        StructureStart structure2 = Structures.field_215157_o.func_202364_a((IWorld)world, conflicting, false);
        if (structure1 == StructureStart.field_214630_a && structure2 != StructureStart.field_214630_a) {
            ignoreOtherTotem = false;
        }
        if (totem2.getSize() >= totem1.getSize()) {
            ignoreOtherTotem = false;
        }
        if (!ignoreOtherTotem) {
            pois.removeIf(poi -> !totem.equals((Object)totemPositions.get(poi.func_218261_f())));
        }
    }

    public static void removeTotem(Collection<PointOfInterest> pois, BlockPos pos, boolean removeTotem) {
        pois.forEach(pointOfInterest -> totemPositions.remove(pointOfInterest.func_218261_f(), pos));
        if (removeTotem) {
            totemPositions.remove(pos);
        }
    }

    @Deprecated
    public static void removeTotem(Collection<PointOfInterest> pois, BlockPos pos) {
        TotemHelper.removeTotem(pois, pos, true);
    }

    @Nullable
    public static BlockPos getTotemPosition(Collection<PointOfInterest> pois) {
        for (PointOfInterest pointOfInterest : pois) {
            if (!totemPositions.containsKey(pointOfInterest.func_218261_f())) continue;
            return totemPositions.get(pointOfInterest.func_218261_f());
        }
        return null;
    }

    @Nullable
    public static BlockPos getTotemPosition(BlockPos pos) {
        return totemPositions.get(pos);
    }

    public static ITextComponent forceFactionCommand(IFaction<?> faction, ServerPlayerEntity player) {
        List pointOfInterests = ((ServerWorld)player.func_130014_f_()).func_217443_B().func_219146_b(point -> true, player.func_180425_c(), 25, PointOfInterestManager.Status.ANY).sorted((point1, point2) -> (int)(new Vec3d((Vec3i)point1.func_218261_f()).func_72438_d(new Vec3d((Vec3i)player.func_180425_c())) - new Vec3d((Vec3i)point2.func_218261_f()).func_72438_d(new Vec3d((Vec3i)player.func_180425_c())))).collect(Collectors.toList());
        if (pointOfInterests.stream().noneMatch(point -> totemPositions.containsKey(point.func_218261_f()))) {
            return new TranslationTextComponent("command.vampirism.test.village.no_village", new Object[0]);
        }
        TileEntity te = player.func_130014_f_().func_175625_s(totemPositions.get(((PointOfInterest)pointOfInterests.get(0)).func_218261_f()));
        if (!(te instanceof TotemTileEntity)) {
            LOGGER.warn("TileEntity at {} is no TotemTileEntity", (Object)totemPositions.get(((PointOfInterest)pointOfInterests.get(0)).func_218261_f()));
            return new StringTextComponent("");
        }
        TotemTileEntity tile = (TotemTileEntity)te;
        tile.setForcedFaction(faction);
        return new TranslationTextComponent("command.vampirism.test.village.success", new Object[]{faction == null ? "none" : faction.getName()});
    }

    public static Set<PointOfInterest> getVillagePointsOfInterest(ServerWorld world, BlockPos pos) {
        PointOfInterestManager manager = world.func_217443_B();
        HashSet finished = Sets.newHashSet();
        Set points = manager.func_219146_b(type -> !(type instanceof FactionPointOfInterestType), pos, 50, PointOfInterestManager.Status.ANY).collect(Collectors.toSet());
        while (!points.isEmpty()) {
            List<Stream> list = points.stream().map(pointOfInterest -> manager.func_219146_b(type -> !(type instanceof FactionPointOfInterestType), pointOfInterest.func_218261_f(), 40, PointOfInterestManager.Status.ANY)).collect(Collectors.toList());
            points.clear();
            list.forEach(stream -> stream.forEach(point -> {
                if (!finished.contains(point) && point.func_218261_f().func_218141_a((Vec3i)pos, (double)((Integer)VampirismConfig.BALANCE.viMaxTotemRadius.get()).intValue())) {
                    points.add(point);
                }
                finished.add(point);
            }));
        }
        return finished;
    }

    public static int isVillage(Map<Integer, Integer> stats, boolean hasInteraction) {
        int status = 0;
        if (stats.get(1) >= 4) {
            ++status;
        }
        if (stats.get(2) >= 2) {
            status += 2;
        }
        if (hasInteraction || stats.get(4) >= 4) {
            status += 4;
        }
        return status;
    }

    public static int isVillage(Set<PointOfInterest> pointOfInterests, World world, BlockPos totemPos, boolean hasInteraction) {
        if (Structures.field_215157_o.func_175796_a((IWorld)world, totemPos)) {
            return 7;
        }
        return TotemHelper.isVillage(TotemHelper.getVillageStats(pointOfInterests, world), hasInteraction);
    }

    public static Map<Integer, Integer> getVillageStats(Set<PointOfInterest> pointOfInterests, final World world) {
        final Map poiTCounts = pointOfInterests.stream().map(PointOfInterest::func_218260_g).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        final AxisAlignedBB area = TotemHelper.getAABBAroundPOIs(pointOfInterests);
        return new HashMap<Integer, Integer>(){
            {
                this.put(1, poiTCounts.getOrDefault(PointOfInterestType.field_221069_q, 0L).intValue());
                this.put(2, (int)poiTCounts.entrySet().stream().filter(entry -> entry.getKey() != PointOfInterestType.field_221069_q).mapToLong(Map.Entry::getValue).sum());
                this.put(4, area == null ? 0 : world.func_217357_a(VillagerEntity.class, area).size());
            }
        };
    }

    public static void updateVampireBoundingBox(@Nonnull Dimension dimension, @Nonnull BlockPos totemPos, @Nullable AxisAlignedBB box) {
        Map map = vampireVillages.computeIfAbsent(dimension, dimension1 -> new HashMap());
        if (box == null) {
            map.remove(totemPos);
        } else {
            map.put(totemPos, UtilLib.AABBtoMB(box));
        }
    }

    @Nullable
    public static AxisAlignedBB getAABBAroundPOIs(@Nonnull Set<PointOfInterest> pois) {
        return pois.stream().map(poi -> new AxisAlignedBB(poi.func_218261_f()).func_186662_g(25.0)).reduce(AxisAlignedBB::func_111270_a).orElse(null);
    }
}

