/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.tileentity;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.CaptureEntityEntry;
import de.teamlapen.vampirism.api.entity.IAggressiveVillager;
import de.teamlapen.vampirism.api.entity.ICaptureIgnore;
import de.teamlapen.vampirism.api.entity.ITaskMasterEntity;
import de.teamlapen.vampirism.api.entity.IVillageCaptureEntity;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.event.VampirismVillageEvent;
import de.teamlapen.vampirism.api.world.ICaptureAttributes;
import de.teamlapen.vampirism.api.world.ITotem;
import de.teamlapen.vampirism.blocks.TotemBaseBlock;
import de.teamlapen.vampirism.blocks.TotemTopBlock;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.core.ModStats;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.entity.FactionVillagerProfession;
import de.teamlapen.vampirism.entity.VampirismEntity;
import de.teamlapen.vampirism.entity.converted.ConvertedVillagerEntity;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.hunter.AggressiveVillagerEntity;
import de.teamlapen.vampirism.entity.hunter.DummyHunterTrainerEntity;
import de.teamlapen.vampirism.entity.hunter.HunterBaseEntity;
import de.teamlapen.vampirism.entity.hunter.HunterTrainerEntity;
import de.teamlapen.vampirism.entity.vampire.VampireBaseEntity;
import de.teamlapen.vampirism.particle.GenericParticleData;
import de.teamlapen.vampirism.potion.PotionSanguinare;
import de.teamlapen.vampirism.potion.PotionSanguinareEffect;
import de.teamlapen.vampirism.tileentity.TotemHelper;
import de.teamlapen.vampirism.util.ModEventFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.village.PointOfInterest;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.BossInfo;
import net.minecraft.world.IWorld;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.structure.Structures;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
public class TotemTileEntity
extends TileEntity
implements ITickableTileEntity,
ITotem {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Random RNG = new Random();
    private static final ResourceLocation nonFactionTotem = new ResourceLocation("none");
    private boolean isComplete;
    private boolean isInsideVillage;
    private boolean isDisabled;
    @Nonnull
    private Set<PointOfInterest> village = Sets.newHashSet();
    @Nullable
    private IFaction<?> controllingFaction;
    @Nullable
    private IFaction<?> capturingFaction;
    @Nullable
    private AxisAlignedBB villageArea;
    @Nullable
    private AxisAlignedBB villageAreaReduced;
    @Nullable
    private IFaction<?> forcedFaction;
    private int forcedFactionTimer;
    private boolean forceVillageUpdate;
    private CAPTURE_PHASE phase;
    private int captureTimer;
    private int captureAbortTimer;
    private int defenderMax;
    private int captureForceTargetTimer;
    @OnlyIn(value=Dist.CLIENT)
    private long beamRenderCounter;
    @OnlyIn(value=Dist.CLIENT)
    private float beamRenderScale;
    private float[] baseColors = DyeColor.WHITE.func_193349_f();
    private float[] progressColor = DyeColor.WHITE.func_193349_f();
    private final ServerBossInfo captureInfo = new ServerBossInfo((ITextComponent)new TranslationTextComponent("text.vampirism.village.bossinfo.capture", new Object[0]), BossInfo.Color.YELLOW, BossInfo.Overlay.PROGRESS);

    @Deprecated
    public static boolean isInsideVampireAreaCached(Dimension dimension, BlockPos blockPos) {
        return TotemHelper.isInsideVampireAreaCached(dimension, blockPos);
    }

    @Deprecated
    public static void clearCacheForDimension(Dimension dimension) {
        TotemHelper.clearCacheForDimension(dimension);
    }

    @Deprecated
    public static ITextComponent forceFactionCommand(IFaction<?> faction, ServerPlayerEntity player) {
        return TotemHelper.forceFactionCommand(faction, player);
    }

    public TotemTileEntity() {
        super(ModTiles.totem);
    }

    public boolean canPlayerRemoveBlock(PlayerEntity player) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        if (!player.func_70089_S()) {
            return false;
        }
        IPlayableFaction<? extends IFactionPlayer<?>> faction = FactionPlayerHandler.get(player).getCurrentFaction();
        if (faction == this.controllingFaction) {
            if (this.capturingFaction == null) {
                return true;
            }
            player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.village.totem_destroy.fail_other_capturing", new Object[0]), true);
            return false;
        }
        if (faction == this.capturingFaction) {
            if (this.controllingFaction == null) {
                return true;
            }
            player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.village.totem_destroy.fail_other_faction", new Object[0]), true);
            return false;
        }
        if (this.capturingFaction != null || this.controllingFaction != null) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.village.totem_destroy.fail_other_faction", new Object[0]), true);
            return false;
        }
        return true;
    }

    public void func_70296_d() {
        if (this.field_145850_b != null) {
            super.func_70296_d();
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
            if (!this.village.isEmpty()) {
                if (this.controllingFaction == VReference.VAMPIRE_FACTION) {
                    TotemHelper.addVampireVillage(this.field_145850_b.field_73011_w, this.field_174879_c, this.getVillageArea());
                } else {
                    TotemHelper.removeVampireVillage(this.field_145850_b.field_73011_w, this.field_174879_c);
                }
            }
        }
    }

    public int getSize() {
        return this.village.size();
    }

    public static void makeAgressive(VillagerEntity villager) {
        AggressiveVillagerEntity hunter = AggressiveVillagerEntity.makeHunter(villager);
        villager.func_130014_f_().func_217376_c((Entity)hunter);
        villager.func_70106_y();
    }

    private void abortCapture(boolean notifyPlayer) {
        this.setCapturingFaction(null);
        this.forceVillageUpdate = true;
        this.informEntitiesAboutCaptureStop();
        if (notifyPlayer) {
            this.notifyNearbyPlayers((ITextComponent)new TranslationTextComponent("text.vampirism.village.village_capture_aborted", new Object[0]));
        }
        this.updateBossinfoPlayers(null);
        this.defenderMax = 0;
        this.func_70296_d();
    }

    public void func_145843_s() {
        TotemHelper.removeVampireVillage(this.field_145850_b.field_73011_w, this.field_174879_c);
        TotemHelper.removeTotem(this.village, this.field_174879_c, true);
        if (this.capturingFaction != null) {
            this.abortCapture(false);
        } else {
            this.updateBossinfoPlayers(null);
        }
        super.func_145843_s();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getCaptureProgress() {
        return this.capturingFaction == null ? 0 : (this.phase == CAPTURE_PHASE.PHASE_2 ? 80 : (int)((float)this.captureTimer / (float)((Integer)VampirismConfig.BALANCE.viPhase1Duration.get()).intValue() * 80.0f));
    }

    private void completeCapture(boolean notifyPlayer, boolean fullConvert) {
        this.informEntitiesAboutCaptureStop();
        if (!this.field_145850_b.field_72995_K) {
            this.updateCreaturesOnCapture(fullConvert);
        }
        if (this.controllingFaction != null) {
            for (PlayerEntity p : this.field_145850_b.func_217369_A()) {
                if (!this.getVillageArea().func_72318_a(p.func_213303_ch())) continue;
                FactionPlayerHandler.getOpt(p).filter(fph -> fph.getCurrentFaction() == this.capturingFaction).ifPresent(fph -> fph.getPlayer().func_195066_a(ModStats.capture_village));
            }
        }
        this.setControllingFaction(this.capturingFaction);
        this.setCapturingFaction(null);
        if (notifyPlayer) {
            assert (this.controllingFaction != null);
            this.notifyNearbyPlayers((ITextComponent)new TranslationTextComponent("text.vampirism.village.village_captured_by", new Object[]{this.controllingFaction.getNamePlural()}));
        }
        this.updateBossinfoPlayers(null);
        this.func_70296_d();
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189517_E_());
    }

    public void handleUpdateTag(CompoundNBT tag) {
        this.func_145839_a(tag);
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74757_a("isDisabled", this.isDisabled);
        compound.func_74757_a("isComplete", this.isComplete);
        compound.func_74757_a("isInsideVillage", this.isInsideVillage);
        if (this.controllingFaction != null) {
            compound.func_74778_a("controllingFaction", this.controllingFaction.getID().toString());
        }
        if (this.capturingFaction != null) {
            compound.func_74778_a("capturingFaction", this.capturingFaction.getID().toString());
            compound.func_74768_a("captureTimer", this.captureTimer);
            compound.func_74768_a("captureAbortTimer", this.captureAbortTimer);
            compound.func_74778_a("phase", this.phase.name());
            if (this.phase == CAPTURE_PHASE.PHASE_2) {
                compound.func_74768_a("defenderMax", this.defenderMax);
            }
        }
        if (!this.village.isEmpty()) {
            compound.func_74783_a("villageArea", UtilLib.bbToInt(this.getVillageArea()));
        }
        return super.func_189515_b(compound);
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.isDisabled = compound.func_74767_n("isDisabled");
        this.isComplete = compound.func_74767_n("isComplete");
        this.isInsideVillage = compound.func_74767_n("isInsideVillage");
        if (compound.func_74764_b("controllingFaction")) {
            this.setControllingFaction(VampirismAPI.factionRegistry().getFactionByID(new ResourceLocation(compound.func_74779_i("controllingFaction"))));
        } else {
            this.setControllingFaction(null);
        }
        if (compound.func_74764_b("capturingFaction")) {
            this.setCapturingFaction(VampirismAPI.factionRegistry().getFactionByID(new ResourceLocation(compound.func_74779_i("capturingFaction"))));
            this.captureTimer = compound.func_74762_e("captureTimer");
            this.captureAbortTimer = compound.func_74762_e("captureabortTimer");
            this.phase = CAPTURE_PHASE.valueOf(compound.func_74779_i("phase"));
            if (this.phase == CAPTURE_PHASE.PHASE_2 && compound.func_74764_b("defenderMax")) {
                this.defenderMax = compound.func_74762_e("defenderMax");
                this.setupPhase2();
            }
        } else {
            this.setCapturingFaction(null);
        }
        if (this.field_145850_b != null && compound.func_74764_b("villageArea")) {
            if (VReference.VAMPIRE_FACTION.equals(this.controllingFaction)) {
                TotemHelper.addVampireVillage(this.field_145850_b.field_73011_w, this.field_174879_c, UtilLib.intToBB(compound.func_74759_k("villageArea")));
            } else {
                TotemHelper.removeVampireVillage(this.field_145850_b.field_73011_w, this.field_174879_c);
            }
        }
        this.forceVillageUpdate = true;
    }

    public void updateTileStatus() {
        Set<PointOfInterest> points;
        Block b = this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
        this.isComplete = b instanceof TotemTopBlock && this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()).func_177230_c().equals((Object)ModBlocks.totem_base);
        if (!this.isComplete) {
            return;
        }
        ResourceLocation blockFaction = ((TotemTopBlock)b).faction;
        if (!blockFaction.equals((Object)(this.controllingFaction == null ? nonFactionTotem : this.controllingFaction.getID()))) {
            this.forcedFaction = VampirismAPI.factionRegistry().getFactionByID(blockFaction);
        }
        if (!(this.isInsideVillage = !(points = TotemHelper.getVillagePointsOfInterest((ServerWorld)this.field_145850_b, this.field_174879_c)).isEmpty())) {
            this.village = Collections.emptySet();
            if (this.controllingFaction != null) {
                this.setControllingFaction(null);
            }
        } else if (7 != TotemHelper.isVillage(points, this.field_145850_b, this.field_174879_c, this.controllingFaction != null || this.capturingFaction != null)) {
            this.isInsideVillage = false;
            this.village = Collections.emptySet();
            if (this.controllingFaction != null) {
                this.setControllingFaction(null);
            }
        } else {
            this.isDisabled = !TotemHelper.addTotem(this.field_145850_b, points, this.field_174879_c);
            if (!this.isDisabled) {
                this.village.removeIf(points::contains);
                TotemHelper.removeTotem(this.village, this.field_174879_c, false);
                this.village = points;
            } else {
                this.village = Collections.emptySet();
            }
        }
        this.func_70296_d();
    }

    private void spawnVillagerDefault(boolean poisonousBlood) {
        VillagerEntity newVillager = (VillagerEntity)EntityType.field_200756_av.func_200721_a(this.field_145850_b);
        ExtendedCreature.getSafe((Entity)newVillager).ifPresent(e -> e.setPoisonousBlood(poisonousBlood));
        newVillager = ModEventFactory.fireSpawnNewVillagerEvent(this, null, newVillager, false, poisonousBlood);
        this.spawnEntity((MobEntity)newVillager);
    }

    public void setForcedFaction(@Nullable IFaction<?> faction) {
        this.forcedFaction = faction;
        this.forcedFactionTimer = 5;
        this.func_70296_d();
    }

    private void makeAgressive() {
        if (!this.field_145850_b.field_72995_K) {
            List villagerEntities = this.field_145850_b.func_217357_a(VillagerEntity.class, this.getVillageArea());
            for (VillagerEntity villager : villagerEntities) {
                IVillageCaptureEntity entity = ModEventFactory.fireMakeAggressive(this, villager);
                if (entity == null) {
                    if (!VReference.VAMPIRE_FACTION.equals(this.capturingFaction) || villager instanceof IFactionEntity || villager.func_70874_b() < 0 || RNG.nextInt(3) != 0) continue;
                    TotemTileEntity.makeAgressive(villager);
                    continue;
                }
                this.field_145850_b.func_217376_c((Entity)entity);
            }
        }
    }

    private boolean checkTileStatus() {
        return this.isComplete && this.isInsideVillage && !this.isDisabled && !this.village.isEmpty();
    }

    public void func_73660_a() {
        if (this.field_145850_b == null) {
            return;
        }
        long time = this.field_145850_b.func_82737_E();
        if (this.field_145850_b.field_72995_K) {
            if (time % 10L == 7L && this.controllingFaction != null) {
                ModParticles.spawnParticlesClient(this.field_145850_b, new GenericParticleData(ModParticles.generic, new ResourceLocation("minecraft", "generic_4"), 20, this.controllingFaction.getColor().getRGB(), 0.2f), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), 3, 30.0, this.field_145850_b.field_73012_v);
            }
        } else {
            if (this.isDisabled) {
                this.field_145850_b.func_175655_b(this.field_174879_c, true);
                if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()).func_177230_c() instanceof TotemBaseBlock) {
                    this.field_145850_b.func_175655_b(this.field_174879_c.func_177977_b(), true);
                }
            }
            if (time % 20L == 0L) {
                this.updateTileStatus();
            }
            if (!this.checkTileStatus()) {
                if (!this.isInsideVillage && this.capturingFaction != null) {
                    this.abortCapture(false);
                }
                return;
            }
            if (this.forcedFaction != null) {
                if (this.forcedFactionTimer > 0) {
                    if (this.forcedFactionTimer == 1) {
                        this.abortCapture(false);
                    }
                    --this.forcedFactionTimer;
                } else {
                    this.setCapturingFaction(this.forcedFaction);
                    this.completeCapture(false, true);
                    this.forcedFaction = null;
                }
            }
            if (this.forceVillageUpdate) {
                this.updateTileStatus();
                this.forceVillageUpdate = false;
            }
            if (time % 12000L == 0L) {
                this.updateVillageArea();
            }
            if (this.capturingFaction != null) {
                if (time % 40L == 0L) {
                    List entities = this.field_145850_b.func_217357_a(LivingEntity.class, this.getVillageArea());
                    this.updateBossinfoPlayers(entities);
                    int attacker = 0;
                    int attackerPlayer = 0;
                    int defender = 0;
                    int defenderPlayer = 0;
                    int neutral = 0;
                    float attackerStrength = 0.0f;
                    float defenderStrength = 0.0f;
                    CaptureInfo captureInfo = new CaptureInfo(this);
                    for (LivingEntity entity2 : entities) {
                        IFaction faction = VampirismAPI.factionRegistry().getFaction((Entity)entity2);
                        if (faction == null || entity2 instanceof ICaptureIgnore) continue;
                        if (this.capturingFaction.equals(faction)) {
                            ++attacker;
                            attackerStrength += this.getStrength(entity2);
                            if (entity2 instanceof PlayerEntity) {
                                ++attackerPlayer;
                            }
                            if (!(entity2 instanceof IVillageCaptureEntity)) continue;
                            ((IVillageCaptureEntity)entity2).attackVillage(captureInfo);
                            continue;
                        }
                        if (faction.equals(this.controllingFaction)) {
                            ++defender;
                            defenderStrength += this.getStrength(entity2);
                            if (entity2 instanceof PlayerEntity) {
                                ++defenderPlayer;
                            }
                            if (!(entity2 instanceof IVillageCaptureEntity)) continue;
                            ((IVillageCaptureEntity)entity2).defendVillage(captureInfo);
                            continue;
                        }
                        ++neutral;
                    }
                    if (attackerPlayer == 0) {
                        ++this.captureAbortTimer;
                    } else {
                        this.captureAbortTimer = 0;
                        ++this.captureTimer;
                        if (this.phase == CAPTURE_PHASE.PHASE_2) {
                            ++this.captureForceTargetTimer;
                        }
                    }
                    if (this.captureAbortTimer > 7) {
                        this.abortCapture(true);
                    } else {
                        switch (this.phase) {
                            case PHASE_1_NEUTRAL: {
                                if (this.captureTimer < (Integer)VampirismConfig.BALANCE.viPhase1Duration.get()) break;
                                this.captureTimer = 1;
                                this.setupPhase2();
                                this.func_70296_d();
                                break;
                            }
                            case PHASE_1_OPPOSITE: {
                                if (this.captureTimer >= (Integer)VampirismConfig.BALANCE.viPhase1Duration.get()) {
                                    this.captureTimer = 1;
                                    this.setupPhase2();
                                    this.func_70296_d();
                                    this.notifyNearbyPlayers((ITextComponent)new TranslationTextComponent("text.vampirism.village.almost_captured", new Object[]{defender}));
                                    break;
                                }
                                if (this.captureTimer % 2 != 0) break;
                                if (attackerStrength * 1.1f > defenderStrength) {
                                    this.spawnCaptureEntity(this.controllingFaction);
                                    break;
                                }
                                if (!(defenderStrength * 1.1f > attackerStrength)) break;
                                this.spawnCaptureEntity(this.capturingFaction);
                                break;
                            }
                            case PHASE_2: {
                                if (defender == 0) {
                                    ++this.captureTimer;
                                    if (this.captureTimer <= 4) break;
                                    this.completeCapture(true, false);
                                    break;
                                }
                                this.captureTimer = 1;
                                break;
                            }
                        }
                        this.handleBossBar(defender);
                    }
                }
            } else {
                if (this.controllingFaction != null && time % 512L == 0L) {
                    List guards;
                    int defenderNumMax;
                    int max;
                    int beds = (int)((ServerWorld)this.field_145850_b).func_217443_B().func_219146_b(pointOfInterestType -> pointOfInterestType.equals(PointOfInterestType.field_221069_q), this.field_174879_c, (int)Math.sqrt(Math.pow(this.getVillageArea().func_216364_b(), 2.0) + Math.pow(this.getVillageArea().func_216362_d(), 2.0)) / 2, PointOfInterestManager.Status.ANY).count();
                    boolean spawnTaskMaster = RNG.nextInt(6) == 0;
                    int villager = this.field_145850_b.func_217357_a(VillagerEntity.class, this.getVillageArea().func_186662_g(20.0)).size();
                    if (villager < (max = Math.min(beds, (Integer)VampirismConfig.BALANCE.viMaxVillagerRespawn.get()))) {
                        boolean isConverted;
                        boolean bl = isConverted = this.controllingFaction == VReference.VAMPIRE_FACTION && RNG.nextBoolean();
                        if (isConverted) {
                            this.spawnVillagerVampire();
                        } else {
                            this.spawnVillagerDefault(this.controllingFaction == VReference.HUNTER_FACTION);
                        }
                    } else {
                        spawnTaskMaster = true;
                    }
                    if (spawnTaskMaster && this.field_145850_b.func_175647_a(VampirismEntity.class, this.getVillageArea(), entity -> entity instanceof ITaskMasterEntity).isEmpty()) {
                        this.spawnTaskMaster();
                    }
                    if ((defenderNumMax = Math.min(6, this.village.size() / 5)) > (guards = this.field_145850_b.func_217357_a(this.controllingFaction.getVillageData().getGuardSuperClass(), this.getVillageArea())).size()) {
                        EntityType<? extends MobEntity> entityType = this.getCaptureEntityForFaction(this.controllingFaction);
                        this.spawnEntity((MobEntity)entityType.func_200721_a(this.field_145850_b));
                    }
                }
                if (this.controllingFaction != null && ((Boolean)VampirismConfig.BALANCE.viReplaceBlocks.get()).booleanValue() && time % 20L == 0L) {
                    int x = (int)(this.getVillageArea().field_72340_a + (double)RNG.nextInt((int)(this.getVillageArea().field_72336_d - this.getVillageArea().field_72340_a)));
                    int z = (int)(this.getVillageArea().field_72339_c + (double)RNG.nextInt((int)(this.getVillageArea().field_72334_f - this.getVillageArea().field_72339_c)));
                    BlockPos pos = new BlockPos(x, this.field_145850_b.func_205770_a(Heightmap.Type.WORLD_SURFACE, new BlockPos(x, 0, z)).func_177956_o() - 1, z);
                    BlockState b = this.field_145850_b.func_180495_p(pos);
                    boolean flag = false;
                    if (VReference.VAMPIRE_FACTION.equals(this.controllingFaction)) {
                        if (!(this.field_145850_b.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BushBlock) && b.func_177230_c() == this.field_145850_b.func_226691_t_(pos).func_203944_q().func_204108_a().func_177230_c() && b.func_177230_c() != Blocks.field_150354_m) {
                            this.field_145850_b.func_217377_a(pos.func_177984_a(), false);
                            this.field_145850_b.func_175656_a(pos, ModBlocks.cursed_earth.func_176223_P());
                            if (this.field_145850_b.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_196804_gh) {
                                this.field_145850_b.func_217377_a(pos.func_177984_a(), false);
                                flag = true;
                            }
                        }
                    } else if (this.controllingFaction == VReference.HUNTER_FACTION && b.func_177230_c() == ModBlocks.cursed_earth) {
                        this.field_145850_b.func_175656_a(pos, this.field_145850_b.func_226691_t_(pos).func_203944_q().func_204108_a());
                        flag = true;
                    }
                    if (!flag) {
                        ModEventFactory.fireReplaceVillageBlockEvent(this, b, pos);
                    }
                }
            }
        }
    }

    private void setControllingFaction(@Nullable IFaction<?> faction) {
        this.controllingFaction = faction;
        float[] fArray = this.baseColors = faction != null ? faction.getColor().getColorComponents(null) : DyeColor.WHITE.func_193349_f();
        if (this.field_145850_b != null) {
            boolean crafted;
            BlockState oldBlockState = this.func_195044_w();
            Block b = oldBlockState.func_177230_c();
            boolean bl = crafted = b instanceof TotemTopBlock && ((TotemTopBlock)b).isCrafted();
            BlockState newBlockState = (faction == null ? (crafted ? ModBlocks.totem_top_crafted : ModBlocks.totem_top) : (crafted ? (Block)faction.getVillageData().getTotemTopBlock().getRight() : (Block)faction.getVillageData().getTotemTopBlock().getLeft())).func_176223_P();
            try {
                this.field_145850_b.func_180501_a(this.field_174879_c, newBlockState, 55);
            }
            catch (IllegalStateException e) {
                LOGGER.error("Setting blockstate from {} to {}", (Object)oldBlockState, (Object)newBlockState);
                LOGGER.error("Failed to set totem blockstate", (Throwable)e);
            }
        }
    }

    private void setCapturingFaction(@Nullable IFaction<?> faction) {
        this.capturingFaction = faction;
        this.progressColor = faction != null ? faction.getColor().getColorComponents(null) : DyeColor.WHITE.func_193349_f();
    }

    @Override
    @Nonnull
    public AxisAlignedBB getVillageArea() {
        if (this.villageArea == null) {
            this.updateVillageArea();
        }
        return this.villageArea;
    }

    @Override
    @Nonnull
    public AxisAlignedBB getVillageAreaReduced() {
        if (this.villageAreaReduced == null) {
            this.updateVillageArea();
        }
        return this.villageAreaReduced;
    }

    private boolean capturePreconditions(@Nullable IFaction<?> faction, PlayerEntity player) {
        if (faction == null) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.village.no_faction", new Object[0]), true);
            return false;
        }
        if (this.capturingFaction != null) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.village.capturing_in_progress", new Object[0]), true);
            return false;
        }
        if (faction.equals(this.controllingFaction)) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.village.same_faction", new Object[0]), true);
            return false;
        }
        if (!this.isInsideVillage) {
            if (this.getControllingFaction() != null) {
                this.setControllingFaction(null);
                this.func_70296_d();
            }
            Map<Integer, Integer> stats = TotemHelper.getVillageStats(TotemHelper.getVillagePointsOfInterest((ServerWorld)this.field_145850_b, this.field_174879_c), this.field_145850_b);
            int status = TotemHelper.isVillage(stats, this.controllingFaction != null || this.capturingFaction != null);
            TranslationTextComponent text = new TranslationTextComponent("text.vampirism.village.missing_components", new Object[0]);
            if ((status & 1) == 0) {
                text.func_150258_a("\n  - ");
                text.func_150257_a((ITextComponent)new TranslationTextComponent("text.vampirism.village.missing_components.home", new Object[0]));
                text.func_150258_a(" " + stats.get(1) + "/" + 4);
            }
            if ((status & 2) == 0) {
                text.func_150258_a("\n  - ");
                text.func_150257_a((ITextComponent)new TranslationTextComponent("text.vampirism.village.missing_components.workstations", new Object[0]));
                text.func_150258_a(" " + stats.get(2) + "/" + 2);
            }
            if ((status & 4) == 0) {
                text.func_150258_a("\n  - ");
                text.func_150257_a((ITextComponent)new TranslationTextComponent("text.vampirism.village.missing_components.villager", new Object[0]));
                text.func_150258_a(" " + stats.get(4) + "/" + 4);
            }
            player.func_146105_b((ITextComponent)text, false);
            return false;
        }
        if (this.isDisabled) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.village.othertotem", new Object[0]), true);
            return false;
        }
        VampirismVillageEvent.InitiateCapture event = new VampirismVillageEvent.InitiateCapture(this, faction);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult().equals((Object)Event.Result.DENY)) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent(event.getMessage(), new Object[0]), true);
            return false;
        }
        return true;
    }

    private void updateVillageArea() {
        StructureStart start;
        if (this.villageArea != null && this.villageAreaReduced != null && this.village.stream().allMatch(point -> this.villageAreaReduced.func_72318_a(new Vec3d((Vec3i)point.func_218261_f())))) {
            return;
        }
        AxisAlignedBB totem = TotemHelper.getAABBAroundPOIs(this.village);
        if (Structures.field_215157_o.func_175796_a((IWorld)this.field_145850_b, this.field_174879_c) && (start = Structures.field_215157_o.func_202364_a((IWorld)this.field_145850_b, this.field_174879_c, false)) != StructureStart.field_214630_a) {
            totem = UtilLib.MBtoAABB(start.func_75071_a());
        }
        assert (totem != null);
        this.villageArea = totem;
        this.villageAreaReduced = totem.func_72314_b(-30.0, -10.0, -30.0);
    }

    public void initiateCapture(PlayerEntity player) {
        this.updateTileStatus();
        if (!player.func_70089_S()) {
            return;
        }
        IPlayableFaction<IFactionPlayer<?>> faction = FactionPlayerHandler.get(player).getCurrentFaction();
        if (!this.capturePreconditions(faction, player)) {
            return;
        }
        this.forceVillageUpdate = true;
        this.captureAbortTimer = 0;
        this.captureTimer = 0;
        this.captureForceTargetTimer = 0;
        this.setCapturingFaction(faction);
        this.captureInfo.func_186739_a((ITextComponent)new TranslationTextComponent("text.vampirism.village.bossinfo.capture", new Object[0]));
        this.captureInfo.func_186745_a(BossInfo.Color.YELLOW);
        this.captureInfo.func_186735_a(0.0f);
        this.defenderMax = 0;
        if (this.controllingFaction == null) {
            this.phase = CAPTURE_PHASE.PHASE_1_NEUTRAL;
            this.notifyNearbyPlayers((ITextComponent)new TranslationTextComponent("text.vampirism.village.neutral_village_under_attack", new Object[]{faction.getNamePlural()}));
        } else {
            this.phase = CAPTURE_PHASE.PHASE_1_OPPOSITE;
            this.notifyNearbyPlayers((ITextComponent)new TranslationTextComponent("text.vampirism.village.faction_village_under_attack", new Object[]{this.controllingFaction.getNamePlural(), faction.getNamePlural()}));
        }
        this.func_70296_d();
        this.makeAgressive();
    }

    private void updateBossinfoPlayers(@Nullable List<LivingEntity> includedPlayerEntities) {
        HashSet oldList = new HashSet(this.captureInfo.func_186757_c());
        if (includedPlayerEntities != null) {
            for (LivingEntity entity : includedPlayerEntities) {
                if (!(entity instanceof ServerPlayerEntity) || oldList.remove(entity)) continue;
                this.captureInfo.func_186760_a((ServerPlayerEntity)entity);
            }
        }
        for (ServerPlayerEntity player : oldList) {
            this.captureInfo.func_186761_b(player);
        }
    }

    private void informEntitiesAboutCaptureStop() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        List list = this.field_145850_b.func_217357_a(CreatureEntity.class, this.getVillageArea());
        for (CreatureEntity e : list) {
            if (!(e instanceof IVillageCaptureEntity)) continue;
            ((IVillageCaptureEntity)e).stopVillageAttackDefense();
        }
    }

    private void spawnCaptureEntity(@Nullable IFaction<?> faction) {
        if (faction == null) {
            return;
        }
        EntityType<? extends MobEntity> entityType = this.getCaptureEntityForFaction(faction);
        if (entityType == null) {
            LOGGER.warn("No village capture entity registered for {}", faction);
            return;
        }
        MobEntity entity = (MobEntity)entityType.func_200721_a(this.field_145850_b);
        if (entity instanceof VampireBaseEntity) {
            ((VampireBaseEntity)entity).setSpawnRestriction(VampireBaseEntity.SpawnRestriction.SIMPLE);
        }
        List players = this.field_145850_b.func_217369_A();
        players.removeIf(PlayerEntity::func_175149_v);
        if (entity != null && !UtilLib.spawnEntityInWorld(this.field_145850_b, this.getVillageAreaReduced(), (Entity)entity, 50, (List<? extends LivingEntity>)players, SpawnReason.EVENT)) {
            entity.func_70106_y();
            entity = null;
        }
        if (entity instanceof IVillageCaptureEntity) {
            if (faction == this.controllingFaction) {
                ((IVillageCaptureEntity)entity).defendVillage(new CaptureInfo(this));
            } else {
                ((IVillageCaptureEntity)entity).attackVillage(new CaptureInfo(this));
            }
        } else if (entity != null) {
            LOGGER.warn("Creature registered for village capture does not implement IVillageCaptureEntity ({})", (Object)entityType.getRegistryName());
        } else {
            LOGGER.info("Failed to spawn capture creature");
        }
    }

    private void setupPhase2() {
        if (this.phase != CAPTURE_PHASE.PHASE_2) {
            this.phase = CAPTURE_PHASE.PHASE_2;
        }
        this.captureInfo.func_186739_a((ITextComponent)new TranslationTextComponent("text.vampirism.village.defender_remaining", new Object[0]));
        this.captureInfo.func_186745_a(BossInfo.Color.WHITE);
    }

    private void handleBossBar(int defenderLeft) {
        if (this.phase == CAPTURE_PHASE.PHASE_1_NEUTRAL || this.phase == CAPTURE_PHASE.PHASE_1_OPPOSITE) {
            this.captureInfo.func_186735_a((float)this.captureTimer / (float)((Integer)VampirismConfig.BALANCE.viPhase1Duration.get()).intValue());
        } else if (this.phase == CAPTURE_PHASE.PHASE_2) {
            if (this.defenderMax != 0) {
                if (defenderLeft > this.defenderMax) {
                    this.defenderMax = defenderLeft;
                }
                this.captureInfo.func_186735_a((float)defenderLeft / (float)this.defenderMax);
            } else {
                this.defenderMax = defenderLeft;
                this.setupPhase2();
            }
        }
    }

    @Override
    @Nullable
    public EntityType<? extends MobEntity> getCaptureEntityForFaction(@Nonnull IFaction<?> faction) {
        return ((CaptureEntityEntry)WeightedRandom.func_76271_a((Random)RNG, faction.getVillageData().getCaptureEntries())).getEntity();
    }

    private void spawnVillagerReplace(MobEntity oldEntity, boolean poisonousBlood) {
        VillagerEntity newVillager = (VillagerEntity)EntityType.field_200756_av.func_200721_a(this.field_145850_b);
        ExtendedCreature.getSafe((Entity)newVillager).ifPresent(e -> e.setPoisonousBlood(poisonousBlood));
        if (oldEntity instanceof VillagerEntity) {
            newVillager.func_213390_a(oldEntity.func_213384_dI(), (int)oldEntity.func_213391_dJ());
        }
        newVillager = ModEventFactory.fireSpawnNewVillagerEvent(this, oldEntity, newVillager, true, poisonousBlood);
        this.spawnEntity((MobEntity)newVillager, oldEntity, true, true);
    }

    private void spawnVillagerReplaceForced(MobEntity oldEntity, boolean poisonousBlood) {
        VillagerEntity newVillager = (VillagerEntity)EntityType.field_200756_av.func_200721_a(this.field_145850_b);
        ExtendedCreature.getSafe((Entity)newVillager).ifPresent(e -> e.setPoisonousBlood(poisonousBlood));
        newVillager.func_82149_j((Entity)oldEntity);
        if (oldEntity instanceof VillagerEntity) {
            newVillager.func_213390_a(oldEntity.func_213384_dI(), (int)oldEntity.func_213391_dJ());
        }
        newVillager = ModEventFactory.fireSpawnNewVillagerEvent(this, oldEntity, newVillager, true, poisonousBlood);
        oldEntity.func_70106_y();
        this.field_145850_b.func_217376_c((Entity)newVillager);
    }

    private void spawnVillagerVampire() {
        this.spawnEntity((MobEntity)ModEntities.villager_converted.func_200721_a(this.field_145850_b));
    }

    private void updateCreaturesOnCapture(boolean fullConvert) {
        Object hunterEntities;
        List villagerEntities = this.field_145850_b.func_217357_a(VillagerEntity.class, this.getVillageArea());
        if (ModEventFactory.fireVillagerCaptureEventPre(this, villagerEntities, fullConvert)) {
            return;
        }
        if (VReference.HUNTER_FACTION.equals(this.capturingFaction)) {
            hunterEntities = this.field_145850_b.func_217357_a(HunterBaseEntity.class, this.getVillageArea());
            int i = Math.max(2, hunterEntities.size() / 2);
            Iterator iterator = hunterEntities.iterator();
            while (iterator.hasNext()) {
                HunterBaseEntity hunter = (HunterBaseEntity)iterator.next();
                if (hunter instanceof ICaptureIgnore || i-- <= 0) continue;
                this.spawnVillagerReplace((MobEntity)hunter, true);
            }
            for (int o = i; o > 0; --o) {
                this.spawnVillagerDefault(true);
            }
            for (VillagerEntity villager : villagerEntities) {
                ExtendedCreature.getSafe((Entity)villager).ifPresent(e -> e.setPoisonousBlood(true));
            }
            this.updateTrainer(false);
        } else if (VReference.HUNTER_FACTION.equals(this.controllingFaction)) {
            this.updateTrainer(true);
            for (Object villager : villagerEntities) {
                ExtendedCreature.getSafe((Entity)villager).ifPresent(e -> e.setPoisonousBlood(false));
            }
            if (fullConvert) {
                Object villager;
                hunterEntities = this.field_145850_b.func_217357_a(HunterBaseEntity.class, this.getVillageArea());
                villager = hunterEntities.iterator();
                while (villager.hasNext()) {
                    HunterBaseEntity hunter = (HunterBaseEntity)villager.next();
                    if (hunter instanceof ICaptureIgnore) continue;
                    this.spawnEntity((MobEntity)this.getCaptureEntityForFaction(this.capturingFaction).func_200721_a(this.field_145850_b), (MobEntity)hunter, true, false);
                }
            }
        } else {
            this.updateTrainer(true);
        }
        if (VReference.VAMPIRE_FACTION.equals(this.capturingFaction)) {
            for (VillagerEntity villager : villagerEntities) {
                if (!fullConvert) {
                    if (RNG.nextInt(2) == 1) continue;
                    PotionSanguinare.addRandom((LivingEntity)villager, false);
                    continue;
                }
                villager.func_195064_c((EffectInstance)new PotionSanguinareEffect(11));
            }
        } else if (VReference.VAMPIRE_FACTION.equals(this.controllingFaction)) {
            for (VillagerEntity villager : villagerEntities) {
                if (villager.func_70644_a(ModEffects.sanguinare)) {
                    villager.func_195063_d(ModEffects.sanguinare);
                }
                if (!fullConvert || !(villager instanceof ConvertedVillagerEntity)) continue;
                this.spawnVillagerReplaceForced((MobEntity)villager, this.capturingFaction == VReference.HUNTER_FACTION);
            }
            if (fullConvert) {
                List vampireEntities = this.field_145850_b.func_217357_a(VampireBaseEntity.class, this.getVillageArea());
                for (VampireBaseEntity vampire : vampireEntities) {
                    if (vampire instanceof ICaptureIgnore) continue;
                    this.spawnEntity((MobEntity)this.getCaptureEntityForFaction(this.capturingFaction).func_200721_a(this.field_145850_b), (MobEntity)vampire, true, false);
                }
            }
        }
        villagerEntities = this.field_145850_b.func_217357_a(VillagerEntity.class, this.getVillageArea());
        for (VillagerEntity villager : villagerEntities) {
            if (!(villager.func_213700_eh().func_221130_b() instanceof FactionVillagerProfession)) continue;
            villager.func_213753_a(villager.func_213700_eh().func_221126_a(VillagerProfession.field_221151_a));
        }
        ModEventFactory.fireVillagerCaptureEventPost(this, villagerEntities, fullConvert);
    }

    private void spawnEntity(MobEntity newEntity) {
        UtilLib.spawnEntityInWorld(this.field_145850_b, this.getVillageAreaReduced(), (Entity)newEntity, 50, (List<? extends LivingEntity>)Lists.newArrayList(), SpawnReason.EVENT);
    }

    private void spawnEntity(MobEntity newEntity, MobEntity oldEntity, boolean replaceOld, boolean copyData) {
        if (copyData) {
            newEntity.func_180432_n((Entity)oldEntity);
        } else {
            newEntity.func_82149_j((Entity)oldEntity);
        }
        newEntity.func_184221_a(MathHelper.func_188210_a());
        if (replaceOld) {
            oldEntity.func_70106_y();
        }
        assert (this.field_145850_b != null);
        this.field_145850_b.func_217376_c((Entity)newEntity);
    }

    private void spawnTaskMaster() {
        assert (this.controllingFaction != null);
        EntityType<? extends ITaskMasterEntity> entity = this.controllingFaction.getVillageData().getTaskMasterEntity();
        if (entity != null) {
            ITaskMasterEntity newEntity = (ITaskMasterEntity)entity.func_200721_a(this.field_145850_b);
            newEntity.setHome(this.getVillageAreaReduced());
            UtilLib.spawnEntityInWorld(this.field_145850_b, this.getVillageAreaReduced(), (Entity)newEntity, 25, (List<? extends LivingEntity>)Lists.newArrayList(), SpawnReason.EVENT);
        }
    }

    public void updateTrainer(boolean toDummy) {
        Object entityType;
        List trainer;
        if (toDummy) {
            trainer = this.field_145850_b.func_217357_a(HunterTrainerEntity.class, this.getVillageArea());
            entityType = ModEntities.hunter_trainer_dummy;
        } else {
            trainer = this.field_145850_b.func_217357_a(DummyHunterTrainerEntity.class, this.getVillageArea());
            entityType = ModEntities.hunter_trainer;
        }
        for (Entity oldEntity : trainer) {
            Entity newEntity = entityType.func_200721_a(this.field_145850_b);
            if (newEntity == null) continue;
            newEntity.func_180432_n(oldEntity);
            newEntity.func_184221_a(MathHelper.func_188210_a());
            oldEntity.func_70106_y();
            newEntity.func_184224_h(true);
            this.field_145850_b.func_217376_c(newEntity);
        }
    }

    private float getStrength(LivingEntity entity) {
        if (entity instanceof PlayerEntity) {
            return ((Float)FactionPlayerHandler.getOpt((PlayerEntity)entity).map(FactionPlayerHandler::getCurrentLevelRelative).orElse((Object)Float.valueOf(0.0f))).floatValue();
        }
        if (entity instanceof ConvertedVillagerEntity) {
            return 0.5f;
        }
        if (entity instanceof IAggressiveVillager) {
            return 0.7f;
        }
        if (entity instanceof VillagerEntity) {
            return 0.4f;
        }
        return 1.0f;
    }

    @Override
    @Nullable
    public IFaction<?> getCapturingFaction() {
        return this.capturingFaction;
    }

    @Override
    @Nullable
    public IFaction<?> getControllingFaction() {
        return this.controllingFaction;
    }

    public void notifyNearbyPlayers(ITextComponent textComponent) {
        for (PlayerEntity player : this.field_145850_b.func_217369_A()) {
            if (player.func_70092_e((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p()) > (double)((Integer)VampirismConfig.BALANCE.viNotifyDistanceSQ.get()).intValue()) continue;
            player.func_146105_b(textComponent, true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    @OnlyIn(value=Dist.CLIENT)
    public float[] getBaseColors() {
        return this.baseColors;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float[] getCapturingColors() {
        return this.progressColor;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float shouldRenderBeam() {
        if (!this.isComplete || this.isDisabled || !this.isInsideVillage) {
            return 0.0f;
        }
        int i = (int)(this.field_145850_b.func_82737_E() - this.beamRenderCounter);
        this.beamRenderCounter = this.field_145850_b.func_82737_E();
        if (i > 1) {
            this.beamRenderScale -= (float)i / 40.0f;
            if (this.beamRenderScale < 0.0f) {
                this.beamRenderScale = 0.0f;
            }
        }
        this.beamRenderScale += 0.025f;
        if (this.beamRenderScale > 1.0f) {
            this.beamRenderScale = 1.0f;
        }
        return this.beamRenderScale;
    }

    public static class CaptureInfo
    implements ICaptureAttributes {
        @Nullable
        private final IFaction<?> defendingFaction;
        @Nullable
        private final IFaction<?> attackingFaction;
        private final AxisAlignedBB villageArea;
        private final BlockPos pos;
        private final boolean shouldForceTargets;

        private CaptureInfo(TotemTileEntity totem) {
            this.defendingFaction = totem.controllingFaction;
            this.attackingFaction = totem.capturingFaction;
            this.villageArea = totem.getVillageAreaReduced();
            this.pos = totem.field_174879_c;
            this.shouldForceTargets = totem.captureForceTargetTimer > (Integer)VampirismConfig.BALANCE.viForceTargetTime.get();
        }

        @Override
        @Nullable
        public IFaction<?> getDefendingFaction() {
            return this.defendingFaction;
        }

        @Override
        @Nullable
        public IFaction<?> getAttackingFaction() {
            return this.attackingFaction;
        }

        @Override
        public AxisAlignedBB getVillageArea() {
            return this.villageArea;
        }

        @Override
        public BlockPos getPosition() {
            return this.pos;
        }

        @Override
        public boolean shouldForceTargets() {
            return this.shouldForceTargets;
        }
    }

    private static enum CAPTURE_PHASE {
        PHASE_1_NEUTRAL,
        PHASE_1_OPPOSITE,
        PHASE_2;

    }
}

