/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFactionPlayerHandler;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.api.items.IFactionLevelItem;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.tileentity.TotemHelper;
import de.teamlapen.vampirism.world.gen.biome.VampireBiome;
import java.lang.reflect.Method;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.server.permission.PermissionAPI;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Helper {
    private static final Logger LOGGER = LogManager.getLogger();
    private static Method reflectionMethodExperiencePoints;

    public static boolean gettingSundamge(LivingEntity entity, IWorld world, @Nullable IProfiler profiler) {
        BlockPos pos;
        float angle;
        if (profiler != null) {
            profiler.func_76320_a("vampirism_checkSundamage");
        }
        if (entity instanceof PlayerEntity && entity.func_175149_v()) {
            return false;
        }
        if (VampirismAPI.sundamageRegistry().getSundamageInDim(world.func_201675_m().func_186058_p()) && (!(world instanceof World) || !((World)world).func_72896_J()) && ((double)(angle = world.func_72826_c(1.0f)) > 0.78 || (double)angle < 0.24) && Helper.canBlockSeeSun(world, pos = new BlockPos(entity.func_226277_ct_(), entity.func_226278_cu_() + (double)MathHelper.func_76131_a((float)(entity.func_213302_cg() / 2.0f), (float)0.0f, (float)2.0f), entity.func_226281_cx_()))) {
            try {
                Biome biome = world.func_226691_t_(pos);
                if (VampirismAPI.sundamageRegistry().getSundamageInBiome(biome) && !TotemHelper.isInsideVampireAreaCached(world.func_201675_m(), new BlockPos(entity.func_226277_ct_(), entity.func_226278_cu_() + 1.0, entity.func_226281_cx_()))) {
                    if (profiler != null) {
                        profiler.func_76319_b();
                    }
                    return true;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (profiler != null) {
            profiler.func_76319_b();
        }
        return false;
    }

    public static boolean canBlockSeeSun(IWorld world, BlockPos pos) {
        if (pos.func_177956_o() >= world.func_181545_F()) {
            return world.func_226660_f_(pos);
        }
        BlockPos blockpos = new BlockPos(pos.func_177958_n(), world.func_181545_F(), pos.func_177952_p());
        if (!world.func_226660_f_(blockpos)) {
            return false;
        }
        int liquidBlocks = 0;
        blockpos = blockpos.func_177977_b();
        while (blockpos.func_177956_o() > pos.func_177956_o()) {
            BlockState state = world.func_180495_p(blockpos);
            if (state.func_185904_a().func_76224_d()) {
                if (++liquidBlocks >= (Integer)VampirismConfig.BALANCE.vpSundamageWaterblocks.get()) {
                    return false;
                }
            } else {
                if (state.func_200132_m() && (state.func_224755_d((IBlockReader)world, pos, Direction.DOWN) || state.func_224755_d((IBlockReader)world, pos, Direction.UP))) {
                    return false;
                }
                if (state.func_200016_a((IBlockReader)world, blockpos) > 0) {
                    return false;
                }
            }
            blockpos = blockpos.func_177977_b();
        }
        return true;
    }

    @Nonnull
    public static EnumStrength getGarlicStrength(Entity e, IWorld world) {
        return Helper.getGarlicStrengthAt(world, e.func_180425_c());
    }

    @Nonnull
    public static EnumStrength getGarlicStrengthAt(IWorld world, BlockPos pos) {
        return VampirismAPI.getGarlicChunkHandler(world).getStrengthAtChunk(new ChunkPos(pos));
    }

    public static boolean canBecomeVampire(PlayerEntity player) {
        return (Boolean)FactionPlayerHandler.getOpt(player).map(v -> v.canJoin(VReference.VAMPIRE_FACTION)).orElse((Object)false);
    }

    public static boolean canTurnPlayer(IVampire biter, @Nullable PlayerEntity target) {
        if (biter instanceof IVampirePlayer) {
            if (!((Boolean)VampirismConfig.SERVER.playerCanTurnPlayer.get()).booleanValue()) {
                return false;
            }
            return PermissionAPI.hasPermission((PlayerEntity)((IVampirePlayer)biter).getRepresentingPlayer(), (String)"vampirism.infect.player");
        }
        return (Boolean)VampirismConfig.SERVER.disableMobBiteInfection.get() == false;
    }

    public static boolean isVampire(Entity entity) {
        return VReference.VAMPIRE_FACTION.equals(VampirismAPI.factionRegistry().getFaction(entity));
    }

    public static boolean isHunter(Entity entity) {
        return VReference.HUNTER_FACTION.equals(VampirismAPI.factionRegistry().getFaction(entity));
    }

    public static boolean isHunter(PlayerEntity entity) {
        return (Boolean)VampirismAPI.getFactionPlayerHandler(entity).map(h -> VReference.HUNTER_FACTION.equals(h.getCurrentFaction())).orElse((Object)false);
    }

    public static boolean isVampire(PlayerEntity entity) {
        return (Boolean)VampirismAPI.getFactionPlayerHandler(entity).map(h -> VReference.VAMPIRE_FACTION.equals(h.getCurrentFaction())).orElse((Object)false);
    }

    public static boolean areSkillsEnabled(ISkillHandler skillHandler, ISkill ... skills) {
        if (skills == null) {
            return true;
        }
        for (ISkill skill : skills) {
            if (skillHandler.isSkillEnabled(skill)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEntityInVampireBiome(Entity e) {
        if (e == null) {
            return false;
        }
        try {
            return e.func_130014_f_().func_226691_t_(e.func_180425_c()) instanceof VampireBiome;
        }
        catch (NullPointerException e1) {
            LOGGER.error("Nullpointer when checking biome. This is strange and should not happen", (Throwable)e1);
            return false;
        }
    }

    public static boolean canUseFactionItem(ItemStack stack, IFactionLevelItem item, IFactionPlayerHandler playerHandler) {
        IPlayableFaction usingFaction = item.getUsingFaction(stack);
        ISkill requiredSkill = item.getRequiredSkill(stack);
        int reqLevel = item.getMinLevel(stack);
        if (usingFaction != null && !playerHandler.isInFaction(usingFaction)) {
            return false;
        }
        if (playerHandler.getCurrentLevel() < reqLevel) {
            return false;
        }
        if (requiredSkill == null) {
            return true;
        }
        return playerHandler.getCurrentFactionPlayer().map(fp -> fp.getSkillHandler()).map(s -> s.isSkillEnabled(requiredSkill)).orElse(false);
    }

    public static int getExperiencePoints(LivingEntity entity, PlayerEntity player) {
        try {
            if (reflectionMethodExperiencePoints == null) {
                reflectionMethodExperiencePoints = ObfuscationReflectionHelper.findMethod(LivingEntity.class, (String)"func_70693_a", (Class[])new Class[]{PlayerEntity.class});
            }
            return (Integer)reflectionMethodExperiencePoints.invoke((Object)entity, player);
        }
        catch (Exception e) {
            LOGGER.error("Failed to get experience points", (Throwable)e);
            return 0;
        }
    }

    public static boolean attemptToGuessGenderSafe(PlayerEntity p) {
        Map textureMap;
        if (p instanceof ServerPlayerEntity && (textureMap = ((ServerPlayerEntity)p).field_71133_b.func_147130_as().getTextures(p.func_146103_bH(), false)).containsKey(MinecraftProfileTexture.Type.SKIN)) {
            MinecraftProfileTexture skinTexture = (MinecraftProfileTexture)textureMap.get(MinecraftProfileTexture.Type.SKIN);
            return "slim".equals(skinTexture.getMetadata("model"));
        }
        return false;
    }
}

