/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import com.google.common.io.ByteStreams;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import de.teamlapen.vampirism.VampirismMod;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.URL;
import java.util.Arrays;
import java.util.Random;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SupporterManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static SupporterManager instance = new SupporterManager();
    private Supporter[][] supporters = new Supporter[2][0];

    public static SupporterManager getInstance() {
        return instance;
    }

    private SupporterManager() {
    }

    public Supporter getRandomHunter(Random rnd) {
        if (this.supporters[1].length > 0) {
            return this.supporters[1][rnd.nextInt(this.supporters[1].length)];
        }
        return new Supporter(null, null, 0);
    }

    public Supporter getRandomVampire(Random rnd) {
        if (this.supporters[0].length > 0) {
            return this.supporters[0][rnd.nextInt(this.supporters[0].length)];
        }
        return new Supporter(null, null, 0);
    }

    public void initAsync() {
        Thread thread = new Thread("vampirism:SupporterManager"){

            @Override
            public void run() {
                SupporterManager.this.init();
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    private String getDebugString() {
        return "Vampires: " + Arrays.toString(this.supporters[0]) + " Hunters: " + Arrays.toString(this.supporters[1]);
    }

    private void init() {
        String data;
        Supporter[][] supporters = null;
        InputStream inputStream = null;
        try {
            inputStream = new URL("http://maxanier.de/projects/vampirism/supporters.json").openStream();
            data = new String(ByteStreams.toByteArray((InputStream)inputStream));
            inputStream.close();
            supporters = this.retrieveSupporter(data);
        }
        catch (IOException e) {
            if (e instanceof ConnectException) {
                LOGGER.error("Failed to connect to supporter url {}", (Object)"http://maxanier.de/projects/vampirism/supporters.json");
            }
            LOGGER.error("Failed to retrieve supporters from url", (Throwable)e);
        }
        if (supporters == null || VampirismMod.inDev) {
            try {
                inputStream = VampirismMod.class.getResourceAsStream("/supporters.json");
                data = new String(ByteStreams.toByteArray((InputStream)inputStream));
                inputStream.close();
                supporters = this.retrieveSupporter(data);
            }
            catch (IOException e) {
                LOGGER.error("Failed to retrieve supporters from resources", (Throwable)e);
            }
        }
        if (supporters != null) {
            this.supporters = supporters;
            LOGGER.trace("Supporters {}", (Object)this.getDebugString());
        }
    }

    private Supporter parseSupporter(JsonObject object) {
        String name = null;
        String texture = null;
        int type = 0;
        if (object.has("name")) {
            name = object.get("name").getAsString();
        }
        if (object.has("texture")) {
            texture = object.get("texture").getAsString();
        }
        if (object.has("type")) {
            type = object.get("type").getAsInt();
        }
        return new Supporter(name, texture, type);
    }

    @Nullable
    private Supporter[][] retrieveSupporter(String data) {
        try {
            Supporter[][] supporters = new Supporter[2][];
            JsonElement main = new JsonParser().parse(data);
            JsonArray vampires = main.getAsJsonObject().getAsJsonArray("vampires");
            supporters[0] = new Supporter[vampires.size()];
            for (int i = 0; i < supporters[0].length; ++i) {
                supporters[0][i] = this.parseSupporter(vampires.get(i).getAsJsonObject());
            }
            JsonArray hunters = main.getAsJsonObject().getAsJsonArray("hunters");
            supporters[1] = new Supporter[hunters.size()];
            for (int i = 0; i < supporters[1].length; ++i) {
                supporters[1][i] = this.parseSupporter(hunters.get(i).getAsJsonObject());
            }
            return supporters;
        }
        catch (JsonSyntaxException e) {
            LOGGER.error("Failed to parse supporter list", (Throwable)e);
            return null;
        }
    }

    public class Supporter {
        @Nullable
        public final String textureName;
        @Nullable
        public final String senderName;
        public final int typeId;

        private Supporter(@Nullable String senderName, String textureName, int typeId) {
            this.typeId = typeId;
            this.senderName = senderName != null && senderName.equals("null") ? null : senderName;
            this.textureName = textureName;
        }

        public String toString() {
            return "[" + this.textureName + " as '" + this.senderName + "' (" + this.typeId + ")]";
        }
    }
}

