/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world;

import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.minion.management.PlayerMinionController;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MinionWorldData
extends WorldSavedData {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String ID = "vampirism-minion-data";
    private final MinecraftServer server;
    private final Object2ObjectOpenHashMap<UUID, PlayerMinionController> controllers = new Object2ObjectOpenHashMap();

    @Nonnull
    public static MinionWorldData getData(ServerWorld world) {
        return MinionWorldData.getData(world.func_73046_m());
    }

    @Nonnull
    public static MinionWorldData getData(MinecraftServer server) {
        return (MinionWorldData)server.func_71218_a(DimensionType.field_223227_a_).func_217481_x().func_215752_a(() -> new MinionWorldData(server), ID);
    }

    @Nonnull
    public static Optional<MinionWorldData> getData(World world) {
        if (world instanceof ServerWorld) {
            return Optional.of(MinionWorldData.getData(((ServerWorld)world).getWorldServer()));
        }
        return Optional.empty();
    }

    public MinionWorldData(MinecraftServer server) {
        super(ID);
        this.server = server;
    }

    @Nullable
    public PlayerMinionController getController(UUID lordID) {
        return (PlayerMinionController)this.controllers.get((Object)lordID);
    }

    @Nonnull
    public PlayerMinionController getOrCreateController(FactionPlayerHandler lord) {
        UUID id = lord.getPlayer().func_110124_au();
        if (this.controllers.containsKey((Object)id)) {
            return (PlayerMinionController)this.controllers.get((Object)id);
        }
        PlayerMinionController c = new PlayerMinionController(this.server, id);
        c.setMaxMinions(lord.getCurrentFaction(), lord.getMaxMinions());
        this.controllers.put((Object)id, (Object)c);
        return c;
    }

    public boolean func_76188_b() {
        return true;
    }

    @Deprecated
    public void purgeController(UUID lordID) {
        this.controllers.remove((Object)lordID);
    }

    public void func_76184_a(CompoundNBT nbt) {
        this.controllers.clear();
        ListNBT all = nbt.func_150295_c("controllers", 10);
        for (INBT inbt : all) {
            CompoundNBT tag = (CompoundNBT)inbt;
            UUID id = tag.func_186857_a("uuid");
            PlayerMinionController c = new PlayerMinionController(this.server, id);
            c.deserializeNBT(tag);
            this.controllers.put((Object)id, (Object)c);
        }
    }

    public void tick() {
        this.controllers.object2ObjectEntrySet().fastForEach(entry -> ((PlayerMinionController)entry.getValue()).tick());
    }

    @Nonnull
    public CompoundNBT func_189551_b(CompoundNBT compound) {
        ListNBT all = new ListNBT();
        this.controllers.object2ObjectEntrySet().fastForEach(entry -> {
            if (((PlayerMinionController)entry.getValue()).hasMinions()) {
                CompoundNBT tag = ((PlayerMinionController)entry.getValue()).serializeNBT();
                tag.func_186854_a("uuid", (UUID)entry.getKey());
                all.add((Object)tag);
            }
        });
        compound.func_218657_a("controllers", (INBT)all);
        return compound;
    }
}

