/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.world.IVampirismWorld;
import de.teamlapen.vampirism.world.VampirismWorldDefaultImpl;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VampirismWorld
implements IVampirismWorld {
    private static final Logger LOGGER = LogManager.getLogger();
    @CapabilityInject(value=IVampirismWorld.class)
    public static Capability<IVampirismWorld> CAP = (Capability)UtilLib.getNull();
    @Nonnull
    private final World world;

    public static IVampirismWorld get(World world) {
        return (IVampirismWorld)world.getCapability(CAP, null).orElseThrow(() -> new IllegalStateException("Cannot get FactionPlayerHandler from EntityPlayer " + world));
    }

    public static LazyOptional<IVampirismWorld> getOpt(@Nonnull World world) {
        LazyOptional opt = world.getCapability(CAP, null).cast();
        if (!opt.isPresent()) {
            LOGGER.warn("Cannot get world capability. This might break mod functionality.", new Throwable().fillInStackTrace());
        }
        return opt;
    }

    public static void registerCapability() {
        CapabilityManager.INSTANCE.register(IVampirismWorld.class, (Capability.IStorage)new Storage(), VampirismWorldDefaultImpl::new);
    }

    public static ICapabilityProvider createNewCapability(final World world) {
        return new ICapabilitySerializable<CompoundNBT>(){
            final IVampirismWorld inst;
            final LazyOptional<IVampirismWorld> opt;
            {
                this.inst = new VampirismWorld(world);
                this.opt = LazyOptional.of(() -> this.inst);
            }

            public void deserializeNBT(CompoundNBT nbt) {
                CAP.getStorage().readNBT(CAP, (Object)this.inst, null, (INBT)nbt);
            }

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
                return CAP.orEmpty(capability, this.opt);
            }

            public CompoundNBT serializeNBT() {
                return (CompoundNBT)CAP.getStorage().writeNBT(CAP, (Object)this.inst, null);
            }
        };
    }

    public VampirismWorld(@Nonnull World world) {
        this.world = world;
    }

    private void loadNBTData(CompoundNBT nbt) {
    }

    private void saveNBTData(CompoundNBT nbt) {
    }

    private static class Storage
    implements Capability.IStorage<IVampirismWorld> {
        private Storage() {
        }

        public void readNBT(Capability<IVampirismWorld> capability, IVampirismWorld instance, Direction side, INBT nbt) {
            ((VampirismWorld)instance).loadNBTData((CompoundNBT)nbt);
        }

        public INBT writeNBT(Capability<IVampirismWorld> capability, IVampirismWorld instance, Direction side) {
            CompoundNBT nbt = new CompoundNBT();
            ((VampirismWorld)instance).saveNBTData(nbt);
            return nbt;
        }
    }
}

