/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.teamlapen.vampirism.api.world.IWorldGenManager;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

@MethodsReturnNonnullByDefault
public class WorldGenManager
implements IWorldGenManager {
    @Nonnull
    private final Map<ResourceLocation, Set<Biome>> ignoreStructureBiome = Maps.newHashMap();
    @Nonnull
    private final Map<ResourceLocation, Set<BiomeDictionary.Type>> ignoreStructureBiomeCategory = Maps.newHashMap();

    @Override
    public void removeStructureFromBiomes(ResourceLocation structure, List<Biome> biomes) {
        this.ignoreStructureBiome.computeIfAbsent(structure, name -> Sets.newHashSet()).addAll(biomes);
    }

    @Override
    public void removeStructureFromBiomeCategories(ResourceLocation structure, List<BiomeDictionary.Type> categories) {
        this.ignoreStructureBiomeCategory.computeIfAbsent(structure, name -> Sets.newHashSet()).addAll(categories);
    }

    @Override
    public Set<BiomeDictionary.Type> getIgnoredBiomeCategories(ResourceLocation structure) {
        if (!this.ignoreStructureBiomeCategory.containsKey(structure)) {
            return Sets.newHashSet();
        }
        return ImmutableSet.copyOf((Collection)this.ignoreStructureBiomeCategory.get(structure));
    }

    @Override
    public Set<Biome> getIgnoredBiomes(ResourceLocation structure) {
        if (!this.ignoreStructureBiome.containsKey(structure)) {
            return Sets.newHashSet();
        }
        return ImmutableSet.copyOf((Collection)this.ignoreStructureBiome.get(structure));
    }

    @Override
    public boolean canStructureBeGeneratedInBiome(ResourceLocation structure, Biome biome) {
        if (this.ignoreStructureBiome.containsKey(structure) && this.ignoreStructureBiome.get(structure).contains(biome)) {
            return false;
        }
        if (this.ignoreStructureBiomeCategory.containsKey(structure)) {
            Set<BiomeDictionary.Type> categories = this.ignoreStructureBiomeCategory.get(structure);
            for (BiomeDictionary.Type type : BiomeDictionary.getTypes((Biome)biome)) {
                if (!categories.contains(type)) continue;
                return false;
            }
        }
        return true;
    }
}

