/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.gen.util;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import de.teamlapen.vampirism.core.ModFeatures;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;

public class BiomeTopBlockProcessor
extends StructureProcessor {
    private static final Map<Block, Block> streetBlocks = new HashMap<Block, Block>(){
        {
            this.put(Blocks.field_150354_m, Blocks.field_196580_bH);
            this.put(Blocks.field_196658_i, Blocks.field_185774_da);
        }
    };
    private final BlockState replaceBlock;

    public BiomeTopBlockProcessor(BlockState blockState) {
        this.replaceBlock = blockState;
    }

    public BiomeTopBlockProcessor(Dynamic<?> dynamic) {
        this(BlockState.func_215698_a((Dynamic)dynamic.get("replaceBlock").orElseEmptyMap()));
    }

    @Nullable
    public Template.BlockInfo process(@Nonnull IWorldReader worldReaderIn, @Nonnull BlockPos pos, @Nonnull Template.BlockInfo p_215194_3_, @Nonnull Template.BlockInfo blockInfo, @Nonnull PlacementSettings placementSettingsIn, @Nullable Template template) {
        if (blockInfo.field_186243_b.equals(this.replaceBlock)) {
            BlockState topBlock = worldReaderIn.func_226691_t_(blockInfo.field_186242_a).func_203944_q().func_204108_a();
            if (streetBlocks.containsKey(topBlock.func_177230_c())) {
                topBlock = streetBlocks.get(topBlock.func_177230_c()).func_176223_P();
            }
            return new Template.BlockInfo(blockInfo.field_186242_a, topBlock, null);
        }
        return blockInfo;
    }

    @Nonnull
    protected IStructureProcessorType func_215192_a() {
        return ModFeatures.biome_based;
    }

    @Nonnull
    protected <T> Dynamic<T> func_215193_a(@Nonnull DynamicOps<T> ops) {
        return new Dynamic(ops, ops.createMap((Map)ImmutableMap.of((Object)ops.createString("replaceBlock"), (Object)BlockState.func_215689_a(ops, (BlockState)this.replaceBlock).getValue())));
    }
}

