/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.gen.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.util.IDynamicDeserializer;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.gen.feature.template.AlwaysTrueRuleTest;
import net.minecraft.world.gen.feature.template.RuleEntry;
import net.minecraft.world.gen.feature.template.RuleTest;
import org.apache.commons.lang3.tuple.Pair;

public class RandomBlockState
extends RuleEntry {
    private static final Random RNG = new Random();
    private final RuleTest inputPredicate;
    private final RuleTest locationPredicate;
    private final Pair<BlockState, CompoundNBT> defaultState;
    private final Pair<BlockState, CompoundNBT>[] outputStates;

    public RandomBlockState(RuleTest inputPredicate, RuleTest locationPredicate, BlockState defaultState, BlockState ... outputStates) {
        this(inputPredicate, locationPredicate, (Pair<BlockState, CompoundNBT>)Pair.of((Object)defaultState, null), Arrays.stream(outputStates).map(state -> Pair.of((Object)state, (Object)null)).collect(Collectors.toList()).toArray(new Pair[0]));
    }

    @SafeVarargs
    public RandomBlockState(RuleTest inputPredicate, RuleTest locationPredicate, Pair<BlockState, CompoundNBT> defaultState, Pair<BlockState, CompoundNBT> ... outputStates) {
        super(inputPredicate, locationPredicate, (BlockState)defaultState.getLeft(), (CompoundNBT)defaultState.getRight());
        this.defaultState = defaultState;
        this.outputStates = outputStates;
        this.inputPredicate = inputPredicate;
        this.locationPredicate = locationPredicate;
    }

    public Pair<BlockState, CompoundNBT> getOutput() {
        if (this.outputStates.length == 0) {
            return this.defaultState;
        }
        return this.outputStates[RNG.nextInt(this.outputStates.length)];
    }

    public static <T> RandomBlockState deserialize(Dynamic<T> dynamicIn) {
        Dynamic inputDynamic = dynamicIn.get("input_predicate").orElseEmptyMap();
        Dynamic locationDynamic = dynamicIn.get("location_predicate").orElseEmptyMap();
        RuleTest ruleTest = (RuleTest)IDynamicDeserializer.func_214907_a((Dynamic)inputDynamic, (Registry)Registry.field_218363_D, (String)"predicate_type", (Object)AlwaysTrueRuleTest.field_215190_a);
        RuleTest ruleTest1 = (RuleTest)IDynamicDeserializer.func_214907_a((Dynamic)locationDynamic, (Registry)Registry.field_218363_D, (String)"predicate_type", (Object)AlwaysTrueRuleTest.field_215190_a);
        BlockState defaultState = BlockState.func_215698_a((Dynamic)dynamicIn.get("default_state").orElseEmptyMap());
        CompoundNBT defaultNbt = dynamicIn.get("default_nbt").map(dynamic -> (INBT)dynamic.convert((DynamicOps)NBTDynamicOps.field_210820_a).getValue()).orElse(null);
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < dynamicIn.get("amount").asInt(0); ++i) {
            BlockState blockState = BlockState.func_215698_a((Dynamic)dynamicIn.get("output_state_" + i).orElseEmptyMap());
            CompoundNBT compoundNbt = dynamicIn.get("output_nbt_" + i).map(dynamic -> (INBT)dynamic.convert((DynamicOps)NBTDynamicOps.field_210820_a).getValue()).orElse(null);
            list.add(Pair.of((Object)blockState, (Object)compoundNbt));
        }
        return new RandomBlockState(ruleTest, ruleTest1, (Pair<BlockState, CompoundNBT>)Pair.of((Object)defaultState, (Object)defaultNbt), list.toArray(new Pair[0]));
    }

    @Nonnull
    public <T> Dynamic<T> func_215212_a(DynamicOps<T> ops) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(ops.createString("input_predicate"), this.inputPredicate.func_215179_b(ops).getValue());
        builder.put(ops.createString("location_predicate"), this.locationPredicate.func_215179_b(ops).getValue());
        builder.put(ops.createString("default_state"), BlockState.func_215689_a(ops, (BlockState)((BlockState)this.defaultState.getLeft())).getValue());
        if (this.defaultState.getRight() != null) {
            builder.put(ops.createString("default_nbt"), new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, this.defaultState.getRight()).convert(ops).getValue());
        }
        builder.put(ops.createString("amount"), ops.createInt(this.outputStates.length));
        for (int i = 0; i < this.outputStates.length; ++i) {
            builder.put(ops.createString("output_state_" + i), BlockState.func_215689_a(ops, (BlockState)((BlockState)this.outputStates[i].getKey())).getValue());
            if (this.outputStates[i].getValue() == null) continue;
            builder.put(ops.createString("output_nbt_" + i), new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, this.outputStates[i].getValue()).convert(ops).getValue());
        }
        Object t = ops.createMap((Map)builder.build());
        return new Dynamic(ops, t);
    }
}

