/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.gen.util;

import com.google.common.collect.Lists;
import com.mojang.datafixers.Dynamic;
import de.teamlapen.vampirism.core.ModFeatures;
import de.teamlapen.vampirism.world.gen.util.RandomBlockState;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.RuleStructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import org.apache.commons.lang3.tuple.Pair;

public class RandomStructureProcessor
extends RuleStructureProcessor {
    private final List<RandomBlockState> rules;

    public RandomStructureProcessor(List<RandomBlockState> rules) {
        super((List)Lists.newArrayList(rules));
        this.rules = rules;
    }

    public RandomStructureProcessor(Dynamic<?> dynamic) {
        this(dynamic.get("rules").asList(RandomBlockState::deserialize));
    }

    @Nullable
    public Template.BlockInfo func_215194_a(IWorldReader worldReaderIn, @Nonnull BlockPos pos, @Nonnull Template.BlockInfo p_215194_3_, Template.BlockInfo blockInfo, @Nonnull PlacementSettings placementSettingsIn) {
        Random random = new Random(MathHelper.func_180186_a((Vec3i)blockInfo.field_186242_a));
        BlockState blockstate = worldReaderIn.func_180495_p(blockInfo.field_186242_a);
        for (RandomBlockState ruleEntry : this.rules) {
            if (!ruleEntry.func_215211_a(blockInfo.field_186243_b, blockstate, random)) continue;
            Pair<BlockState, CompoundNBT> pair = ruleEntry.getOutput();
            return new Template.BlockInfo(blockInfo.field_186242_a, (BlockState)pair.getKey(), (CompoundNBT)pair.getValue());
        }
        return blockInfo;
    }

    @Nonnull
    protected IStructureProcessorType func_215192_a() {
        return ModFeatures.random_selector;
    }
}

