/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import de.teamlapen.vampirism.api.difficulty.IAdjustableLevel;
import net.minecraft.entity.Entity;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.ILootCondition;

public class AdjustableLevelCondition
implements ILootCondition {
    private final int levelTest;
    private final LootContext.EntityTarget target;

    public AdjustableLevelCondition(int level, LootContext.EntityTarget targetIn) {
        this.levelTest = level;
        this.target = targetIn;
    }

    public boolean test(LootContext lootContext) {
        Entity e = (Entity)lootContext.func_216031_c(this.target.func_216029_a());
        if (e instanceof IAdjustableLevel) {
            int l = ((IAdjustableLevel)e).getLevel();
            if (this.levelTest != -1) {
                return this.levelTest == l;
            }
        }
        return false;
    }

    public static ILootCondition.IBuilder builder(int level, LootContext.EntityTarget target) {
        return () -> new AdjustableLevelCondition(level, target);
    }

    public static class Serializer
    extends ILootCondition.AbstractSerializer<AdjustableLevelCondition> {
        public Serializer() {
            super(new ResourceLocation("vampirism", "adjustable_level"), AdjustableLevelCondition.class);
        }

        public AdjustableLevelCondition deserialize(JsonObject json, JsonDeserializationContext context) {
            return new AdjustableLevelCondition(json.has("level") ? JSONUtils.func_151203_m((JsonObject)json, (String)"level") : -1, (LootContext.EntityTarget)JSONUtils.func_188174_a((JsonObject)json, (String)"entity", (JsonDeserializationContext)context, LootContext.EntityTarget.class));
        }

        public void serialize(JsonObject json, AdjustableLevelCondition value, JsonSerializationContext context) {
            json.add("level", context.serialize((Object)value.levelTest));
            json.add("entity", context.serialize((Object)value.target));
        }
    }
}

