/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanshields.item.crafting;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.oblivioussp.spartanshields.init.ModRecipes;
import com.oblivioussp.spartanshields.item.ShieldBaseItem;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.BannerItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ShieldBannerRecipe
extends SpecialRecipe {
    protected final Item shieldItem;

    public ShieldBannerRecipe(ResourceLocation loc, Item shield) {
        super(loc);
        this.shieldItem = shield;
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        ItemStack itemstack = ItemStack.field_190927_a;
        ItemStack itemstack1 = ItemStack.field_190927_a;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack itemstack2 = inv.func_70301_a(i);
            if (itemstack2.func_190926_b()) continue;
            if (ItemTags.field_202901_n.func_199685_a_((Object)itemstack2.func_77973_b())) {
                if (!itemstack1.func_190926_b()) {
                    return false;
                }
                itemstack1 = itemstack2;
                continue;
            }
            if (itemstack2.func_77973_b() != this.shieldItem) {
                return false;
            }
            if (!itemstack.func_190926_b()) {
                return false;
            }
            if (itemstack2.func_179543_a("BlockEntityTag") != null) {
                return false;
            }
            itemstack = itemstack2;
        }
        return !itemstack.func_190926_b() && !itemstack1.func_190926_b();
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        ItemStack itemstack = ItemStack.field_190927_a;
        ItemStack itemstack1 = ItemStack.field_190927_a;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack itemstack2 = inv.func_70301_a(i);
            if (itemstack2.func_190926_b()) continue;
            if (ItemTags.field_202901_n.func_199685_a_((Object)itemstack2.func_77973_b())) {
                itemstack = itemstack2;
                continue;
            }
            if (itemstack2.func_77973_b() != this.shieldItem) continue;
            itemstack1 = itemstack2.func_77946_l();
        }
        if (itemstack1.func_190926_b()) {
            return itemstack1;
        }
        CompoundNBT nbttagcompound = itemstack.func_179543_a("BlockEntityTag");
        CompoundNBT nbttagcompound1 = nbttagcompound == null ? new CompoundNBT() : nbttagcompound.func_74737_b();
        nbttagcompound1.func_74768_a("Base", ((BannerItem)itemstack.func_77973_b()).func_195948_b().func_196059_a());
        itemstack1.func_77983_a("BlockEntityTag", (INBT)nbttagcompound1);
        return itemstack1;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        NonNullList nonnulllist = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            if (!itemstack.func_77973_b().hasContainerItem(itemstack)) continue;
            nonnulllist.set(i, (Object)new ItemStack((IItemProvider)itemstack.func_77973_b().func_77668_q()));
        }
        return nonnulllist;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return ModRecipes.SHIELD_BANNER;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<ShieldBannerRecipe> {
        public Serializer() {
            this.setRegistryName(new ResourceLocation("spartanshields", "apply_banner"));
        }

        public ShieldBannerRecipe read(ResourceLocation recipeId, JsonObject json) {
            String shieldName = JSONUtils.func_151200_h((JsonObject)json, (String)"shield");
            Item shieldItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(shieldName));
            if (shieldItem != null) {
                if (shieldItem instanceof ShieldBaseItem) {
                    return new ShieldBannerRecipe(recipeId, shieldItem);
                }
                throw new JsonSyntaxException("Item " + shieldName + " is not a valid Shield!");
            }
            throw new JsonSyntaxException("Item " + shieldName + " did not exist!");
        }

        public ShieldBannerRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            ResourceLocation shieldName = buffer.func_192575_l();
            Item shield = (Item)ForgeRegistries.ITEMS.getValue(shieldName);
            return new ShieldBannerRecipe(recipeId, shield);
        }

        public void write(PacketBuffer buffer, ShieldBannerRecipe recipe) {
            ResourceLocation shieldName = recipe.shieldItem.getRegistryName();
            buffer.func_192572_a(shieldName);
        }
    }
}

