/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.blackleg;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.abilities.blackleg.DiableJambeAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IExtraUpdateData;
import xyz.pixelatedw.mineminenomi.api.abilities.IFallDamageBlockingAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IMultiTargetAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SUpdateEquippedAbilityPacket;
import xyz.pixelatedw.mineminenomi.particles.effects.blackleg.ConcasseParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

public class ConcasseAbility
extends Ability
implements IMultiTargetAbility,
IFallDamageBlockingAbility,
IExtraUpdateData {
    public static final ConcasseAbility INSTANCE = new ConcasseAbility();
    private static final ConcasseParticleEffect PARTICLES = new ConcasseParticleEffect();
    private boolean hasLanded = false;
    private boolean hasFallDamage = true;

    public ConcasseAbility() {
        super("Concasse", AbilityHelper.getStyleCategory());
        this.setMaxCooldown(15.0);
        this.setDescription("Leaps forward kicking all nearby enemies for moderate damage and knocking them down");
        this.onUseEvent = this::onUseEvent;
        this.duringCooldownEvent = this::duringCooldown;
    }

    private boolean onUseEvent(PlayerEntity player) {
        if (!AbilityHelper.canUseMomentumAbility(player)) {
            return false;
        }
        this.clearTargets();
        player.func_213293_j(player.func_213322_ci().field_72450_a, 1.3, player.func_213322_ci().field_72449_c);
        player.field_70133_I = true;
        this.hasLanded = false;
        this.hasFallDamage = false;
        return true;
    }

    private void duringCooldown(PlayerEntity player, int cooldownTimer) {
        DiableJambeAbility diableJambeAbility;
        boolean isAbilityEnabled;
        if (player.func_70090_H() && !this.hasLanded) {
            this.hasLanded = true;
            WyNetwork.sendTo(new SUpdateEquippedAbilityPacket(player, this), player);
        }
        if (player.field_70122_E && this.getCooldownPercentage() < 98.0 && !this.hasLanded) {
            List<LivingEntity> targets = WyHelper.getEntitiesNear(player.func_180425_c(), player.field_70170_p, 1.75, FactionHelper.getOutsideGroupPredicate((LivingEntity)player), LivingEntity.class);
            targets.remove(player);
            for (LivingEntity entity : targets) {
                if (!this.isTarget(entity)) continue;
                entity.func_70097_a((DamageSource)ModDamageSource.causeAbilityDamage(player, this), 15.0f);
                EffectInstance effInst = new EffectInstance(ModEffects.UNCONSCIOUS, 60, 1, false, false);
                entity.func_195064_c(effInst);
                ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SPlayEntityEffectPacket(entity.func_145782_y(), effInst));
            }
            if (targets.size() > 0) {
                ((ServerWorld)player.field_70170_p).func_72863_F().func_217216_a((Entity)player, (IPacket)new SAnimateHandPacket((Entity)player, 0));
            }
            this.hasLanded = true;
            if (this.hasLanded) {
                WyNetwork.sendTo(new SUpdateEquippedAbilityPacket(player, this), player);
            }
        }
        boolean bl = isAbilityEnabled = (diableJambeAbility = AbilityDataCapability.get((LivingEntity)player).getEquippedAbility(DiableJambeAbility.INSTANCE)) != null && diableJambeAbility.isContinuous();
        if (isAbilityEnabled && !player.field_70122_E && !this.hasLanded) {
            PARTICLES.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
        }
    }

    public boolean hasLanded() {
        return this.hasLanded;
    }

    @Override
    public CompoundNBT getExtraData() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74757_a("hasLanded", this.hasLanded);
        return nbt;
    }

    @Override
    public void setExtraData(CompoundNBT nbt) {
        this.hasLanded = nbt.func_74767_n("hasLanded");
    }

    @Override
    public void resetFallDamage(LivingEntity player) {
        this.hasFallDamage = true;
    }

    @Override
    public boolean hasFallDamage() {
        return this.hasFallDamage;
    }
}

