/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.blackleg;

import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import xyz.pixelatedw.mineminenomi.abilities.blackleg.ExtraHachisAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityOverlay;
import xyz.pixelatedw.mineminenomi.api.abilities.IPunchOverlayAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SUpdateEquippedAbilityPacket;
import xyz.pixelatedw.mineminenomi.particles.effects.blackleg.DiableJambeParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ContinuousAbility;
import xyz.pixelatedw.mineminenomi.wypi.abilities.IParallelContinuousAbility;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

public class DiableJambeAbility
extends ContinuousAbility
implements IParallelContinuousAbility,
IPunchOverlayAbility {
    public static final DiableJambeAbility INSTANCE = new DiableJambeAbility();
    private static final DiableJambeParticleEffect PARTICLES = new DiableJambeParticleEffect();
    private static final AbilityOverlay OVERLAY = new AbilityOverlay().setTexture(ModResources.HOT_BOILING_SPECIAL_ARM).setColor("#FFBB44AA");
    private static final AttributeModifier DIABLE_JAMBE_STRENGTH_MODIFIER = new AttributeModifier(UUID.fromString("e3ae074c-40a9-49ff-aa3b-7cc9b98ddc2d"), "Diable Jambe Attack Multiplier", 4.0, AttributeModifier.Operation.ADDITION).func_111168_a(false);
    private static final AttributeModifier DIABLE_JAMBE_ATTACK_SPEED_MODIFIER = new AttributeModifier(UUID.fromString("a984413a-7459-4989-8362-7c46a2663f0e"), "Diable Jambe Speed Multiplier", (double)0.4f, AttributeModifier.Operation.ADDITION).func_111168_a(false);

    public DiableJambeAbility() {
        super("Diable Jambe", AbilityHelper.getStyleCategory());
        this.setThreshold(30.0);
        this.setDescription("The user heats up their leg, dealing additional damage and shortly setting the target on fire (Enhances all Blackleg attacks)");
        this.onStartContinuityEvent = this::onStartContinuityEvent;
        this.duringContinuityEvent = this::duringContinuity;
        this.onEndContinuityEvent = this::onEndContinuityEvent;
    }

    private boolean onStartContinuityEvent(PlayerEntity player) {
        player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111124_b(DIABLE_JAMBE_STRENGTH_MODIFIER);
        player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(DIABLE_JAMBE_STRENGTH_MODIFIER);
        player.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111124_b(DIABLE_JAMBE_ATTACK_SPEED_MODIFIER);
        player.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111121_a(DIABLE_JAMBE_ATTACK_SPEED_MODIFIER);
        IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)player);
        ExtraHachisAbility extraHachiAbl = abilityProps.getEquippedAbility(ExtraHachisAbility.INSTANCE);
        if (extraHachiAbl != null) {
            extraHachiAbl.enableDiableJambeMode();
            WyNetwork.sendToAllTrackingAndSelf(new SUpdateEquippedAbilityPacket(player, extraHachiAbl), (LivingEntity)player);
        }
        return true;
    }

    private void duringContinuity(PlayerEntity player, int timer) {
        PARTICLES.spawn(player, player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
    }

    private boolean onEndContinuityEvent(PlayerEntity player) {
        player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111124_b(DIABLE_JAMBE_STRENGTH_MODIFIER);
        player.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111124_b(DIABLE_JAMBE_ATTACK_SPEED_MODIFIER);
        int cooldown = 3 + (int)WyHelper.clamp(Math.round((double)this.continueTime / 40.0), 0L, 200L);
        this.setMaxCooldown(cooldown);
        IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)player);
        ExtraHachisAbility extraHachiAbl = abilityProps.getEquippedAbility(ExtraHachisAbility.INSTANCE);
        if (extraHachiAbl != null) {
            extraHachiAbl.disableDiableJambeMode();
            WyNetwork.sendToAllTrackingAndSelf(new SUpdateEquippedAbilityPacket(player, extraHachiAbl), (LivingEntity)player);
        }
        return true;
    }

    @Override
    public AbilityOverlay getPunchOverlay(LivingEntity entity) {
        return OVERLAY;
    }
}

